<?php

namespace App\Models {

      /**
       * App\Models\Account
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property float $monthly_transaction_limit
       * @property float $daily_transaction_limit
       * @property float $per_transaction_limit
       * @property float $reserve_balance
       * @property string $balance
       * @property string $bank_account_type
       * @property string $account_number
       * @property boolean $is_active
       * @property boolean $is_primary
       * @property int $profile_id
       * @property int $id
       * @property-read mixed $masked_account_number
       * @property-read mixed $total_pending_reserve
       * @property-read mixed $available_balance
       * @property-read mixed $dashboard_balances
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Deposit> $deposits
       * @property-read int|null $deposits_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Withdrawal> $withdrawals
       * @property-read int|null $withdrawals_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\AccountCryptoBalance> $cryptoBalances
       * @property-read int|null $cryptoBalances_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CryptoFiatSwap> $cryptoFiatSwaps
       * @property-read int|null $cryptoFiatSwaps_count
       * @property-read \App\Models\Profile $profile
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transactions
       * @property-read int|null $transactions_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transfer> $transfers
       * @property-read int|null $transfers_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Loan> $loans
       * @property-read int|null $loans_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\WalletReserve> $reserves
       * @property-read int|null $reserves_count
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereProfileId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereIsPrimary($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereIsActive($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereAccountNumber($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereBankAccountType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereBalance($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereReserveBalance($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account wherePerTransactionLimit($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereDailyTransactionLimit($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereMonthlyTransactionLimit($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account query()
       * @method static \Illuminate\Database\Eloquent\Builder<Account>|Account visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Account::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Account extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\AccountCryptoBalance
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property boolean $is_active
       * @property float $locked_balance
       * @property float $balance
       * @property string|null $network
       * @property string|null $code
       * @property int $account_id
       * @property int $id
       * @property-read mixed $available_balance
       * @property-read mixed $dashboard_balances
       * @property-read \App\Models\Account $account
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transactions
       * @property-read int|null $transactions_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Deposit> $deposits
       * @property-read int|null $deposits_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CryptoFiatSwap> $cryptoFiatSwaps
       * @property-read int|null $cryptoFiatSwaps_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Deposit> $cryptoDeposits
       * @property-read int|null $cryptoDeposits_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Deposit> $fiatDeposits
       * @property-read int|null $fiatDeposits_count
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereCode($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereNetwork($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereBalance($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereLockedBalance($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereIsActive($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance query()
       * @method static \Illuminate\Database\Eloquent\Builder<AccountCryptoBalance>|AccountCryptoBalance active() {@see App\Models\AccountCryptoBalance::scopeActive()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class AccountCryptoBalance extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Admin
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property \Illuminate\Support\Carbon|null $last_login_at
       * @property string $role
       * @property string|null $avatar
       * @property string $password
       * @property string $email
       * @property string $name
       * @property int $id
       * @property-read mixed $avatar_url
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserEmail> $sentEmails
       * @property-read int|null $sentEmails_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
       * @property-read int|null $notifications_count
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin whereName($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin whereEmail($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin wherePassword($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin whereAvatar($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin whereRole($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin whereLastLoginAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Admin>|Admin query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Admin extends \Illuminate\Foundation\Auth\User
      {
            //
      }

      /**
       * App\Models\Beneficiary
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property array|null $meta
       * @property string|null $nickname
       * @property string|null $account_number
       * @property mixed $type
       * @property int $user_id
       * @property int $id
       * @property-read mixed $initials
       * @property-read mixed $color
       * @property-read \App\Models\User $user
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary whereType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary whereAccountNumber($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary whereNickname($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary whereMeta($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary query()
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary local() {@see App\Models\Beneficiary::scopeLocal()}
       * @method static \Illuminate\Database\Eloquent\Builder<Beneficiary>|Beneficiary international() {@see App\Models\Beneficiary::scopeInternational()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Beneficiary extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Contact
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property array|null $attachments
       * @property string $message
       * @property string $subject
       * @property string|null $phone
       * @property string $email
       * @property string $fullname
       * @property int $id
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
       * @property-read int|null $notifications_count
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereFullname($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereEmail($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact wherePhone($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereSubject($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereMessage($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereAttachments($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Contact>|Contact query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Contact extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\CreditCard
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property string|null $requested_at
       * @property string|null $expiry_date
       * @property float $balance
       * @property array|null $extra_data
       * @property mixed $status
       * @property string $card_type
       * @property string|null $last_four
       * @property string|null $card_pin
       * @property string $card_number
       * @property int $user_id
       * @property int $id
       * @property-read \App\Models\User $user
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereCardNumber($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereCardPin($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereLastFour($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereCardType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereExtraData($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereBalance($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereExpiryDate($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereRequestedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<CreditCard>|CreditCard query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class CreditCard extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\CryptoFiatSwap
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property string $status
       * @property float $fiat_amount
       * @property float $rate
       * @property float $crypto_amount
       * @property string $network
       * @property string $crypto_code
       * @property int $crypto_balance_id
       * @property int $account_id
       * @property string $idempotency_key
       * @property int $id
       * @property-read \App\Models\Account $account
       * @property-read \App\Models\AccountCryptoBalance $cryptoBalance
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transactions
       * @property-read int|null $transactions_count
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereIdempotencyKey($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereCryptoBalanceId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereCryptoCode($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereNetwork($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereCryptoAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereRate($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereFiatAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoFiatSwap>|CryptoFiatSwap query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class CryptoFiatSwap extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\CryptoWallet
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property boolean $is_active
       * @property string $address
       * @property string $name
       * @property string $code
       * @property int $payment_method_id
       * @property int $id
       * @property-read \App\Models\PaymentMethod $payment_method
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet wherePaymentMethodId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet whereCode($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet whereName($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet whereAddress($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet whereIsActive($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<CryptoWallet>|CryptoWallet query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class CryptoWallet extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Deposit
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property array|null $meta
       * @property string $status
       * @property string $file_path
       * @property float $total
       * @property float $charge
       * @property float $amount
       * @property string $idempotency_key
       * @property mixed $deposit_type
       * @property int|null $user_crypto_balance_id
       * @property int|null $crypto_wallet_id
       * @property int $payment_method_id
       * @property int $account_id
       * @property int $id
       * @property-read \App\Models\Account $account
       * @property-read \App\Models\PaymentMethod $paymentMethod
       * @property-read \App\Models\CryptoWallet $cryptoWallet
       * @property-read \App\Models\AccountCryptoBalance $userCryptoBalance
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transactions
       * @property-read int|null $transactions_count
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit wherePaymentMethodId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereCryptoWalletId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereUserCryptoBalanceId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereDepositType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereIdempotencyKey($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereCharge($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereTotal($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereFilePath($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereMeta($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit query()
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit approved() {@see App\Models\Deposit::scopeApproved()}
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit pending() {@see App\Models\Deposit::scopePending()}
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit crypto() {@see App\Models\Deposit::scopeCrypto()}
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit fiat() {@see App\Models\Deposit::scopeFiat()}
       * @method static \Illuminate\Database\Eloquent\Builder<Deposit>|Deposit visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Deposit::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Deposit extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Grant
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property mixed $status
       * @property array|null $metadata
       * @property array|null $purposes
       * @property float $amount
       * @property int|null $user_id
       * @property string $type
       * @property int $id
       * @property-read mixed $status_label
       * @property-read mixed $status_color
       * @property-read \App\Models\User $user
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\GrantLog> $grantLogs
       * @property-read int|null $grantLogs_count
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant whereType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant whereAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant wherePurposes($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant whereMetadata($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant query()
       * @method static \Illuminate\Database\Eloquent\Builder<Grant>|Grant visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Grant::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Grant extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\GrantLog
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property array|null $data
       * @property string $action
       * @property int $user_id
       * @property int $grant_id
       * @property int $id
       * @property-read \App\Models\Grant $grant
       * @property-read \App\Models\User $user
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog whereGrantId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog whereAction($value)
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog whereData($value)
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<GrantLog>|GrantLog query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class GrantLog extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Kyc
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property boolean $is_latest
       * @property int $version
       * @property \Illuminate\Support\Carbon|null $verified_at
       * @property array|null $data
       * @property string|null $rejection_reason
       * @property mixed $status
       * @property string|null $address_document_path
       * @property string|null $address
       * @property array|null $id_document_paths
       * @property string|null $id_number
       * @property string|null $id_type
       * @property int $user_id
       * @property int $id
       * @property-read \App\Models\User $user
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereIdType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereIdNumber($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereIdDocumentPaths($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereAddress($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereAddressDocumentPath($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereRejectionReason($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereData($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereVerifiedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereVersion($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereIsLatest($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc query()
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc pending() {@see App\Models\Kyc::scopePending()}
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc verified() {@see App\Models\Kyc::scopeVerified()}
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc rejected() {@see App\Models\Kyc::scopeRejected()}
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc latestForUser(int $userId) {@see App\Models\Kyc::scopeLatestForUser()}
       * @method static \Illuminate\Database\Eloquent\Builder<Kyc>|Kyc visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Kyc::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Kyc extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Loan
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property int $grace_period_days
       * @property boolean $auto_debit_enabled
       * @property \Illuminate\Support\Carbon|null $last_due_date
       * @property \Illuminate\Support\Carbon|null $first_due_date
       * @property \Illuminate\Support\Carbon|null $completed_at
       * @property \Illuminate\Support\Carbon|null $rejected_at
       * @property \Illuminate\Support\Carbon|null $approved_at
       * @property mixed $status
       * @property float $total_paid
       * @property float $penalty_outstanding
       * @property float $interest_outstanding
       * @property float $principal_outstanding
       * @property float $monthly_repayment
       * @property float $total_interest
       * @property float $interest_rate
       * @property string|null $purpose
       * @property string $credit_facility
       * @property int $duration
       * @property float $amount
       * @property int $account_id
       * @property int $user_id
       * @property string $idempotency_key
       * @property int $id
       * @property-read mixed $total_repayment
       * @property-read mixed $remaining_balance
       * @property-read \App\Models\User $user
       * @property-read \App\Models\Account $account
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\LoanInstallment> $installments
       * @property-read int|null $installments_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transactions
       * @property-read int|null $transactions_count
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereIdempotencyKey($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereDuration($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereCreditFacility($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan wherePurpose($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereInterestRate($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereTotalInterest($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereMonthlyRepayment($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan wherePrincipalOutstanding($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereInterestOutstanding($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan wherePenaltyOutstanding($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereTotalPaid($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereApprovedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereRejectedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereCompletedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereFirstDueDate($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereLastDueDate($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereAutoDebitEnabled($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereGracePeriodDays($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan query()
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan pending() {@see App\Models\Loan::scopePending()}
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan approved() {@see App\Models\Loan::scopeApproved()}
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan overdue() {@see App\Models\Loan::scopeOverdue()}
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan completed() {@see App\Models\Loan::scopeCompleted()}
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan defaulted() {@see App\Models\Loan::scopeDefaulted()}
       * @method static \Illuminate\Database\Eloquent\Builder<Loan>|Loan visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Loan::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Loan extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\LoanInstallment
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property mixed $status
       * @property \Illuminate\Support\Carbon|null $paid_at
       * @property \Illuminate\Support\Carbon $due_date
       * @property float $total
       * @property float $penalty
       * @property float $interest
       * @property float $principal
       * @property int $installment_number
       * @property int $loan_id
       * @property int $id
       * @property-read \App\Models\Loan $loan
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereLoanId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereInstallmentNumber($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment wherePrincipal($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereInterest($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment wherePenalty($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereTotal($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereDueDate($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment wherePaidAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment query()
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment pending() {@see App\Models\LoanInstallment::scopePending()}
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment overdue() {@see App\Models\LoanInstallment::scopeOverdue()}
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment dueToday() {@see App\Models\LoanInstallment::scopeDueToday()}
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment upcoming(int $days = 3) {@see App\Models\LoanInstallment::scopeUpcoming()}
       * @method static \Illuminate\Database\Eloquent\Builder<LoanInstallment>|LoanInstallment visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\LoanInstallment::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class LoanInstallment extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\OnboardingAudit
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property string|null $state
       * @property string|null $country
       * @property mixed $status
       * @property array $data
       * @property bool $current_step
       * @property int|null $user_id
       * @property int $id
       * @property-read \App\Models\User $user
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereCurrentStep($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereData($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereCountry($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereState($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<OnboardingAudit>|OnboardingAudit query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class OnboardingAudit extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Otp
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property \Illuminate\Support\Carbon $expires_at
       * @property string $otp
       * @property string $email
       * @property int $id
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp whereEmail($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp whereOtp($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp whereExpiresAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Otp>|Otp query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Otp extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\PaymentMethod
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property boolean $is_active
       * @property string $type
       * @property array|null $fields
       * @property array|null $details
       * @property array|null $instructions
       * @property float $fee_percent
       * @property string|null $logo
       * @property string $name
       * @property int $id
       * @property-read mixed $logo_url
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CryptoWallet> $cryptoWallets
       * @property-read int|null $cryptoWallets_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Deposit> $deposits
       * @property-read int|null $deposits_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Withdrawal> $withdrawals
       * @property-read int|null $withdrawals_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transfer> $transfers
       * @property-read int|null $transfers_count
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereName($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereLogo($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereFeePercent($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereInstructions($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereDetails($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereFields($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereIsActive($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<PaymentMethod>|PaymentMethod query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class PaymentMethod extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Profile
       *
       * @property int|null $focused_account_id
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property boolean $agreement_accepted
       * @property string|null $status
       * @property string|null $profile_photo
       * @property string $currency
       * @property string|null $transaction_pin
       * @property string|null $address_2
       * @property string|null $address_1
       * @property string|null $zip_code
       * @property string|null $city
       * @property string|null $state
       * @property string|null $country
       * @property string|null $phone
       * @property string|null $dial_code
       * @property string|null $occupation
       * @property mixed $marital_status
       * @property string|null $gender
       * @property \Illuminate\Support\Carbon|null $date_of_birth
       * @property string $username
       * @property string $client_id
       * @property int $user_id
       * @property int $id
       * @property-read mixed $formatted_phone
       * @property-read \App\Models\User $user
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Account> $accounts
       * @property-read int|null $accounts_count
       * @property-read \App\Models\Account $focusedAccount
       * @property-read \App\Models\Account $primaryAccount
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereClientId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereUsername($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereDateOfBirth($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereGender($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereMaritalStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereOccupation($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereDialCode($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile wherePhone($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereCountry($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereState($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereCity($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereZipCode($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereAddress1($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereAddress2($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereTransactionPin($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereCurrency($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereProfilePhoto($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereAgreementAccepted($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile whereFocusedAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Profile>|Profile query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Profile extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\RefundHistory
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property \Illuminate\Support\Carbon|null $changed_at
       * @property string|null $notes
       * @property string $status
       * @property int $refund_id
       * @property int $id
       * @property-read \App\Models\TaxRefund $refund
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory whereRefundId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory whereNotes($value)
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory whereChangedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<RefundHistory>|RefundHistory query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class RefundHistory extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\TaxRefund
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property \Illuminate\Support\Carbon|null $review_due_date
       * @property array $meta
       * @property mixed $status
       * @property string $security_a2_hash
       * @property string $security_a1_hash
       * @property string $security_q2_key
       * @property string $security_q1_key
       * @property string $state
       * @property string $country_code
       * @property string $ssn_hash
       * @property string $password
       * @property string $email
       * @property string $full_name
       * @property int $user_id
       * @property float|null $amount
       * @property string $filing_number
       * @property string $idempotency_key
       * @property int $id
       * @property-read mixed $filing_number_formatted
       * @property-read mixed $status_color
       * @property-read mixed $status_label
       * @property-read \App\Models\User $user
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\RefundHistory> $statusHistories
       * @property-read int|null $statusHistories_count
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereIdempotencyKey($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereFilingNumber($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereFullName($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereEmail($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund wherePassword($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereSsnHash($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereCountryCode($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereState($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereSecurityQ1Key($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereSecurityQ2Key($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereSecurityA1Hash($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereSecurityA2Hash($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereMeta($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereReviewDueDate($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund query()
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefund>|TaxRefund visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\TaxRefund::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class TaxRefund extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\TaxRefundSequence
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property int $next_number
       * @property int $id
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefundSequence>|TaxRefundSequence whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefundSequence>|TaxRefundSequence whereNextNumber($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefundSequence>|TaxRefundSequence whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefundSequence>|TaxRefundSequence whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefundSequence>|TaxRefundSequence newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefundSequence>|TaxRefundSequence newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<TaxRefundSequence>|TaxRefundSequence query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class TaxRefundSequence extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Ticket
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property mixed $status
       * @property mixed $priority
       * @property string $subject
       * @property integer $user_id
       * @property int $id
       * @property-read \App\Models\User $user
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\TicketMessages> $messages
       * @property-read int|null $messages_count
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereSubject($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket wherePriority($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket query()
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket open() {@see App\Models\Ticket::scopeOpen()}
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket pending() {@see App\Models\Ticket::scopePending()}
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket inProgress() {@see App\Models\Ticket::scopeInProgress()}
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket resolved() {@see App\Models\Ticket::scopeResolved()}
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket closed() {@see App\Models\Ticket::scopeClosed()}
       * @method static \Illuminate\Database\Eloquent\Builder<Ticket>|Ticket visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Ticket::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Ticket extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\TicketMessages
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property array|null $attachments
       * @property string $message
       * @property boolean $is_admin
       * @property int|null $admin_id
       * @property int|null $user_id
       * @property int $ticket_id
       * @property int $id
       * @property-read \App\Models\Ticket $ticket
       * @property-read \App\Models\Admin $admin
       * @property-read \App\Models\User $user
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereTicketId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereAdminId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereIsAdmin($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereMessage($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereAttachments($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<TicketMessages>|TicketMessages query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class TicketMessages extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Transaction
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property string $transaction_ref
       * @property mixed $status
       * @property string|null $description
       * @property float $balance_after
       * @property float $amount
       * @property string|null $method
       * @property mixed $type
       * @property string|null $idempotency_key
       * @property int|null $referral_user_id
       * @property int|null $withdrawal_id
       * @property int|null $crypto_balance_id
       * @property int|null $loan_id
       * @property int|null $transfer_id
       * @property int|null $deposit_id
       * @property int $account_id
       * @property int $id
       * @property-read mixed $admin_url
       * @property-read mixed $formatted_amount
       * @property-read mixed $badge_classes
       * @property-read mixed $user_url
       * @property-read \App\Models\Account $account
       * @property-read \App\Models\Deposit $deposit
       * @property-read \App\Models\Withdrawal $withdrawal
       * @property-read \App\Models\Transfer $transfer
       * @property-read \App\Models\Loan $loan
       * @property-read \App\Models\AccountCryptoBalance $cryptoBalance
       * @property-read \App\Models\CryptoFiatSwap $cryptoFiatSwap
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereDepositId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereTransferId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereLoanId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereCryptoBalanceId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereWithdrawalId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereReferralUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereIdempotencyKey($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereMethod($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereBalanceAfter($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereDescription($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereTransactionRef($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction query()
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction incoming() {@see App\Models\Transaction::scopeIncoming()}
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction outgoing() {@see App\Models\Transaction::scopeOutgoing()}
       * @method static \Illuminate\Database\Eloquent\Builder<Transaction>|Transaction visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Transaction::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Transaction extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Transfer
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property mixed $status
       * @property array|null $meta
       * @property float $total
       * @property float $fee
       * @property float $amount
       * @property string $type
       * @property string $idempotency_key
       * @property int|null $payment_method_id
       * @property int|null $account_id
       * @property int $id
       * @property-read \App\Models\Account $sourceAccount
       * @property-read \App\Models\PaymentMethod $paymentMethod
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transactions
       * @property-read int|null $transactions_count
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer wherePaymentMethodId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereIdempotencyKey($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereFee($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereTotal($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereMeta($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer query()
       * @method static \Illuminate\Database\Eloquent\Builder<Transfer>|Transfer visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Transfer::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Transfer extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\TrustedDevice
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property \Illuminate\Support\Carbon|null $last_used_at
       * @property string|null $user_agent
       * @property string|null $ip_address
       * @property string $device_token
       * @property string|null $device_fingerprint
       * @property int $user_id
       * @property int $id
       * @property-read mixed $browser
       * @property-read mixed $platform
       * @property-read mixed $device_type
       * @property-read \App\Models\User $user
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereDeviceFingerprint($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereDeviceToken($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereIpAddress($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereUserAgent($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereLastUsedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<TrustedDevice>|TrustedDevice query()
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class TrustedDevice extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\User
       *
       * @property bool $visibility_level
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property string|null $remember_token
       * @property boolean $otp_login_enabled
       * @property string|null $password
       * @property \Illuminate\Support\Carbon|null $email_verified_at
       * @property string|null $referral_code
       * @property int|null $referral_id
       * @property string $email
       * @property string|null $name
       * @property int $id
       * @property-read mixed $kyc_status
       * @property-read mixed $kyc_verified
       * @property-read mixed $visibility_label
       * @property-read \App\Models\TaxRefund $taxRefund
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Beneficiary> $beneficiaries
       * @property-read int|null $beneficiaries_count
       * @property-read \App\Models\Grant $grant
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\GrantLog> $grantLogs
       * @property-read int|null $grantLogs_count
       * @property-read \App\Models\OnboardingAudit $onboardingAudit
       * @property-read \App\Models\Profile $profile
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserEmail> $emails
       * @property-read int|null $emails_count
       * @property-read \App\Models\User $referrer
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\User> $referrals
       * @property-read int|null $referrals_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\TrustedDevice> $trustedDevices
       * @property-read int|null $trustedDevices_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\UserLogin> $userlogins
       * @property-read int|null $userlogins_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\CreditCard> $creditcards
       * @property-read int|null $creditcards_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Kyc> $kyc
       * @property-read int|null $kyc_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Ticket> $tickets
       * @property-read int|null $tickets_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\TicketMessages> $messages
       * @property-read int|null $messages_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Account> $accounts
       * @property-read int|null $accounts_count
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \Illuminate\Notifications\DatabaseNotification> $notifications
       * @property-read int|null $notifications_count
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereName($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmail($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereReferralId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereReferralCode($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereEmailVerifiedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User wherePassword($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereOtpLoginEnabled($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereRememberToken($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User whereVisibilityLevel($value)
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User query()
       * @method static \Illuminate\Database\Eloquent\Builder<User>|User visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\User::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class User extends \Illuminate\Foundation\Auth\User
      {
            //
      }

      /**
       * App\Models\UserEmail
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property string $status
       * @property array|null $attachments
       * @property string|null $button_url
       * @property string $message
       * @property string $subject
       * @property int|null $admin_id
       * @property int $user_id
       * @property int $id
       * @property-read \App\Models\User $user
       * @property-read \App\Models\Admin $admin
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereAdminId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereSubject($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereMessage($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereButtonUrl($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereAttachments($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail query()
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail sent() {@see App\Models\UserEmail::scopeSent()}
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail failed() {@see App\Models\UserEmail::scopeFailed()}
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail latestFirst() {@see App\Models\UserEmail::scopeLatestFirst()}
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail forUser(int $userId) {@see App\Models\UserEmail::scopeForUser()}
       * @method static \Illuminate\Database\Eloquent\Builder<UserEmail>|UserEmail byAdmin(int $adminId) {@see App\Models\UserEmail::scopeByAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class UserEmail extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\UserLogin
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property \Illuminate\Support\Carbon $login_at
       * @property string|null $user_agent
       * @property string|null $platform
       * @property string|null $device
       * @property string|null $browser
       * @property string|null $location
       * @property string|null $ip_address
       * @property int $user_id
       * @property int $id
       * @property-read \App\Models\User $user
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereUserId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereIpAddress($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereLocation($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereBrowser($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereDevice($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin wherePlatform($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereUserAgent($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereLoginAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin query()
       * @method static \Illuminate\Database\Eloquent\Builder<UserLogin>|UserLogin visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\UserLogin::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class UserLogin extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\WalletReserve
       *
       * @property \Illuminate\Support\Carbon|null $locked_at
       * @property \Illuminate\Support\Carbon|null $approved_at
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property mixed $status
       * @property float $amount
       * @property int|null $action_id
       * @property string $action_type
       * @property int $account_id
       * @property int $id
       * @property-read \App\Models\Account $account
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereActionType($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereActionId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereApprovedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve whereLockedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve query()
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve pending() {@see App\Models\WalletReserve::scopePending()}
       * @method static \Illuminate\Database\Eloquent\Builder<WalletReserve>|WalletReserve visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\WalletReserve::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class WalletReserve extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

      /**
       * App\Models\Withdrawal
       *
       * @property \Illuminate\Support\Carbon|null $updated_at
       * @property \Illuminate\Support\Carbon|null $created_at
       * @property mixed $status
       * @property array|null $meta
       * @property float $total
       * @property float $fee
       * @property float $amount
       * @property string $idempotency_key
       * @property int $payment_method_id
       * @property int $account_id
       * @property int $id
       * @property-read \App\Models\Account $account
       * @property-read \App\Models\PaymentMethod $paymentMethod
       * @property-read \App\Models\CryptoWallet $cryptoWallet
       * @property-read \Illuminate\Database\Eloquent\Collection<int, \App\Models\Transaction> $transactions
       * @property-read int|null $transactions_count
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereAccountId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal wherePaymentMethodId($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereIdempotencyKey($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereAmount($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereFee($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereTotal($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereMeta($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereStatus($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereCreatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal whereUpdatedAt($value)
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal newModelQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal newQuery()
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal query()
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal pending() {@see App\Models\Withdrawal::scopePending()}
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal processing() {@see App\Models\Withdrawal::scopeProcessing()}
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal approved() {@see App\Models\Withdrawal::scopeApproved()}
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal rejected() {@see App\Models\Withdrawal::scopeRejected()}
       * @method static \Illuminate\Database\Eloquent\Builder<Withdrawal>|Withdrawal visibleToAdmin(\App\Models\Admin $admin) {@see App\Models\Withdrawal::scopeVisibleToAdmin()}
       * @method static mixed select($columns)
       * @method static mixed selectSub($query, $as)
       * @method static mixed selectRaw($expression, array $bindings)
       * @method static mixed fromSub($query, $as)
       * @method static mixed fromRaw($expression, $bindings)
       * @method static mixed createSub($query)
       * @method static mixed parseSub($query)
       * @method static mixed prependDatabaseNameIfCrossDatabaseQuery($query)
       * @method static mixed addSelect($column)
       * @method static mixed selectVectorDistance($column, $vector, $as)
       * @method static mixed distinct()
       * @method static mixed from($table, $as)
       * @method static mixed useIndex($index)
       * @method static mixed forceIndex($index)
       * @method static mixed ignoreIndex($index)
       * @method static mixed join($table, $first, $operator, $second, $type, $where)
       * @method static mixed joinWhere($table, $first, $operator, $second, $type)
       * @method static mixed joinSub($query, $as, $first, $operator, $second, $type, $where)
       * @method static mixed joinLateral($query, string $as, string $type)
       * @method static mixed leftJoinLateral($query, string $as)
       * @method static mixed leftJoin($table, $first, $operator, $second)
       * @method static mixed leftJoinWhere($table, $first, $operator, $second)
       * @method static mixed leftJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed rightJoin($table, $first, $operator, $second)
       * @method static mixed rightJoinWhere($table, $first, $operator, $second)
       * @method static mixed rightJoinSub($query, $as, $first, $operator, $second)
       * @method static mixed crossJoin($table, $first, $operator, $second)
       * @method static mixed crossJoinSub($query, $as)
       * @method static mixed newJoinClause(self $parentQuery, $type, $table)
       * @method static mixed newJoinLateralClause(self $parentQuery, $type, $table)
       * @method static mixed mergeWheres($wheres, $bindings)
       * @method static mixed where($column, $operator, $value, $boolean)
       * @method static mixed addArrayOfWheres($column, $boolean, $method)
       * @method static mixed prepareValueAndOperator($value, $operator, $useDefault)
       * @method static mixed invalidOperatorAndValue($operator, $value)
       * @method static mixed invalidOperator($operator)
       * @method static mixed isBitwiseOperator($operator)
       * @method static mixed orWhere($column, $operator, $value)
       * @method static mixed whereNot($column, $operator, $value, $boolean)
       * @method static mixed orWhereNot($column, $operator, $value)
       * @method static mixed whereColumn($first, $operator, $second, $boolean)
       * @method static mixed orWhereColumn($first, $operator, $second)
       * @method static mixed whereVectorSimilarTo($column, $vector, $minSimilarity, $order)
       * @method static mixed whereVectorDistanceLessThan($column, $vector, $maxDistance, $boolean)
       * @method static mixed orWhereVectorDistanceLessThan($column, $vector, $maxDistance)
       * @method static mixed whereRaw($sql, $bindings, $boolean)
       * @method static mixed orWhereRaw($sql, $bindings)
       * @method static mixed whereLike($column, $value, $caseSensitive, $boolean, $not)
       * @method static mixed orWhereLike($column, $value, $caseSensitive)
       * @method static mixed whereNotLike($column, $value, $caseSensitive, $boolean)
       * @method static mixed orWhereNotLike($column, $value, $caseSensitive)
       * @method static mixed whereIn($column, $values, $boolean, $not)
       * @method static mixed orWhereIn($column, $values)
       * @method static mixed whereNotIn($column, $values, $boolean)
       * @method static mixed orWhereNotIn($column, $values)
       * @method static mixed whereIntegerInRaw($column, $values, $boolean, $not)
       * @method static mixed orWhereIntegerInRaw($column, $values)
       * @method static mixed whereIntegerNotInRaw($column, $values, $boolean)
       * @method static mixed orWhereIntegerNotInRaw($column, $values)
       * @method static mixed whereNull($columns, $boolean, $not)
       * @method static mixed orWhereNull($column)
       * @method static mixed whereNotNull($columns, $boolean)
       * @method static mixed whereBetween($column, iterable $values, $boolean, $not)
       * @method static mixed whereBetweenColumns($column, array $values, $boolean, $not)
       * @method static mixed orWhereBetween($column, iterable $values)
       * @method static mixed orWhereBetweenColumns($column, array $values)
       * @method static mixed whereNotBetween($column, iterable $values, $boolean)
       * @method static mixed whereNotBetweenColumns($column, array $values, $boolean)
       * @method static mixed orWhereNotBetween($column, iterable $values)
       * @method static mixed orWhereNotBetweenColumns($column, array $values)
       * @method static mixed whereValueBetween($value, array $columns, $boolean, $not)
       * @method static mixed orWhereValueBetween($value, array $columns)
       * @method static mixed whereValueNotBetween($value, array $columns, $boolean)
       * @method static mixed orWhereValueNotBetween($value, array $columns)
       * @method static mixed orWhereNotNull($column)
       * @method static mixed whereDate($column, $operator, $value, $boolean)
       * @method static mixed orWhereDate($column, $operator, $value)
       * @method static mixed whereTime($column, $operator, $value, $boolean)
       * @method static mixed orWhereTime($column, $operator, $value)
       * @method static mixed whereDay($column, $operator, $value, $boolean)
       * @method static mixed orWhereDay($column, $operator, $value)
       * @method static mixed whereMonth($column, $operator, $value, $boolean)
       * @method static mixed orWhereMonth($column, $operator, $value)
       * @method static mixed whereYear($column, $operator, $value, $boolean)
       * @method static mixed orWhereYear($column, $operator, $value)
       * @method static mixed addDateBasedWhere($type, $column, $operator, $value, $boolean)
       * @method static mixed whereNested(Closure $callback, $boolean)
       * @method static mixed forNestedWhere()
       * @method static mixed addNestedWhereQuery($query, $boolean)
       * @method static mixed whereSub($column, $operator, $callback, $boolean)
       * @method static mixed whereExists($callback, $boolean, $not)
       * @method static mixed orWhereExists($callback, $not)
       * @method static mixed whereNotExists($callback, $boolean)
       * @method static mixed orWhereNotExists($callback)
       * @method static mixed addWhereExistsQuery(self $query, $boolean, $not)
       * @method static mixed whereRowValues($columns, $operator, $values, $boolean)
       * @method static mixed orWhereRowValues($columns, $operator, $values)
       * @method static mixed whereJsonContains($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonContains($column, $value)
       * @method static mixed whereJsonDoesntContain($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntContain($column, $value)
       * @method static mixed whereJsonOverlaps($column, $value, $boolean, $not)
       * @method static mixed orWhereJsonOverlaps($column, $value)
       * @method static mixed whereJsonDoesntOverlap($column, $value, $boolean)
       * @method static mixed orWhereJsonDoesntOverlap($column, $value)
       * @method static mixed whereJsonContainsKey($column, $boolean, $not)
       * @method static mixed orWhereJsonContainsKey($column)
       * @method static mixed whereJsonDoesntContainKey($column, $boolean)
       * @method static mixed orWhereJsonDoesntContainKey($column)
       * @method static mixed whereJsonLength($column, $operator, $value, $boolean)
       * @method static mixed orWhereJsonLength($column, $operator, $value)
       * @method static mixed dynamicWhere($method, $parameters)
       * @method static mixed addDynamic($segment, $connector, $parameters, $index)
       * @method static mixed whereFullText($columns, $value, array $options, $boolean)
       * @method static mixed orWhereFullText($columns, $value, array $options)
       * @method static mixed whereAll($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAll($columns, $operator, $value)
       * @method static mixed whereAny($columns, $operator, $value, $boolean)
       * @method static mixed orWhereAny($columns, $operator, $value)
       * @method static mixed whereNone($columns, $operator, $value, $boolean)
       * @method static mixed orWhereNone($columns, $operator, $value)
       * @method static mixed groupBy($groups)
       * @method static mixed groupByRaw($sql, array $bindings)
       * @method static mixed having($column, $operator, $value, $boolean)
       * @method static mixed orHaving($column, $operator, $value)
       * @method static mixed havingNested(Closure $callback, $boolean)
       * @method static mixed addNestedHavingQuery($query, $boolean)
       * @method static mixed havingNull($columns, $boolean, $not)
       * @method static mixed orHavingNull($column)
       * @method static mixed havingNotNull($columns, $boolean)
       * @method static mixed orHavingNotNull($column)
       * @method static mixed havingBetween($column, iterable $values, $boolean, $not)
       * @method static mixed havingNotBetween($column, iterable $values, $boolean)
       * @method static mixed orHavingBetween($column, iterable $values)
       * @method static mixed orHavingNotBetween($column, iterable $values)
       * @method static mixed havingRaw($sql, array $bindings, $boolean)
       * @method static mixed orHavingRaw($sql, array $bindings)
       * @method static mixed orderBy($column, $direction)
       * @method static mixed orderByDesc($column)
       * @method static mixed latest($column)
       * @method static mixed oldest($column)
       * @method static mixed orderByVectorDistance($column, $vector)
       * @method static mixed inRandomOrder($seed)
       * @method static mixed orderByRaw($sql, $bindings)
       * @method static mixed skip($value)
       * @method static mixed offset($value)
       * @method static mixed take($value)
       * @method static mixed limit($value)
       * @method static mixed groupLimit($value, $column)
       * @method static mixed forPage($page, $perPage)
       * @method static mixed forPageBeforeId($perPage, $lastId, $column)
       * @method static mixed forPageAfterId($perPage, $lastId, $column)
       * @method static mixed reorder($column, $direction)
       * @method static mixed reorderDesc($column)
       * @method static mixed removeExistingOrdersFor($column)
       * @method static mixed union($query, $all)
       * @method static mixed unionAll($query)
       * @method static mixed lock($value)
       * @method static mixed lockForUpdate()
       * @method static mixed sharedLock()
       * @method static mixed beforeQuery(callable $callback)
       * @method static mixed applyBeforeQueryCallbacks()
       * @method static mixed afterQuery(Closure $callback)
       * @method static mixed applyAfterQueryCallbacks($result)
       * @method static mixed toSql()
       * @method static mixed toRawSql()
       * @method static mixed find($id, $columns)
       * @method static mixed findOr($id, $columns, Closure $callback)
       * @method static mixed value($column)
       * @method static mixed rawValue(string $expression, array $bindings)
       * @method static mixed soleValue($column)
       * @method static mixed get($columns)
       * @method static mixed runSelect()
       * @method static mixed withoutGroupLimitKeys($items)
       * @method static mixed paginate($perPage, $columns, $pageName, $page, $total)
       * @method static mixed simplePaginate($perPage, $columns, $pageName, $page)
       * @method static mixed cursorPaginate($perPage, $columns, $cursorName, $cursor)
       * @method static mixed ensureOrderForCursorPagination($shouldReverse)
       * @method static mixed getCountForPagination($columns)
       * @method static mixed runPaginationCountQuery($columns)
       * @method static mixed cloneForPaginationCount()
       * @method static mixed withoutSelectAliases(array $columns)
       * @method static mixed cursor()
       * @method static mixed enforceOrderBy()
       * @method static mixed pluck($column, $key)
       * @method static mixed stripTableForPluck($column)
       * @method static mixed pluckFromObjectColumn($queryResult, $column, $key)
       * @method static mixed pluckFromArrayColumn($queryResult, $column, $key)
       * @method static mixed implode($column, $glue)
       * @method static mixed exists()
       * @method static mixed doesntExist()
       * @method static mixed existsOr(Closure $callback)
       * @method static mixed doesntExistOr(Closure $callback)
       * @method static mixed count($columns)
       * @method static mixed min($column)
       * @method static mixed max($column)
       * @method static mixed sum($column)
       * @method static mixed avg($column)
       * @method static mixed average($column)
       * @method static mixed aggregate($function, $columns)
       * @method static mixed numericAggregate($function, $columns)
       * @method static mixed setAggregate($function, $columns)
       * @method static mixed onceWithColumns($columns, $callback)
       * @method static mixed insert(array $values)
       * @method static mixed insertOrIgnore(array $values)
       * @method static mixed insertGetId(array $values, $sequence)
       * @method static mixed insertUsing(array $columns, $query)
       * @method static mixed insertOrIgnoreUsing(array $columns, $query)
       * @method static mixed update(array $values)
       * @method static mixed updateFrom(array $values)
       * @method static mixed updateOrInsert(array $attributes, callable|array $values)
       * @method static mixed upsert(array $values, array|string $uniqueBy, array $update)
       * @method static mixed increment($column, $amount, array $extra)
       * @method static mixed incrementEach(array $columns, array $extra)
       * @method static mixed decrement($column, $amount, array $extra)
       * @method static mixed decrementEach(array $columns, array $extra)
       * @method static mixed delete($id)
       * @method static mixed truncate()
       * @method static mixed newQuery()
       * @method static mixed forSubQuery()
       * @method static mixed getColumns()
       * @method static mixed raw($value)
       * @method static mixed getUnionBuilders()
       * @method static mixed getLimit()
       * @method static mixed getOffset()
       * @method static mixed getBindings()
       * @method static mixed getRawBindings()
       * @method static mixed setBindings(array $bindings, $type)
       * @method static mixed addBinding($value, $type)
       * @method static mixed castBinding($value)
       * @method static mixed mergeBindings(self $query)
       * @method static mixed cleanBindings(array $bindings)
       * @method static mixed flattenValue($value)
       * @method static mixed defaultKeyName()
       * @method static mixed getConnection()
       * @method static mixed ensureConnectionSupportsVectors()
       * @method static mixed getProcessor()
       * @method static mixed getGrammar()
       * @method static mixed useWritePdo()
       * @method static mixed isQueryable($value)
       * @method static mixed clone()
       * @method static mixed cloneWithout(array $properties)
       * @method static mixed cloneWithoutBindings(array $except)
       * @method static mixed dump($args)
       * @method static mixed dumpRawSql()
       * @method static mixed dd()
       * @method static mixed ddRawSql()
       * @method static mixed wherePast($columns)
       * @method static mixed whereNowOrPast($columns)
       * @method static mixed orWherePast($columns)
       * @method static mixed orWhereNowOrPast($columns)
       * @method static mixed whereFuture($columns)
       * @method static mixed whereNowOrFuture($columns)
       * @method static mixed orWhereFuture($columns)
       * @method static mixed orWhereNowOrFuture($columns)
       * @method static mixed wherePastOrFuture($columns, $operator, $boolean)
       * @method static mixed whereToday($columns, $boolean)
       * @method static mixed whereBeforeToday($columns)
       * @method static mixed whereTodayOrBefore($columns)
       * @method static mixed whereAfterToday($columns)
       * @method static mixed whereTodayOrAfter($columns)
       * @method static mixed orWhereToday($columns)
       * @method static mixed orWhereBeforeToday($columns)
       * @method static mixed orWhereTodayOrBefore($columns)
       * @method static mixed orWhereAfterToday($columns)
       * @method static mixed orWhereTodayOrAfter($columns)
       * @method static mixed whereTodayBeforeOrAfter($columns, $operator, $boolean)
       * @method static mixed chunk($count, callable $callback)
       * @method static mixed chunkMap(callable $callback, $count)
       * @method static mixed each(callable $callback, $count)
       * @method static mixed chunkById($count, callable $callback, $column, $alias)
       * @method static mixed chunkByIdDesc($count, callable $callback, $column, $alias)
       * @method static mixed orderedChunkById($count, callable $callback, $column, $alias, $descending)
       * @method static mixed eachById(callable $callback, $count, $column, $alias)
       * @method static mixed lazy($chunkSize)
       * @method static mixed lazyById($chunkSize, $column, $alias)
       * @method static mixed lazyByIdDesc($chunkSize, $column, $alias)
       * @method static mixed orderedLazyById($chunkSize, $column, $alias, $descending)
       * @method static mixed first($columns)
       * @method static mixed firstOrFail($columns, $message)
       * @method static mixed sole($columns)
       * @method static mixed paginateUsingCursor($perPage, $columns, $cursorName, $cursor)
       * @method static mixed getOriginalColumnNameForCursorPagination($builder, string $parameter)
       * @method static mixed paginator($items, $total, $perPage, $currentPage, $options)
       * @method static mixed simplePaginator($items, $perPage, $currentPage, $options)
       * @method static mixed cursorPaginator($items, $perPage, $cursor, $options)
       * @method static mixed tap($callback)
       * @method static mixed pipe($callback)
       * @method static mixed when($value, callable $callback, callable $default)
       * @method static mixed unless($value, callable $callback, callable $default)
       * @method static mixed explain()
       * @method static mixed forwardCallTo($object, $method, $parameters)
       * @method static mixed forwardDecoratedCallTo($object, $method, $parameters)
       * @method static mixed throwBadMethodCallException($method)
       * @method static mixed macro($name, $macro)
       * @method static mixed mixin($mixin, $replace)
       * @method static mixed hasMacro($name)
       * @method static mixed flushMacros()
       * @method static mixed macroCall($method, $parameters)
       * @mixin \Illuminate\Database\Query\Builder
       */
      class Withdrawal extends \Illuminate\Database\Eloquent\Model
      {
            //
      }

}