<!DOCTYPE html>
<html x-data="{
    darkMode: false,
    mobileMenuOpen: false
}" x-init="darkMode = localStorage.getItem('darkMode') === 'true' ||
    (!localStorage.getItem('darkMode') &&
        window.matchMedia('(prefers-color-scheme: dark)').matches);

$watch('darkMode', value => {
    localStorage.setItem('darkMode', value);
});" :class="{ 'dark': darkMode }" class="scroll-smooth">

<head>
    <?php echo $__env->make('partials.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <script>
        if (
            localStorage.getItem('darkMode') === 'true' ||
            (!localStorage.getItem('darkMode') &&
                window.matchMedia('(prefers-color-scheme: dark)').matches)
        ) {
            document.documentElement.classList.add('dark');
        }
    </script>
    <meta name="robots" content="index, follow">
</head>

<body class="min-h-screen bg-white dark:bg-zinc-800" x-data="{ opensidebar: false }" :class="{ 'overflow-hidden': opensidebar }">

    <?php
        $avatarUrl =
            $authUser->profile->profile_photo && Storage::disk('public')->exists($authUser->profile->profile_photo)
                ? Storage::disk('public')->url($authUser->profile->profile_photo)
                : null;
    ?>
    <!-- MOBILE SIDEBAR -->
    <aside x-show="opensidebar" x-cloak x-transition:enter="transition-transform duration-300"
        x-transition:enter-start="-translate-x-full" x-transition:enter-end="translate-x-0"
        x-transition:leave="transition-transform duration-300" x-transition:leave-start="translate-x-0"
        x-transition:leave-end="-translate-x-full"
        class="fixed inset-y-0 left-0 z-30 w-64 bg-white dark:bg-zinc-900 border-r border-gray-200 dark:border-zinc-700 flex flex-col lg:hidden">
        <!-- Brand -->
        <div class="px-6 py-6 border-b border-gray-200 dark:border-zinc-700">
            <div class="flex items-center gap-3 group">
                <div
                    class="h-10 w-10 rounded-xl bg-[#0E4D92] text-white flex items-center justify-center
                group-hover:scale-105 transition">
                    <?php if (isset($component)) { $__componentOriginal159d6670770cb479b1921cea6416c26c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal159d6670770cb479b1921cea6416c26c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-logo-icon','data' => ['class' => 'h-5 w-5 fill-current']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-logo-icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'h-5 w-5 fill-current']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal159d6670770cb479b1921cea6416c26c)): ?>
<?php $attributes = $__attributesOriginal159d6670770cb479b1921cea6416c26c; ?>
<?php unset($__attributesOriginal159d6670770cb479b1921cea6416c26c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal159d6670770cb479b1921cea6416c26c)): ?>
<?php $component = $__componentOriginal159d6670770cb479b1921cea6416c26c; ?>
<?php unset($__componentOriginal159d6670770cb479b1921cea6416c26c); ?>
<?php endif; ?>
                </div>
                <span class="text-lg font-bold tracking-wide text-gray-900 dark:text-white">
                    <?php echo e(config('app.name')); ?>

                </span>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 py-2 px-1 space-y-4 text-sm overflow-y-auto">
            <?php echo $__env->make('partials.admin.sidebar-links', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </nav>

        <!-- User / Footer -->
        <?php echo $__env->make('partials.admin.sidebar-footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </aside>

    <!-- DESKTOP SIDEBAR -->
    <aside
        class="hidden lg:flex lg:flex-col lg:fixed lg:inset-y-0 lg:left-0 lg:w-64 bg-white dark:bg-zinc-900 border-r border-gray-200 dark:border-zinc-700 z-20">
        <!-- Brand -->
        <div class="px-6 py-6 border-b border-gray-200 dark:border-zinc-700">
            <div class="flex flex-col items-center gap-3 group">
                <div
                    class="h-10 w-10 rounded-xl bg-[#0E4D92] text-white flex items-center justify-center
                group-hover:scale-105 transition">
                    <?php if (isset($component)) { $__componentOriginal159d6670770cb479b1921cea6416c26c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal159d6670770cb479b1921cea6416c26c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app-logo-icon','data' => ['class' => 'h-5 w-5 fill-current']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-logo-icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'h-5 w-5 fill-current']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal159d6670770cb479b1921cea6416c26c)): ?>
<?php $attributes = $__attributesOriginal159d6670770cb479b1921cea6416c26c; ?>
<?php unset($__attributesOriginal159d6670770cb479b1921cea6416c26c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal159d6670770cb479b1921cea6416c26c)): ?>
<?php $component = $__componentOriginal159d6670770cb479b1921cea6416c26c; ?>
<?php unset($__componentOriginal159d6670770cb479b1921cea6416c26c); ?>
<?php endif; ?>
                </div>
                <span class="text-lg font-bold tracking-wide text-gray-900 dark:text-white">
                    <?php echo e(config('app.name')); ?>

                </span>
            </div>
        </div>

        <!-- Navigation -->
        <nav class="flex-1 py-2 px-1 space-y-4 text-sm overflow-y-auto">
            <?php echo $__env->make('partials.admin.sidebar-links', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </nav>

        <!-- User / Footer -->
        <?php echo $__env->make('partials.admin.sidebar-footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </aside>
    <?php echo e($slot); ?>


    <?php app('livewire')->forceAssetInjection(); ?>
<?php echo app('flux')->scripts(); ?>

</body>

</html>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/layouts/app/sidebar.blade.php ENDPATH**/ ?>