<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['card', 'currencySymbol']));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['card', 'currencySymbol']), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $statusClass = match ($card->status) {
        'active' => 'bg-green-100 text-green-800',
        'pending' => 'bg-yellow-100 text-yellow-800',
        'blocked' => 'bg-red-100 text-red-800',
        default => 'bg-gray-100 text-gray-800',
    };

    $cardBgClass = match (strtolower($card->card_type)) {
        'visa' => 'from-blue-800 via-blue-600 to-blue-500',
        'mastercard' => 'from-red-600 via-orange-500 to-yellow-400',
        'amex' => 'from-green-600 via-teal-500 to-cyan-400',
        'discover' => 'from-purple-600 via-pink-500 to-indigo-400',
        default => 'from-gray-600 via-gray-500 to-gray-400',
    };

    $chipClass = match (strtolower($card->card_type)) {
        'visa' => 'from-yellow-400 to-yellow-500',
        'mastercard' => 'from-red-400 to-orange-500',
        'amex' => 'from-green-400 to-teal-500',
        'discover' => 'from-purple-400 to-pink-500',
        default => 'from-gray-400 to-gray-500',
    };
?>

<div
    class="bg-white/80 dark:bg-gray-800/80 backdrop-blur-sm rounded-xl border border-gray-200/50 dark:border-gray-700/50 hover:shadow-lg transition-all duration-300 group overflow-hidden">

    
    <div class="px-4 pt-4 pb-2 flex justify-between items-center">
        <span class="text-xs font-semibold px-3 py-1 rounded-full inline-block <?php echo e($statusClass); ?>">
            <?php echo e(ucfirst($card->status)); ?>

        </span>
        <div class="text-xs text-gray-500 dark:text-gray-400 font-medium capitalize">
            <?php echo e($card->extra_data['card_level'] ?? 'Standard'); ?>

        </div>
    </div>

    
    <div class="px-4 py-3">
        <div class="w-full h-40 relative overflow-hidden rounded-xl">
            <div class="absolute inset-0 bg-linear-to-br <?php echo e($cardBgClass); ?>"></div>
            <div class="absolute inset-0 overflow-hidden">
                <div class="absolute top-0 right-0 w-24 h-24 bg-white/10 rounded-full -translate-y-12 translate-x-12">
                </div>
                <div class="absolute bottom-0 left-0 w-32 h-32 bg-white/5 rounded-full translate-y-16 -translate-x-16">
                </div>
            </div>
            <div class="relative p-4 h-full flex flex-col justify-between text-white">
                <div class="flex justify-between items-start">
                    <div>
                        <div class="text-xs font-semibold opacity-90"><?php echo e(config('app.name')); ?></div>
                        <div class="text-xs opacity-70">Virtual Card</div>
                    </div>
                    <div class="text-xs font-bold capitalize"><?php echo e($card->card_type); ?></div>
                </div>

                
                <div class="w-8 h-6 rounded bg-linear-to-br <?php echo e($chipClass); ?> flex items-center justify-center">
                    <div class="w-full h-full grid grid-cols-2 grid-rows-2 gap-px p-1">
                        <div class="bg-yellow-600/60 rounded-sm"></div>
                        <div class="bg-yellow-600/60 rounded-sm"></div>
                        <div class="bg-yellow-600/60 rounded-sm"></div>
                        <div class="bg-yellow-600/60 rounded-sm"></div>
                    </div>
                </div>

                <div class="font-mono text-sm tracking-wider">
                    •••• •••• •••• <?php echo e($card->last_four); ?>

                </div>

                <div class="flex justify-between items-end">
                    <div>
                        <div class="text-xs opacity-70 uppercase">Card Holder</div>
                        <div class="text-xs font-medium truncate max-w-30"><?php echo e($card->user->name); ?></div>
                    </div>
                    <div class="text-right">
                        <div class="text-xs opacity-70 uppercase">Valid Thru</div>
                        <div class="text-xs font-medium"><?php echo e(\Carbon\Carbon::parse($card->expiry_date)->format('m/y')); ?>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    <div class="px-4 pb-4">
        <div class="flex justify-between items-center mb-2">
            <span class="text-xs font-medium text-gray-600 dark:text-gray-400">Balance</span>
            <?php
                $symbol = isset($card->extra_data['currency'])
                    ? \App\Support\Currency::symbol($card->extra_data['currency'])
                    : $currencySymbol;
            ?>

            <span class="text-sm font-bold text-gray-900 dark:text-white">
                <?php echo e($symbol); ?><?php echo e(number_format($card->balance, 2)); ?>

            </span>

        </div>
        <div class="flex justify-between items-center mb-3">
            <span class="text-xs font-medium text-gray-600 dark:text-gray-400">Daily Limit</span>
            <span class="text-xs font-semibold text-gray-700 dark:text-gray-300">
                <?php echo e($symbol); ?> <?php echo e(number_format($card->extra_data['daily_limit'] ?? 0, 2)); ?>

            </span>
        </div>

        <div class="flex space-x-2">
            <button wire:click="editCard(<?php echo e($card->id); ?>)" class="btn-primary flex items-center gap-2">
                <?php if (isset($component)) { $__componentOriginal37c717510e7a32140849d8d5dd9d632e = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal37c717510e7a32140849d8d5dd9d632e = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.plus','data' => ['variant' => 'solid','class' => 'btn-primary-icon']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.plus'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'btn-primary-icon']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal37c717510e7a32140849d8d5dd9d632e)): ?>
<?php $attributes = $__attributesOriginal37c717510e7a32140849d8d5dd9d632e; ?>
<?php unset($__attributesOriginal37c717510e7a32140849d8d5dd9d632e); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal37c717510e7a32140849d8d5dd9d632e)): ?>
<?php $component = $__componentOriginal37c717510e7a32140849d8d5dd9d632e; ?>
<?php unset($__componentOriginal37c717510e7a32140849d8d5dd9d632e); ?>
<?php endif; ?>
                <span>Edit Details</span>
            </button>
            <a href="<?php echo e(route('user.transactions', $card->id)); ?>"
                class="flex-1 bg-gray-100 dark:bg-gray-700 hover:bg-gray-200 dark:hover:bg-gray-600 text-gray-700 dark:text-gray-300 text-xs font-semibold py-2 px-3 rounded-lg transition-all duration-300 text-center">
                Transactions
            </a>
        </div>
    </div>
</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/components/virtual-card-item.blade.php ENDPATH**/ ?>