<?php

use Livewire\Component;
use Livewire\WithFileUploads;
use App\Models\Ticket;
use App\Notifications\TicketCreated;
new class extends Component {
    use WithFileUploads;

    public $subject = '';
    public $priority = '';
    public $attachments = [];
    public $description = '';

    protected function rules()
    {
        return [
            'subject' => 'required|string|max:255',
            'priority' => 'required|in:low,medium,high',
            'attachments' => 'nullable|array|max:5',
            'attachments.*' => 'file|max:5120|mimes:jpg,jpeg,png,webp,pdf,doc,docx,xls,xlsx',
            'description' => 'required|string|min:10',
        ];
    }

    protected $messages = [
        'subject.required' => 'Please enter a subject for your ticket.',
        'priority.required' => 'Please select a priority level.',
        'attachments.max' => 'You can upload a maximum of 5 attachments.',
        'attachments.*.max' => 'Each attachment must not exceed 5MB.',
        'attachments.*.mimes' => 'Allowed file types: jpg, jpeg, png, webp, pdf, doc, docx, xls, xlsx.',
        'description.required' => 'Please enter a description for your ticket.',
    ];

    public function updated($propertyName)
    {
        $this->validateOnly($propertyName);
    }

    public function updatedAttachments()
    {
        if (count($this->attachments) > 5) {
            $this->attachments = array_slice($this->attachments, 0, 5);
            $this->addError('attachments', 'You can upload a maximum of 5 attachments.');
        }
    }

    public function removeAttachment($index)
    {
        unset($this->attachments[$index]);
        $this->attachments = array_values($this->attachments); // reindex
    }

    public function submitTicket()
    {
        $this->validate();

        // Store all attachments and get paths
        $paths = [];
        foreach ($this->attachments as $file) {
            $paths[] = $file->store('tickets', 'public');
        }

        // Create the ticket
        $ticket = Ticket::create([
            'user_id' => auth()->id(),
            'subject' => $this->subject,
            'priority' => $this->priority,
            'status' => Ticket::STATUS_OPEN,
        ]);

        // Create the first message with description and attachments
        $ticket->messages()->create([
            'user_id' => auth()->id(),
            'message' => $this->description,
            'attachments' => $paths, // JSON cast will automatically convert array to JSON
            'is_admin' => false,
        ]);

        // Notify user via mail and database
        $ticket->user->notify(new TicketCreated($ticket));

        // Reset form
        $this->reset(['subject', 'priority', 'attachments', 'description']);
        $this->dispatch('notification-sent');
        $this->dispatch('showToast', message: 'Ticket submitted successfully.', type: 'success');
    }
};
?>

 <?php $__env->slot('title', null, []); ?> 
    <?php echo e(config('app.name')); ?> || Create Support Ticket
 <?php $__env->endSlot(); ?>

<div class="space-y-5 py-4 font-sans">
    <div class="flex items-center justify-between">
        <a href="<?php echo e(route('user.ticket.index')); ?>"
            class="bg-sky-600 text-white flex items-center hover:shadow-2xl justify-center gap-1 px-3 py-2 rounded-md">
            <?php if (isset($component)) { $__componentOriginale41799ef1b2ae0b0e320ff9b21dacd08 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale41799ef1b2ae0b0e320ff9b21dacd08 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrow-left','data' => ['variant' => 'solid','class' => 'w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrow-left'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale41799ef1b2ae0b0e320ff9b21dacd08)): ?>
<?php $attributes = $__attributesOriginale41799ef1b2ae0b0e320ff9b21dacd08; ?>
<?php unset($__attributesOriginale41799ef1b2ae0b0e320ff9b21dacd08); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale41799ef1b2ae0b0e320ff9b21dacd08)): ?>
<?php $component = $__componentOriginale41799ef1b2ae0b0e320ff9b21dacd08; ?>
<?php unset($__componentOriginale41799ef1b2ae0b0e320ff9b21dacd08); ?>
<?php endif; ?>
            <span class="text-sm font-medium">Back to Information</span>
        </a>

        <div class="flex justify-end mb-4 relative" x-data="{ open: false }">
            <!-- Dropdown Button -->
            <button @click="open = !open" type="button"
                class="inline-flex justify-center w-full rounded-md border border-gray-300 dark:border-gray-700 shadow-sm px-4 py-2 bg-white dark:bg-gray-800 text-sm font-medium text-gray-700 dark:text-gray-100 hover:bg-gray-50 dark:hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-offset-1 focus:ring-sky-500">
                <?php echo e(strtoupper(app()->getLocale())); ?>

                <svg class="-mr-1 ml-2 h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
                </svg>
            </button>

            <!-- Dropdown Menu -->
            <div x-show="open" x-cloak @click.away="open = false"
                class="absolute right-0 mt-2 w-40 bg-white dark:bg-gray-800 border border-gray-200 dark:border-gray-700 rounded-md shadow-lg z-50">
                <ul class="py-1">
                    <li>
                        <a href="<?php echo e(route('locale.switch', 'en')); ?>"
                            class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-100 hover:bg-gray-100 dark:hover:bg-gray-700">
                            <img src="/images/flags/us.svg" alt="English" class="w-4 h-4 mr-2">
                            English
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('locale.switch', 'es')); ?>"
                            class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-100 hover:bg-gray-100 dark:hover:bg-gray-700">
                            <img src="/images/flags/es.svg" alt="Español" class="w-4 h-4 mr-2">
                            Español
                        </a>
                    </li>
                    <li>
                        <a href="<?php echo e(route('locale.switch', 'fr')); ?>"
                            class="flex items-center px-4 py-2 text-sm text-gray-700 dark:text-gray-100 hover:bg-gray-100 dark:hover:bg-gray-700">
                            <img src="/images/flags/fr.svg" alt="Français" class="w-4 h-4 mr-2">
                            Français
                        </a>
                    </li>
                </ul>
            </div>
        </div>



    </div>

    <div class="bg-white dark:bg-gray-900 border border-gray-100 dark:border-gray-800 rounded-xl p-4 md:p-6 space-y-4">
        <h2 class="flex items-center gap-3 text-sm md:text-base font-semibold text-gray-800 dark:text-gray-100">
            <span
                class="bg-sky-500/10 dark:bg-sky-400/10 w-9 h-9 flex items-center justify-center rounded-full text-sky-600 dark:text-sky-400">
                <?php if (isset($component)) { $__componentOriginal6e9611292c8c65029053d5659638524a = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal6e9611292c8c65029053d5659638524a = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.chat-bubble-left-ellipsis','data' => ['variant' => 'solid','class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.chat-bubble-left-ellipsis'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal6e9611292c8c65029053d5659638524a)): ?>
<?php $attributes = $__attributesOriginal6e9611292c8c65029053d5659638524a; ?>
<?php unset($__attributesOriginal6e9611292c8c65029053d5659638524a); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal6e9611292c8c65029053d5659638524a)): ?>
<?php $component = $__componentOriginal6e9611292c8c65029053d5659638524a; ?>
<?php unset($__componentOriginal6e9611292c8c65029053d5659638524a); ?>
<?php endif; ?>
            </span>
            <div>
                <span> Support Center</span>
                <p class="text-xs text-gray-600 dark:text-gray-100">We're here to help. Tell us about your issue and
                    we'll find a solution.</p>
            </div>
        </h2>

        <form wire:transition wire:submit.prevent="submitTicket"
            class="space-y-6 p-4 bg-white dark:bg-gray-800 rounded-lg shadow-sm">

            
            <div>
                <?php if (isset($component)) { $__componentOriginalc2fcfa88dc54fee60e0757a7e0572df1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc2fcfa88dc54fee60e0757a7e0572df1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input','data' => ['wire:model.live.blur' => 'subject','label' => ''.e(__('support.ticket_subject')).'','placeholder' => ''.e(__('support.ticket_subject_placeholder')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:model.live.blur' => 'subject','label' => ''.e(__('support.ticket_subject')).'','placeholder' => ''.e(__('support.ticket_subject_placeholder')).'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc2fcfa88dc54fee60e0757a7e0572df1)): ?>
<?php $attributes = $__attributesOriginalc2fcfa88dc54fee60e0757a7e0572df1; ?>
<?php unset($__attributesOriginalc2fcfa88dc54fee60e0757a7e0572df1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc2fcfa88dc54fee60e0757a7e0572df1)): ?>
<?php $component = $__componentOriginalc2fcfa88dc54fee60e0757a7e0572df1; ?>
<?php unset($__componentOriginalc2fcfa88dc54fee60e0757a7e0572df1); ?>
<?php endif; ?>
            </div>

            
            <div>
                <?php if (isset($component)) { $__componentOriginaled2cde6083938c436304f332ba96bb7c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaled2cde6083938c436304f332ba96bb7c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.select','data' => ['wire:model.live.blur' => 'priority','label' => ''.e(__('support.priority_label')).'','placeholder' => ''.e(__('support.priority_placeholder')).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('select'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:model.live.blur' => 'priority','label' => ''.e(__('support.priority_label')).'','placeholder' => ''.e(__('support.priority_placeholder')).'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                    <option value="low"><?php echo e(__('support.priority_low')); ?></option>
                    <option value="medium"><?php echo e(__('support.priority_medium')); ?></option>
                    <option value="high"><?php echo e(__('support.priority_high')); ?></option>
                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaled2cde6083938c436304f332ba96bb7c)): ?>
<?php $attributes = $__attributesOriginaled2cde6083938c436304f332ba96bb7c; ?>
<?php unset($__attributesOriginaled2cde6083938c436304f332ba96bb7c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaled2cde6083938c436304f332ba96bb7c)): ?>
<?php $component = $__componentOriginaled2cde6083938c436304f332ba96bb7c; ?>
<?php unset($__componentOriginaled2cde6083938c436304f332ba96bb7c); ?>
<?php endif; ?>
            </div>

            
            <div>
                <?php if (isset($component)) { $__componentOriginal4727f9fd7c3055c2cf9c658d89b16886 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4727f9fd7c3055c2cf9c658d89b16886 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.textarea','data' => ['wire:model.live.blur' => 'description','label' => ''.e(__('support.description_label')).'','placeholder' => ''.e(__('support.description_placeholder')).'','rows' => '4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('textarea'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:model.live.blur' => 'description','label' => ''.e(__('support.description_label')).'','placeholder' => ''.e(__('support.description_placeholder')).'','rows' => '4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4727f9fd7c3055c2cf9c658d89b16886)): ?>
<?php $attributes = $__attributesOriginal4727f9fd7c3055c2cf9c658d89b16886; ?>
<?php unset($__attributesOriginal4727f9fd7c3055c2cf9c658d89b16886); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4727f9fd7c3055c2cf9c658d89b16886)): ?>
<?php $component = $__componentOriginal4727f9fd7c3055c2cf9c658d89b16886; ?>
<?php unset($__componentOriginal4727f9fd7c3055c2cf9c658d89b16886); ?>
<?php endif; ?>
            </div>

            
            <div>
                <?php echo $__env->make('partials.support-upload', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>

            
            <div class="bg-blue-50 dark:bg-blue-900/30 rounded-lg p-3 border border-blue-100 dark:border-blue-800">
                <div class="flex">
                    <div class="shrink-0">
                        <?php if (isset($component)) { $__componentOriginal1f8061448e375a811323d4736f7bf58b = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1f8061448e375a811323d4736f7bf58b = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.information-circle','data' => ['variant' => 'solid','class' => 'w-4 h-4 text-blue-500 dark:text-blue-400 ']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.information-circle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-4 h-4 text-blue-500 dark:text-blue-400 ']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1f8061448e375a811323d4736f7bf58b)): ?>
<?php $attributes = $__attributesOriginal1f8061448e375a811323d4736f7bf58b; ?>
<?php unset($__attributesOriginal1f8061448e375a811323d4736f7bf58b); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1f8061448e375a811323d4736f7bf58b)): ?>
<?php $component = $__componentOriginal1f8061448e375a811323d4736f7bf58b; ?>
<?php unset($__componentOriginal1f8061448e375a811323d4736f7bf58b); ?>
<?php endif; ?>
                    </div>
                    <div class="ml-3">
                        <h3 class="text-xs font-medium text-blue-800 dark:text-blue-300">
                            <?php echo e(__('support.support_info_title')); ?>

                        </h3>
                        <p class="mt-1 text-xs text-blue-700 dark:text-blue-400">
                            <?php echo e(__('support.support_info_text')); ?>

                        </p>
                    </div>
                </div>
            </div>

            
            <div class="mt-6">
                <?php if (isset($component)) { $__componentOriginald0f1fd2689e4bb7060122a5b91fe8561 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => ['type' => 'submit','class' => 'w-full']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'submit','class' => 'w-full']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                    <?php echo e(__('support.submit_ticket')); ?>

                 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561)): ?>
<?php $attributes = $__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561; ?>
<?php unset($__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0f1fd2689e4bb7060122a5b91fe8561)): ?>
<?php $component = $__componentOriginald0f1fd2689e4bb7060122a5b91fe8561; ?>
<?php unset($__componentOriginald0f1fd2689e4bb7060122a5b91fe8561); ?>
<?php endif; ?>
            </div>

        </form>


        
        <div class="mt-8 space-y-4" x-data="{ active: 0 }"> <!-- open first by default -->
            <h2 class="flex items-center gap-3 text-sm md:text-base font-semibold text-gray-800 dark:text-gray-100">
                <span
                    class="bg-sky-500/10 dark:bg-sky-400/10 w-9 h-9 flex items-center justify-center rounded-full text-sky-600 dark:text-sky-400">
                    <?php if (isset($component)) { $__componentOriginal7ff90a4ec719b449b03bf1ad0e63e8a9 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7ff90a4ec719b449b03bf1ad0e63e8a9 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.question-mark-circle','data' => ['variant' => 'solid','class' => 'w-5 h-5']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.question-mark-circle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7ff90a4ec719b449b03bf1ad0e63e8a9)): ?>
<?php $attributes = $__attributesOriginal7ff90a4ec719b449b03bf1ad0e63e8a9; ?>
<?php unset($__attributesOriginal7ff90a4ec719b449b03bf1ad0e63e8a9); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7ff90a4ec719b449b03bf1ad0e63e8a9)): ?>
<?php $component = $__componentOriginal7ff90a4ec719b449b03bf1ad0e63e8a9; ?>
<?php unset($__componentOriginal7ff90a4ec719b449b03bf1ad0e63e8a9); ?>
<?php endif; ?>
                </span>
                <div>
                    <span> Support Center FAQs</span>
                    <p class="text-xs text-gray-600 dark:text-gray-100">Common questions about submitting tickets and
                        using
                        our support system.</p>
                </div>
            </h2>

            <div class="space-y-2">
                <?php
                    $faqs = [
                        [
                            'question' => 'How long does it take to get a response?',
                            'answer' => 'Our support team typically responds within 24 hours on business days.',
                        ],
                        [
                            'question' => 'Can I attach multiple files?',
                            'answer' =>
                                'Yes, you can attach up to 5 files. Each file must be under 5MB and in allowed formats (jpg, png, pdf, doc, etc.).',
                        ],
                        [
                            'question' => 'Can I track the status of my ticket?',
                            'answer' =>
                                'Absolutely! Once submitted, you can view your ticket status in your support dashboard.',
                        ],
                        [
                            'question' => 'Can I update my ticket after submission?',
                            'answer' => 'Yes, you can reply to your ticket to add more information or attachments.',
                        ],
                        [
                            'question' => 'Who can view my tickets?',
                            'answer' => 'Only you and our support team can view the tickets you submit.',
                        ],
                        [
                            'question' => 'What should I do if I didn’t receive a response?',
                            'answer' =>
                                'Check your spam folder. If you still don’t see a reply, please submit a follow-up ticket.',
                        ],
                    ];
                ?>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $faqs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $faq): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                    <div class="border border-gray-200 dark:border-gray-700 rounded-lg">
                        <button @click="active === <?php echo e($index); ?> ? active = null : active = <?php echo e($index); ?>"
                            class="w-full flex justify-between items-center px-4 py-3 bg-gray-50 dark:bg-gray-800 hover:bg-gray-100 dark:hover:bg-gray-700 text-left rounded-lg focus:outline-none focus:ring-2 focus:ring-sky-500">
                            <span class="text-sm font-medium text-gray-800 dark:text-gray-100">
                                <?php echo e($faq['question']); ?>

                            </span>
                            <svg :class="{ 'rotate-180': active === <?php echo e($index); ?> }"
                                class="w-4 h-4 transition-transform duration-200" fill="none" stroke="currentColor"
                                viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M19 9l-7 7-7-7" />
                            </svg>
                        </button>
                        <div x-show="active === <?php echo e($index); ?>" x-collapse x-cloak
                            class=" text-sm text-gray-700 dark:text-gray-300 bg-white dark:bg-gray-900 border-t border-gray-200 dark:border-gray-700">
                            <div class="px-4 py-3">
                                <?php echo e($faq['answer']); ?>

                            </div>
                        </div>
                    </div>
                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
            </div>
        </div>
    </div>


</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/pages/user/support/⚡create.blade.php ENDPATH**/ ?>