<div class="space-y-6">
    <h2 class="text-2xl font-bold mb-4 border-b pb-2">Preview Your Information</h2>

    <!-- Personal Info -->
    <section class="space-y-2">
        <h3 class="text-xl font-semibold">Personal Info</h3>
        <div class="grid grid-cols-2 gap-4">
            <p><span class="font-medium">Name:</span> <?php echo e($this->previewData['name']); ?></p>
            <p><span class="font-medium">Username:</span> <?php echo e($this->previewData['username']); ?></p>
            <p><span class="font-medium">Date of Birth:</span> <?php echo e($this->previewData['date_of_birth']); ?></p>
            <p><span class="font-medium">Gender:</span> <?php echo e(ucfirst($this->previewData['gender'])); ?></p>
        </div>
        <button wire:click="goToStep(1)"
            class="mt-2 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600 transition">
            Edit Personal Info
        </button>
    </section>

    <!-- Address & Contact -->
    <section class="space-y-2">
        <h3 class="text-xl font-semibold">Address & Contact</h3>
        <div class="grid grid-cols-2 gap-4">
            <p><span class="font-medium">Country:</span> <?php echo e($this->previewData['country']); ?></p>
            <p><span class="font-medium">State:</span> <?php echo e($this->previewData['state']); ?></p>
            <p><span class="font-medium">City:</span> <?php echo e($this->previewData['city']); ?></p>
            <p><span class="font-medium">Zip Code:</span> <?php echo e($this->previewData['zip_code']); ?></p>
            <p><span class="font-medium">Phone:</span> <?php echo e($this->previewData['phone']); ?></p>
        </div>
        <button wire:click="goToStep(2)"
            class="mt-2 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600 transition">
            Edit Address & Contact
        </button>
    </section>

    <!-- Account Info -->
    <section class="space-y-2">
        <h3 class="text-xl font-semibold">Account Info</h3>
        <div class="grid grid-cols-2 gap-4">
            <p><span class="font-medium">Account Type:</span> <?php echo e(ucfirst($this->previewData['bank_account_type'])); ?></p>
            <p><span class="font-medium">Currency:</span> <?php echo e(strtoupper($this->previewData['currency'])); ?></p>
            <p><span class="font-medium">Password:</span> ••••••••</p>
        </div>
        <button wire:click="goToStep(3)"
            class="mt-2 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600 transition">
            Edit Account Info
        </button>
    </section>

    <div class="flex items-start space-x-2 mt-4">
        <div class="flex flex-col gap-2">
            <div class="flex items-center">
                <!-- Agreement Checkbox -->
                <input type="checkbox" id="terms" wire:model.defer="formData.agreement_accepted"
                    class="mt-1 h-4 w-4 text-sky-600 border-gray-300 rounded focus:ring-sky-500">

                <!-- Label -->
                <label for="terms" class="ml-2 text-sm text-gray-700 leading-5">
                    I agree to the
                    <a href="<?php echo e(route('privacy.terms')); ?>" target="_blank" class="text-sky-600 hover:underline">Terms of
                        Service</a>
                    and
                    <a href="<?php echo e(route('privacy.data')); ?>" target="_blank" class="text-sky-600 hover:underline">Privacy
                        Policy</a>.
                </label>
            </div>

            <!-- Validation Error -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php $__errorArgs = ['formData.agreement_accepted'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <p class="mt-1 text-sm text-red-600 dark:text-red-400 flex items-center gap-1">
                    <?php if (isset($component)) { $__componentOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.index','data' => ['name' => 'exclamation-circle','class' => 'h-4 w-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['name' => 'exclamation-circle','class' => 'h-4 w-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2)): ?>
<?php $attributes = $__attributesOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2; ?>
<?php unset($__attributesOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2)): ?>
<?php $component = $__componentOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2; ?>
<?php unset($__componentOriginalc7d5f44bf2a2d803ed0b55f72f1f82e2); ?>
<?php endif; ?>
                    <?php echo e($message); ?>

                </p>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>
    </div>

</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/partials/onboarding/step4.blade.php ENDPATH**/ ?>