<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Tax Refund Receipt - <?php echo e($refund->filing_number); ?></title>
    <style>
        body {
            font-family: 'DejaVu Sans', sans-serif;
            font-size: 12px;
            color: #1e293b;
            /* gray-800 */
            margin: 20px;
        }

        .header {
            text-align: center;
            margin-bottom: 30px;
        }

        h1 {
            margin: 0;
            font-size: 28px;
            font-weight: bold;
            color: #1e40af;
            /* sky-700 */
        }

        h2 {
            margin: 5px 0 10px;
            font-size: 20px;
            font-weight: normal;
            color: #0ea5e9;
            /* sky-500 */
        }

        p.meta {
            font-size: 12px;
            color: #475569;
            /* gray-600 */
            margin: 0;
        }

        table.details,
        table.status-history {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        table.details td {
            padding: 8px;
            vertical-align: top;
        }

        table.details td.label {
            font-weight: bold;
            width: 25%;
            color: #0ea5e9;
            /* sky-500 */
        }

        table.status-history th,
        table.status-history td {
            border: 1px solid #cbd5e1;
            /* gray-300 */
            padding: 6px;
            font-size: 12px;
        }

        table.status-history th {
            background-color: #e0f2fe;
            /* sky-100 */
            text-align: left;
            color: #1e40af;
            /* sky-700 */
        }

        table.status-history tr:nth-child(even) {
            background-color: #f0f9ff;
            /* sky-50 */
        }

        .amount {
            font-size: 16px;
            font-weight: bold;
            color: #1e40af;
            /* sky-700 */
        }

        .footer {
            text-align: center;
            font-size: 10px;
            color: #94a3b8;
            /* gray-400 */
            margin-top: 30px;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1><?php echo e(config('app.name')); ?></h1>
        <h2>Tax Refund Receipt</h2>
        <p class="meta">
            Filing Number: <strong><?php echo e($refund->filing_number); ?></strong> |
            Date: <?php echo e(now()->format('M d, Y')); ?>

        </p>
    </div>

    <table class="details">
        <tr>
            <td class="label">Full Name:</td>
            <td><?php echo e($refund->full_name); ?></td>
            <td class="label">Email:</td>
            <td><?php echo e($refund->email); ?></td>
        </tr>
        <tr>
            <td class="label">Country:</td>
            <td><?php echo e($refund->country_code); ?></td>
            <td class="label">State:</td>
            <td><?php echo e($refund->state ?: '-'); ?></td>
        </tr>
        <tr>
            <td class="label">Status:</td>
            <td><?php echo e(ucfirst($refund->status)); ?></td>
            <td class="label">Amount:</td>
            <td class="amount">$<?php echo e(number_format($refund->amount ?? 0, 2)); ?></td>
        </tr>
    </table>

    <h3>Status History</h3>
    <table class="status-history">
        <thead>
            <tr>
                <th>Status</th>
                <th>Notes</th>
                <th>Changed At</th>
            </tr>
        </thead>
        <tbody>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $statusHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $history): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                <tr>
                    <td><?php echo e(ucfirst($history->status)); ?></td>
                    <td><?php echo e($history->notes ?: '-'); ?></td>
                    <td><?php echo e($history->changed_at?->format('M d, Y H:i') ?? $history->created_at->format('M d, Y H:i')); ?>

                    </td>
                </tr>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
        </tbody>
    </table>

    <div class="footer">
        &copy; <?php echo e(now()->year); ?> <?php echo e(config('app.name')); ?>. All rights reserved.
    </div>
</body>

</html>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/tax-refunds/receipt-pdf.blade.php ENDPATH**/ ?>