<?php

use Livewire\Component;
use App\Services\PinService;
use App\Traits\RequiresPin;
use Illuminate\Validation\ValidationException;

new class extends Component {
    use RequiresPin;

    public bool $updatingPin = false; // user already has a PIN
    public bool $enteringNewPin = false; // verified → entering new PIN

    public string $pin = '';
    public string $pin_confirmation = '';

    public function mount(PinService $pinService)
    {
        $profile = auth()->user()->profile;

        $this->updatingPin = $pinService->userHasPin($profile);
        $this->pinMissing = !$this->updatingPin;
    }

    public function submitPin(PinService $pinService)
    {
        $profile = auth()->user()->profile;

        /**
         * 1. No PIN → create PIN
         */
        if ($this->pinMissing) {
            $this->validatePinConfirmation();

            $pinService->setPin($profile, $this->pin);

            $this->resetPinState();

            $this->dispatch('pin-success');
            $this->dispatch('showToast', message: 'PIN created successfully!', type: 'success');
            return;
        }

        /**
         * 2. Has PIN, not verified yet → verify current PIN
         */
        if (!$this->enteringNewPin) {
            if (!$this->verifyPin($pinService)) {
                $this->addError('pin', 'Invalid PIN.');
                $this->pin = '';
                return;
            }

            $this->enteringNewPin = true;
            $this->pin = '';
            return;
        }

        /**
         * 3. Verified → set new PIN
         */
        try {
            $this->validatePinConfirmation();

            $pinService->setPin($profile, $this->pin);
        } catch (ValidationException $e) {
            $this->addError('pin', $e->getMessage());
            return;
        }

        $this->resetPinState();

        $this->dispatch('pin-success');
        $this->dispatch('showToast', message: 'PIN updated successfully!', type: 'success');
    }

    protected function validatePinConfirmation(): void
    {
        $this->validate(
            [
                'pin' => ['required', 'digits:4'],
                'pin_confirmation' => ['required', 'same:pin'],
            ],
            [
                'pin_confirmation.same' => 'PIN confirmation does not match.',
            ],
        );
    }

    protected function resetPinState(): void
    {
        $this->pin = '';
        $this->pin_confirmation = '';
        $this->enteringNewPin = false;
        $this->pinMissing = false;
    }
};

?>
 <?php $__env->slot('title', null, []); ?> 
    <?php echo e(config('app.name')); ?> || Manage Transaction Pin
 <?php $__env->endSlot(); ?>
<section class="w-full py-5">
    <?php if (isset($component)) { $__componentOriginal951a5936e8413b65cd052beecc1fba57 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951a5936e8413b65cd052beecc1fba57 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.settings.layout','data' => ['heading' => __('Transaction PIN'),'subheading' => __('Secure your transactions with a 4-digit PIN')]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('settings.layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['heading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Transaction PIN')),'subheading' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(__('Secure your transactions with a 4-digit PIN'))]); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

        <div class="grid grid-cols-1 gap-4">
            <div class="bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl rounded-2xl shadow-lg border overflow-hidden">

                <!-- Header -->
                <div class="border-b px-4 py-3 flex items-center">
                    <div class="w-6 h-6 bg-sky-500 rounded-lg flex items-center justify-center mr-2">
                        <?php if (isset($component)) { $__componentOriginalf870514c33bb1b53395ba02235f60146 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf870514c33bb1b53395ba02235f60146 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.shield-check','data' => ['variant' => 'solid','class' => 'text-white w-4 h-4']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.shield-check'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'text-white w-4 h-4']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf870514c33bb1b53395ba02235f60146)): ?>
<?php $attributes = $__attributesOriginalf870514c33bb1b53395ba02235f60146; ?>
<?php unset($__attributesOriginalf870514c33bb1b53395ba02235f60146); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf870514c33bb1b53395ba02235f60146)): ?>
<?php $component = $__componentOriginalf870514c33bb1b53395ba02235f60146; ?>
<?php unset($__componentOriginalf870514c33bb1b53395ba02235f60146); ?>
<?php endif; ?>
                    </div>
                    <div>
                        <h2 class="text-sm font-bold">
                            <?php echo e($pinMissing ? 'Create Transaction PIN' : ($enteringNewPin ? 'Update Transaction PIN' : 'Verify Current PIN')); ?>

                        </h2>
                        <p class="text-xs text-gray-500">
                            <?php echo e($pinMissing
                                ? 'Set up a new 4-digit PIN.'
                                : ($enteringNewPin
                                    ? 'Enter and confirm your new PIN.'
                                    : 'Enter your current PIN to continue.')); ?>

                        </p>
                    </div>
                </div>

                <div class="p-4 space-y-4">

                    <!-- PIN -->
                    <?php if (isset($component)) { $__componentOriginal26c546557cdc09040c8dd00b2090afd0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal26c546557cdc09040c8dd00b2090afd0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::input.index','data' => ['wire:model.defer' => 'pin','type' => 'password','inputmode' => 'numeric','pattern' => '[0-9]*','maxlength' => '4','autocomplete' => 'one-time-code','icon' => 'key','viewable' => true,'label' => $pinMissing || $enteringNewPin ? 'PIN' : 'Current PIN','placeholder' => '••••']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:model.defer' => 'pin','type' => 'password','inputmode' => 'numeric','pattern' => '[0-9]*','maxlength' => '4','autocomplete' => 'one-time-code','icon' => 'key','viewable' => true,'label' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pinMissing || $enteringNewPin ? 'PIN' : 'Current PIN'),'placeholder' => '••••']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal26c546557cdc09040c8dd00b2090afd0)): ?>
<?php $attributes = $__attributesOriginal26c546557cdc09040c8dd00b2090afd0; ?>
<?php unset($__attributesOriginal26c546557cdc09040c8dd00b2090afd0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal26c546557cdc09040c8dd00b2090afd0)): ?>
<?php $component = $__componentOriginal26c546557cdc09040c8dd00b2090afd0; ?>
<?php unset($__componentOriginal26c546557cdc09040c8dd00b2090afd0); ?>
<?php endif; ?>

                    <!-- Confirm PIN -->
                    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($pinMissing || $enteringNewPin): ?>
                        <?php if (isset($component)) { $__componentOriginal26c546557cdc09040c8dd00b2090afd0 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal26c546557cdc09040c8dd00b2090afd0 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::input.index','data' => ['wire:model.defer' => 'pin_confirmation','type' => 'password','inputmode' => 'numeric','pattern' => '[0-9]*','maxlength' => '4','icon' => 'key','viewable' => true,'label' => 'Confirm PIN','placeholder' => '••••']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['wire:model.defer' => 'pin_confirmation','type' => 'password','inputmode' => 'numeric','pattern' => '[0-9]*','maxlength' => '4','icon' => 'key','viewable' => true,'label' => 'Confirm PIN','placeholder' => '••••']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal26c546557cdc09040c8dd00b2090afd0)): ?>
<?php $attributes = $__attributesOriginal26c546557cdc09040c8dd00b2090afd0; ?>
<?php unset($__attributesOriginal26c546557cdc09040c8dd00b2090afd0); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal26c546557cdc09040c8dd00b2090afd0)): ?>
<?php $component = $__componentOriginal26c546557cdc09040c8dd00b2090afd0; ?>
<?php unset($__componentOriginal26c546557cdc09040c8dd00b2090afd0); ?>
<?php endif; ?>
                    <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

                    <!-- Security Notice -->
                    <div class="bg-yellow-50 rounded-xl p-3 border">
                        <p class="text-xs text-yellow-800">
                            Never share your PIN. It will be required for all secure transactions.
                        </p>
                    </div>

                    <!-- Action Button -->
                    <?php if (isset($component)) { $__componentOriginald0f1fd2689e4bb7060122a5b91fe8561 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.button','data' => ['type' => 'button','wire:click' => 'submitPin','wire:loading.attr' => 'disabled','class' => 'w-full','icon' => 'cloud-arrow-down']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('button'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['type' => 'button','wire:click' => 'submitPin','wire:loading.attr' => 'disabled','class' => 'w-full','icon' => 'cloud-arrow-down']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

                        <?php echo e($pinMissing ? 'Create PIN' : ($enteringNewPin ? 'Save New PIN' : 'Verify PIN')); ?>

                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561)): ?>
<?php $attributes = $__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561; ?>
<?php unset($__attributesOriginald0f1fd2689e4bb7060122a5b91fe8561); ?>
<?php endif; ?>
<?php if (isset($__componentOriginald0f1fd2689e4bb7060122a5b91fe8561)): ?>
<?php $component = $__componentOriginald0f1fd2689e4bb7060122a5b91fe8561; ?>
<?php unset($__componentOriginald0f1fd2689e4bb7060122a5b91fe8561); ?>
<?php endif; ?>

                </div>
            </div>
        </div>
     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951a5936e8413b65cd052beecc1fba57)): ?>
<?php $attributes = $__attributesOriginal951a5936e8413b65cd052beecc1fba57; ?>
<?php unset($__attributesOriginal951a5936e8413b65cd052beecc1fba57); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951a5936e8413b65cd052beecc1fba57)): ?>
<?php $component = $__componentOriginal951a5936e8413b65cd052beecc1fba57; ?>
<?php unset($__componentOriginal951a5936e8413b65cd052beecc1fba57); ?>
<?php endif; ?>
</section>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/pages/user/settings/⚡transaction-pin.blade.php ENDPATH**/ ?>