<div
    class="bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl rounded-2xl shadow-lg dark:shadow-gray-900/50 overflow-hidden border border-white/20 dark:border-gray-700/50">

    <!-- Header -->
    <div
        class="px-4 py-2 bg-linear-to-r from-slate-50/80 to-slate-100/50 dark:from-slate-800/50 dark:to-slate-700/50 border-b border-slate-100/50 dark:border-slate-600/70 flex items-center justify-between gap-3 flex-wrap">
        <div class="flex items-center">
            <div class="w-6 h-6 bg-slate-500 dark:bg-slate-600 rounded-lg flex items-center justify-center mr-2">
                <?php if (isset($component)) { $__componentOriginal1deba02eccc245565cd65699beed0450 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal1deba02eccc245565cd65699beed0450 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.arrow-path-rounded-square','data' => ['class' => 'w-3 h-3 text-white']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.arrow-path-rounded-square'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-3 h-3 text-white']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal1deba02eccc245565cd65699beed0450)): ?>
<?php $attributes = $__attributesOriginal1deba02eccc245565cd65699beed0450; ?>
<?php unset($__attributesOriginal1deba02eccc245565cd65699beed0450); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal1deba02eccc245565cd65699beed0450)): ?>
<?php $component = $__componentOriginal1deba02eccc245565cd65699beed0450; ?>
<?php unset($__componentOriginal1deba02eccc245565cd65699beed0450); ?>
<?php endif; ?>
            </div>
            <h3 class="text-sm font-bold text-slate-900 dark:text-slate-50">Account Health Dashboard</h3>
        </div>

        <a href="#" class="text-xs font-medium text-sky-700 dark:text-sky-400 hover:underline">View Details</a>

    </div>

    <!-- Health Metrics Grid -->
    <div class="space-y-3 p-3">

        <?php
            $period = $healthPeriod ?? 'daily';
            $health = $healthStats['account_health'][$period] ?? null;

            $progress = $health['progress'] ?? 0;

            // Risk tiers
            if ($progress >= 90) {
                $riskColor = 'red';
                $riskLabel = 'Critical';
            } elseif ($progress >= 75) {
                $riskColor = 'yellow';
                $riskLabel = 'Near Limit';
            } else {
                $riskColor = 'green';
                $riskLabel = 'Healthy';
            }

            // Monthly availability (30-day rule)
            $monthlyAvailable = $accounts->firstWhere('id', $focusedAccountId)?->created_at?->lte(now()->subDays(30));
        ?>

        <!-- Account Health -->
        <div
            class="bg-white dark:bg-gray-900 rounded-lg p-5 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col space-y-4">

            <!-- Header -->
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div
                        class="w-12 h-12 flex items-center justify-center rounded-lg
                bg-<?php echo e($riskColor); ?>-50 dark:bg-<?php echo e($riskColor); ?>-800">
                        <?php if (isset($component)) { $__componentOriginal7f0e8d69add49581695c1337b3f85fff = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7f0e8d69add49581695c1337b3f85fff = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.exclamation-triangle','data' => ['class' => 'w-6 h-6 text-'.e($riskColor).'-700 dark:text-'.e($riskColor).'-300']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.exclamation-triangle'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 text-'.e($riskColor).'-700 dark:text-'.e($riskColor).'-300']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7f0e8d69add49581695c1337b3f85fff)): ?>
<?php $attributes = $__attributesOriginal7f0e8d69add49581695c1337b3f85fff; ?>
<?php unset($__attributesOriginal7f0e8d69add49581695c1337b3f85fff); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7f0e8d69add49581695c1337b3f85fff)): ?>
<?php $component = $__componentOriginal7f0e8d69add49581695c1337b3f85fff; ?>
<?php unset($__componentOriginal7f0e8d69add49581695c1337b3f85fff); ?>
<?php endif; ?>
                    </div>

                    <div>
                        <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">
                            Account Health
                        </h3>

                        <span
                            class="text-xs px-2 py-1 rounded-full
                    bg-<?php echo e($riskColor); ?>-100 text-<?php echo e($riskColor); ?>-700 font-medium">
                            <?php echo e($riskLabel); ?>

                        </span>
                    </div>
                </div>

                <!-- Toggle -->
                <div class="flex gap-1">
                    <button wire:click="$set('healthPeriod','daily')"
                        class="px-3 py-1 text-xs rounded-full transition
                <?php echo e($healthPeriod === 'daily' ? 'bg-' . $riskColor . '-600 text-white' : 'bg-gray-200 dark:bg-gray-700'); ?>">
                        Daily
                    </button>

                    <button wire:click="<?php echo e($monthlyAvailable ? "\$set('healthPeriod','monthly')" : ''); ?>"
                        <?php if(!$monthlyAvailable): echo 'disabled'; endif; ?>
                        class="px-3 py-1 text-xs rounded-full transition
                <?php echo e($healthPeriod === 'monthly' ? 'bg-' . $riskColor . '-600 text-white' : 'bg-gray-200 dark:bg-gray-700'); ?>

                <?php echo e(!$monthlyAvailable ? 'opacity-50 cursor-not-allowed' : ''); ?>">
                        Monthly
                    </button>
                </div>
            </div>

            <!-- Limit Breach Banner -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($progress >= 90): ?>
                <div class="text-xs px-3 py-2 rounded-md
            bg-red-50 text-red-700 border border-red-200">
                    ⚠ Critical usage level reached. Transactions may be declined.
                </div>
            <?php elseif($progress >= 75): ?>
                <div
                    class="text-xs px-3 py-2 rounded-md
            bg-yellow-50 text-yellow-700 border border-yellow-200">
                    ⚠ You are nearing your <?php echo e($period); ?> transaction limit.
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

            <!-- Progress Bar -->
            <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2">
                <div class="h-2 rounded-full bg-<?php echo e($riskColor); ?>-600 transition-all duration-300"
                    style="width: <?php echo e($progress); ?>%">
                </div>
            </div>

            <!-- Usage Text -->
            <div class="text-gray-600 dark:text-gray-400 text-xs">
                <?php echo e($currencySymbol); ?><?php echo e(number_format($health['used'] ?? 0, 2)); ?>

                of <?php echo e($currencySymbol); ?><?php echo e(number_format($health['limit'] ?? 0, 2)); ?> used
            </div>

            <!-- Monthly availability note -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(!$monthlyAvailable): ?>
                <div class="text-[10px] text-gray-400">
                    Monthly limits available after 30 days of account activity
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <!-- Activity Consistency Card -->
        <?php
            $activity = $healthStats['activity_consistency'] ?? ['percent' => 0, 'active_days' => 0, 'total_days' => 0];
            $percent = $activity['percent'];

            // Tier logic
            if ($percent >= 80) {
                $tierColor = 'green';
                $tierLabel = 'Consistent';
            } elseif ($percent >= 50) {
                $tierColor = 'yellow';
                $tierLabel = 'Moderate';
            } else {
                $tierColor = 'red';
                $tierLabel = 'Low';
            }
        ?>

        <div
            class="bg-white dark:bg-gray-900 rounded-lg p-5 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col space-y-4">

            <!-- Header -->
            <div class="flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div
                        class="w-12 h-12 flex items-center justify-center rounded-lg
                bg-<?php echo e($tierColor); ?>-50 dark:bg-<?php echo e($tierColor); ?>-800">
                        <?php if (isset($component)) { $__componentOriginal4a4fffe04433d6d6be16f26ad2650578 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal4a4fffe04433d6d6be16f26ad2650578 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.clock','data' => ['class' => 'w-6 h-6 text-'.e($tierColor).'-700 dark:text-'.e($tierColor).'-300']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.clock'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 text-'.e($tierColor).'-700 dark:text-'.e($tierColor).'-300']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal4a4fffe04433d6d6be16f26ad2650578)): ?>
<?php $attributes = $__attributesOriginal4a4fffe04433d6d6be16f26ad2650578; ?>
<?php unset($__attributesOriginal4a4fffe04433d6d6be16f26ad2650578); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal4a4fffe04433d6d6be16f26ad2650578)): ?>
<?php $component = $__componentOriginal4a4fffe04433d6d6be16f26ad2650578; ?>
<?php unset($__componentOriginal4a4fffe04433d6d6be16f26ad2650578); ?>
<?php endif; ?>
                    </div>

                    <div>
                        <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">
                            Activity Consistency
                        </h3>

                        <span
                            class="text-xs px-2 py-1 rounded-full
                    bg-<?php echo e($tierColor); ?>-100 text-<?php echo e($tierColor); ?>-700 font-medium">
                            <?php echo e($tierLabel); ?>

                        </span>
                    </div>
                </div>
            </div>

            <!-- Progress Bar -->
            <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2 mt-2">
                <div class="h-2 rounded-full bg-<?php echo e($tierColor); ?>-600 transition-all"
                    style="width: <?php echo e($percent); ?>%">
                </div>
            </div>

            <!-- Usage Text -->
            <div class="text-gray-600 dark:text-gray-400 text-xs">
                Active <?php echo e($activity['active_days']); ?> of <?php echo e($activity['total_days']); ?> days this month
            </div>

            <!-- Tier Alert Banner -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($percent < 50): ?>
                <div class="text-xs px-3 py-2 rounded-md
        bg-red-50 text-red-700 border border-red-200">
                    ⚠ Low account activity. Consider using your account regularly.
                </div>
            <?php elseif($percent >= 50 && $percent < 80): ?>
                <div class="text-xs px-3 py-2 rounded-md
        bg-yellow-50 text-yellow-700 border border-yellow-200">
                    ⚠ Moderate activity. Aim for more consistent usage.
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </div>

        <!-- Spending Trends -->
        <div
            class="bg-white dark:bg-gray-900 rounded-lg p-5 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col space-y-4">

            <div class="flex items-center gap-3">
                <div
                    class="w-12 h-12 flex items-center justify-center rounded-lg
                bg-<?php echo e($healthStats['spending_trends']['color'] ?? 'gray'); ?>-50
                dark:bg-<?php echo e($healthStats['spending_trends']['color'] ?? 'gray'); ?>-800">
                    <?php if (isset($component)) { $__componentOriginal82067727c95f13dc4198f80e35cb9c11 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal82067727c95f13dc4198f80e35cb9c11 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.chart-bar','data' => ['class' => 'w-6 h-6 text-'.e($healthStats['spending_trends']['color'] ?? 'gray').'-700
                    dark:text-'.e($healthStats['spending_trends']['color'] ?? 'gray').'-300']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.chart-bar'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 text-'.e($healthStats['spending_trends']['color'] ?? 'gray').'-700
                    dark:text-'.e($healthStats['spending_trends']['color'] ?? 'gray').'-300']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal82067727c95f13dc4198f80e35cb9c11)): ?>
<?php $attributes = $__attributesOriginal82067727c95f13dc4198f80e35cb9c11; ?>
<?php unset($__attributesOriginal82067727c95f13dc4198f80e35cb9c11); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal82067727c95f13dc4198f80e35cb9c11)): ?>
<?php $component = $__componentOriginal82067727c95f13dc4198f80e35cb9c11; ?>
<?php unset($__componentOriginal82067727c95f13dc4198f80e35cb9c11); ?>
<?php endif; ?>
                </div>

                <div class="flex-1">
                    <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">
                        Spending Trends
                    </h3>

                    <span
                        class="text-xs px-2 py-1 rounded-full
                    bg-<?php echo e($healthStats['spending_trends']['color'] ?? 'gray'); ?>-100
                    text-<?php echo e($healthStats['spending_trends']['color'] ?? 'gray'); ?>-700 font-medium">
                        <?php echo e($healthStats['spending_trends']['label'] ?? 'No Data'); ?>

                    </span>
                </div>
            </div>

            <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-2 mt-2">
                <div class="h-2 rounded-full bg-<?php echo e($healthStats['spending_trends']['color'] ?? 'gray'); ?>-600 transition-all"
                    style="width: <?php echo e($healthStats['spending_trends']['progress'] ?? 0); ?>%">
                </div>
            </div>

            <div class="text-gray-600 dark:text-gray-400 text-xs">
                <?php echo e($currencySymbol); ?><?php echo e(number_format($healthStats['spending_trends']['value'] ?? 0, 2)); ?>

                spent this month
            </div>
        </div>

        <!-- Alerts / Notifications -->
        <div
            class="bg-white dark:bg-gray-900 rounded-lg p-5 border border-gray-200 dark:border-gray-700 hover:shadow-lg transition-shadow duration-200 flex flex-col space-y-4">
            <div class="flex items-center gap-3">
                <div
                    class="w-12 h-12 flex items-center justify-center rounded-lg bg-linear-to-br from-purple-50 to-purple-100 dark:from-purple-800 dark:to-purple-700">
                    <?php if (isset($component)) { $__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.bell','data' => ['class' => 'w-6 h-6 text-purple-700 dark:text-purple-300']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.bell'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['class' => 'w-6 h-6 text-purple-700 dark:text-purple-300']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa)): ?>
<?php $attributes = $__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa; ?>
<?php unset($__attributesOriginal2357204bbfb73ef228c684f3b7e8f9fa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa)): ?>
<?php $component = $__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa; ?>
<?php unset($__componentOriginal2357204bbfb73ef228c684f3b7e8f9fa); ?>
<?php endif; ?>
                </div>
                <div class="flex-1">
                    <h3 class="text-sm font-semibold text-gray-800 dark:text-gray-100">Alerts</h3>
                    <span
                        class="text-xs px-2 py-1 rounded-full bg-purple-50 dark:bg-purple-800 text-purple-700 dark:text-purple-300 font-medium">
                        <?php echo e($unreadAlerts); ?> Unread
                    </span>
                </div>
            </div>
            <div class="mt-2 text-gray-600 dark:text-gray-400 text-xs">
                Review account notifications and security alerts.
            </div>
        </div>

    </div>
</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/partials/metrics-card.blade.php ENDPATH**/ ?>