<?php

use Livewire\Component;
use App\Models\Grant;

new class extends Component {
    public bool $hasPendingPersonal = false;
    public bool $hasPendingCompany = false;

    public function mount()
    {
        $user = auth()->user();

        $this->hasPendingPersonal = Grant::where('user_id', $user->id)->where('type', 'personal')->where('status', 'pending')->exists();

        $this->hasPendingCompany = Grant::where('user_id', $user->id)->where('type', 'company')->where('status', 'pending')->exists();
    }
};
?>

<div class="grid grid-cols-1 md:grid-cols-2 gap-5">

    <!-- Individual Card -->
    <div
        class="flex flex-col justify-between h-full p-6 rounded-xl shadow-md dark:shadow-none 
        <?php echo e($hasPendingPersonal ? 'bg-gray-200 dark:bg-zinc-700 opacity-70 cursor-not-allowed' : 'bg-gray-50 dark:bg-zinc-800 border border-gray-200 dark:border-zinc-700 hover:scale-105 hover:shadow-lg transition-transform duration-300 cursor-pointer'); ?>">

        <div class="flex flex-col items-center text-center space-y-4">
            <div
                class="w-12 h-12 flex items-center justify-center rounded-full 
                <?php echo e($hasPendingPersonal ? 'bg-gray-400' : 'bg-sky-500/20 group-hover:bg-sky-500/30'); ?>">
                <?php if (isset($component)) { $__componentOriginalcbe89caa4ae8c58f7efd0ed6343c35ff = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalcbe89caa4ae8c58f7efd0ed6343c35ff = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.user','data' => ['variant' => 'solid','class' => 'w-5 h-5 '.e($hasPendingPersonal ? 'text-gray-600' : 'text-sky-700').'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5 '.e($hasPendingPersonal ? 'text-gray-600' : 'text-sky-700').'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalcbe89caa4ae8c58f7efd0ed6343c35ff)): ?>
<?php $attributes = $__attributesOriginalcbe89caa4ae8c58f7efd0ed6343c35ff; ?>
<?php unset($__attributesOriginalcbe89caa4ae8c58f7efd0ed6343c35ff); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalcbe89caa4ae8c58f7efd0ed6343c35ff)): ?>
<?php $component = $__componentOriginalcbe89caa4ae8c58f7efd0ed6343c35ff; ?>
<?php unset($__componentOriginalcbe89caa4ae8c58f7efd0ed6343c35ff); ?>
<?php endif; ?>
            </div>
            <h2
                class="text-base md:text-lg font-semibold <?php echo e($hasPendingPersonal ? 'text-gray-600 dark:text-gray-300' : 'text-gray-900 dark:text-gray-50'); ?>">
                Apply as Individual
            </h2>
            <p
                class="text-xs md:text-sm <?php echo e($hasPendingPersonal ? 'text-gray-500 dark:text-gray-400' : 'text-gray-600 dark:text-gray-300'); ?>">
                For individuals seeking funding for programs, equipment, research, or community outreach.
            </p>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($hasPendingPersonal): ?>
            <div class="mt-4 text-center">
                <span
                    class="inline-block w-full px-4 py-2 rounded-lg bg-red-600 text-white font-medium text-sm md:text-base">
                    Pending Application
                </span>
                <p class="mt-1 text-xs text-red-500">
                    You already have a pending personal grant. Please wait for it to be processed before submitting a
                    new application.
                </p>
            </div>
        <?php else: ?>
            <a href="<?php echo e(route('user.grants.personal')); ?>"
                class="mt-4 inline-block w-full text-center px-4 py-2 rounded-lg bg-sky-600 text-white font-medium text-sm md:text-base hover:bg-sky-500 transition-colors duration-200">
                Continue
            </a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

    <!-- Company Card -->
    <div
        class="flex flex-col justify-between h-full p-6 rounded-xl shadow-md dark:shadow-none 
        <?php echo e($hasPendingCompany ? 'bg-gray-200 dark:bg-zinc-700 opacity-70 cursor-not-allowed' : 'bg-gray-50 dark:bg-zinc-800 border border-gray-200 dark:border-zinc-700 hover:scale-105 hover:shadow-lg transition-transform duration-300 cursor-pointer'); ?>">

        <div class="flex flex-col items-center text-center space-y-4">
            <div
                class="w-12 h-12 flex items-center justify-center rounded-full 
                <?php echo e($hasPendingCompany ? 'bg-gray-400' : 'bg-sky-500/20 group-hover:bg-sky-500/30'); ?>">
                <?php if (isset($component)) { $__componentOriginale95e70f8eaeac897e8c4dbb22322d565 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginale95e70f8eaeac897e8c4dbb22322d565 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'e60dd9d2c3a62d619c9acb38f20d5aa5::icon.building-office','data' => ['variant' => 'solid','class' => 'w-5 h-5 '.e($hasPendingCompany ? 'text-gray-600' : 'text-sky-700').'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('flux::icon.building-office'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['variant' => 'solid','class' => 'w-5 h-5 '.e($hasPendingCompany ? 'text-gray-600' : 'text-sky-700').'']); ?>
<?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processComponentKey($component); ?>

<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginale95e70f8eaeac897e8c4dbb22322d565)): ?>
<?php $attributes = $__attributesOriginale95e70f8eaeac897e8c4dbb22322d565; ?>
<?php unset($__attributesOriginale95e70f8eaeac897e8c4dbb22322d565); ?>
<?php endif; ?>
<?php if (isset($__componentOriginale95e70f8eaeac897e8c4dbb22322d565)): ?>
<?php $component = $__componentOriginale95e70f8eaeac897e8c4dbb22322d565; ?>
<?php unset($__componentOriginale95e70f8eaeac897e8c4dbb22322d565); ?>
<?php endif; ?>
            </div>
            <h2
                class="text-base md:text-lg font-semibold <?php echo e($hasPendingCompany ? 'text-gray-600 dark:text-gray-300' : 'text-gray-900 dark:text-gray-50'); ?>">
                Apply as Company
            </h2>
            <p
                class="text-xs md:text-sm <?php echo e($hasPendingCompany ? 'text-gray-500 dark:text-gray-400' : 'text-gray-600 dark:text-gray-300'); ?>">
                For registered organizations with an EIN, established history, and a defined mission.
            </p>
        </div>

        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($hasPendingCompany): ?>
            <div class="mt-4 text-center">
                <span
                    class="inline-block w-full px-4 py-2 rounded-lg bg-red-600 text-white font-medium text-sm md:text-base">
                    Pending Application
                </span>
                <p class="mt-1 text-xs text-red-500">
                    You already have a pending company grant. Please wait for it to be processed before submitting a new
                    application.
                </p>
            </div>
        <?php else: ?>
            <a href="<?php echo e(route('user.grants.company')); ?>"
                class="mt-4 inline-block w-full text-center px-4 py-2 rounded-lg bg-zinc-900 text-white font-medium text-sm md:text-base hover:bg-zinc-500 transition-colors duration-200">
                Continue
            </a>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </div>

</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/components/⚡grant-selector.blade.php ENDPATH**/ ?>