<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['title', 'items' => []]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['title', 'items' => []]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $dropdownActive = false;

    foreach ($items as $item) {
        if (!empty($item['route']) && request()->routeIs($item['route'] . '*')) {
            $dropdownActive = true;
            break;
        }
    }
?>

<div 
    x-data="{ open: <?php echo e($dropdownActive ? 'true' : 'false'); ?> }"
    class="border-t border-gray-200"
>

    <!-- Parent Toggle -->
    <button 
        @click="open = !open"
        class="w-full flex justify-between items-center py-4 px-1
               text-sm font-semibold uppercase tracking-wide
               text-gray-900 focus:outline-none"
    >
        <span class="relative">

            <?php echo e($title); ?>


            <!-- Active underline (if child active) -->
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($dropdownActive): ?>
                <span class="absolute left-0 -bottom-1 w-full h-0.5 bg-sky-600"></span>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
        </span>

        <!-- Chevron -->
        <svg 
            :class="open ? 'rotate-180 text-gray-900' : 'text-gray-500'"
            class="w-4 h-4 transform transition-transform duration-200"
            fill="none"
            stroke="currentColor"
            viewBox="0 0 24 24"
            stroke-width="2"
        >
            <path stroke-linecap="round" stroke-linejoin="round" d="M19 9l-7 7-7-7" />
        </svg>
    </button>

    <!-- Dropdown Items -->
    <div 
        x-show="open" 
        x-collapse 
        x-cloak 
        class="flex flex-col"
    >
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
            <?php
                $href = !empty($item['route']) ? route($item['route']) : '#';
                $isActive = !empty($item['route']) && request()->routeIs($item['route'] . '*');
            ?>

            <a href="<?php echo e($href); ?>"
               class="px-4 py-3 text-sm transition-colors duration-150
                      border-t border-gray-200
                      <?php echo e($isActive
                          ? 'text-gray-900 font-semibold border-l-4 border-sky-600 bg-gray-50'
                          : 'text-gray-800 hover:bg-gray-50'); ?>">
                <?php echo e($item['name']); ?>

            </a>
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>
    </div>
</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/components/mobile-dropdown.blade.php ENDPATH**/ ?>