<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verify Your Email</title>
</head>

<body
    style="margin:0; padding:0; font-family: system-ui, -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background-color: #f9fafb; display: flex; justify-content: center; align-items: center; min-height: 100vh;">

    <div
        style="background-color: #ffffff; padding: 36px 32px; border-radius: 12px; box-shadow: 0 4px 12px rgba(0,0,0,0.08); max-width: 500px; width: 100%; text-align: center;">

        <!-- Header Icon -->
        <svg style="width: 40px; height: 40px; color: #6366f1; margin-bottom: 16px;" fill="none" stroke="currentColor"
            stroke-width="2" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round"
                d="M3 8l7.89 5.26a2 2 0 002.22 0L21 8m-18 8h18a2 2 0 002-2V8a2 2 0 00-2-2H3a2 2 0 00-2 2v6a2 2 0 002 2z" />
        </svg>

        <!-- Title -->
        <h1 style="font-size: 22px; font-weight: 600; color: #111827; margin: 0 0 8px 0;">Verify Your Email</h1>
        <p style="color: #6b7280; font-size: 14px; margin: 0 0 24px 0;">Please confirm your email before continuing</p>

        <!-- Success message -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if(session('message')): ?>
            <div
                style="background-color: #ecfdf5; border: 1px solid #d1fae5; color: #065f46; padding: 10px; border-radius: 6px; margin-bottom: 20px; font-size: 14px;">
                <?php echo e(session('message')); ?>

            </div>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        <!-- Instructions -->
        <p style="color: #4b5563; font-size: 14px; line-height: 1.5; margin-bottom: 24px;">
            Check your inbox for a verification link. If you didn’t receive it, click the button below to resend.
        </p>

        <!-- Resend form -->
        <form method="POST" action="<?php echo e(route('verification.send')); ?>" style="margin-bottom: 16px;">
            <?php echo csrf_field(); ?>
            <button type="submit"
                style="width: 100%; padding: 10px 0; background-color: #6366f1; color: #ffffff; font-weight: 500; border: none; border-radius: 8px; cursor: pointer; font-size: 14px; transition: background-color 0.2s;">
                Resend Verification Email
            </button>
        </form>

        <!-- Footer -->
        <p style="font-size: 12px; color: #9ca3af; margin-top: 12px;">
            Didn’t receive an email? <a href="<?php echo e(route('about.contact')); ?>"
                style="color: #6366f1; text-decoration: none;">Contact support</a>.
        </p>
    </div>

    <!-- Minimal hover effect -->
    <script>
        const btn = document.querySelector('button');
        btn.addEventListener('mouseover', () => btn.style.backgroundColor = '#4f46e5');
        btn.addEventListener('mouseout', () => btn.style.backgroundColor = '#6366f1');
    </script>

</body>

</html>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/auth/verify-email.blade.php ENDPATH**/ ?>