
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">

    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $this->cryptoBalances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $crypto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
        <?php
            $isSelected = (string) $selectedCrypto === (string) $crypto->id;
        ?>

        <div <?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::processElementKey('crypto-card-{{ $crypto->id }}', get_defined_vars()); ?>wire:key="crypto-card-<?php echo e($crypto->id); ?>" wire:click="$set('selectedCrypto', '<?php echo e($crypto->id); ?>')"
            class="relative cursor-pointer rounded-xl p-4 transition-all duration-200
                    flex justify-between items-center
                    <?php echo e($isSelected
                        ? 'bg-sky-600 text-white shadow-lg scale-[1.03]'
                        : 'bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-100 hover:shadow-md hover:scale-[1.01]'); ?>">

            
            <div class="flex items-center gap-3">
                <div
                    class="w-10 h-10 rounded-full flex items-center justify-center
                            bg-sky-100 text-sky-600 dark:bg-sky-900 dark:text-sky-300 text-lg">
                    🪙
                </div>

                <div>
                    <div class="text-sm font-semibold truncate">
                        <?php echo e($crypto->label()); ?>

                    </div>
                    <div class="text-xs text-gray-400 dark:text-gray-300 uppercase tracking-wide">
                        Crypto Balance
                    </div>
                </div>
            </div>

            
            <div class="text-right flex flex-col items-end gap-1">
                
                <div class="text-lg font-bold">
                    <?php echo e($crypto->dashboard_balances['available']); ?>

                </div>

                
                <div
                    class="text-xs px-2 py-0.5 rounded-full
                            <?php echo e($isSelected ? 'bg-white text-sky-600 dark:bg-gray-800 dark:text-sky-400' : 'bg-gray-100 dark:bg-gray-700 text-gray-600 dark:text-gray-300'); ?>">
                    <?php echo e(strtoupper($crypto->network)); ?>

                </div>

                
                <div class="text-xs font-semibold text-gray-800 dark:text-gray-200">
                    $<?php echo e(number_format($crypto->getRate(), 2)); ?>

                </div>
            </div>

            
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($isSelected): ?>
                <div
                    class="absolute -top-2 -right-2 w-6 h-6 rounded-full
                            bg-white text-sky-600 dark:bg-gray-800 dark:text-sky-400
                            flex items-center justify-center text-xs font-bold shadow-md">
                    ✓
                </div>
            <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>

        </div>
    <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>

</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/partials/cryptobalancecard.blade.php ENDPATH**/ ?>