<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames(([
    'title',
    'items' => [],
]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter(([
    'title',
    'items' => [],
]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars, $__key, $__value); ?>

<?php
    $dropdownActive = false;

    foreach ($items as $item) {
        if (!empty($item['route']) && request()->routeIs($item['route'] . '*')) {
            $dropdownActive = true;
            break;
        }
    }

    $triggerBase = 
    '    relative
        inline-flex
        items-center
        h-10
        text-sm
        uppercase
        font-semibold
        tracking-wide
        transition-all
    duration-150
        transition-colors
pb-1';
    $triggerActive = 'text-gray-900 dark:text-white';
    $triggerInactive = 'text-gray-800 dark:text-gray-200 hover:text-gray-900 dark:hover:text-white';
?>

<div x-data="{ open: false }" class="relative">

    <!-- Parent Trigger -->
    <button 
        type="button"
        @click="open = !open"
        @click.away="open = false"
        class="<?php echo e($triggerBase); ?> <?php echo e($dropdownActive ? $triggerActive : $triggerInactive); ?>"
    >
        <span><?php echo e($title); ?></span>

        <!-- Chevron -->
        <svg :class="open ? 'rotate-180' : ''"
             class="h-4 w-4 transform transition-transform duration-200"
             fill="currentColor"
             viewBox="0 0 20 20">
            <path fill-rule="evenodd" clip-rule="evenodd"
                d="M5.23 7.21a.75.75 0 011.06.02L10 10.94l3.71-3.71a.75.75 0 111.08 1.04l-4.25 4.25a.75.75 0 01-1.08 0L5.25 8.27a.75.75 0 01-.02-1.06z" />
        </svg>

        <!-- Active Underline -->
        <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($dropdownActive): ?>
            <span class="absolute left-0 -bottom-0.5 w-full h-0.5 bg-sky-600"></span>
        <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
    </button>

    <!-- Dropdown Panel -->
    <div 
        x-show="open"
        x-cloak
        x-transition.opacity.duration.100ms
        class="absolute left-0 top-full mt-3 w-80 z-30"
        style="display: none;"
    >
        <div class="bg-white dark:bg-gray-900 
                    border border-gray-300 dark:border-gray-700
                    shadow-lg">

            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::openLoop(); ?><?php endif; ?><?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::startLoop($loop->index); ?><?php endif; ?>
                <?php
                    $href = !empty($item['route']) ? route($item['route']) : '#';
                    $isActive = !empty($item['route']) && request()->routeIs($item['route'] . '*');
                ?>

                <a href="<?php echo e($href); ?>"
                   class="block px-6 py-4 text-sm transition-colors duration-150
                          <?php echo e($isActive
                              ? 'bg-gray-100 dark:bg-gray-800 text-gray-900 dark:text-white font-semibold border-l-4 border-sky-600'
                              : 'text-gray-800 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-800'); ?>">
                    <?php echo e($item['name']); ?>

                </a>

                <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if BLOCK]><![endif]--><?php endif; ?><?php if($index !== count($items) - 1): ?>
                    <div class="border-t border-gray-200 dark:border-gray-700"></div>
                <?php endif; ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php endif; ?>
            <?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::endLoop(); ?><?php endif; ?><?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><?php if(\Livewire\Mechanisms\ExtendBlade\ExtendBlade::isRenderingLivewireComponent()): ?><!--[if ENDBLOCK]><![endif]--><?php \Livewire\Features\SupportCompiledWireKeys\SupportCompiledWireKeys::closeLoop(); ?><?php endif; ?>

        </div>
    </div>

</div>
<?php /**PATH /Users/macuser/Herd/Novabank/resources/views/components/dropdown-menu.blade.php ENDPATH**/ ?>