<x-layouts::app :title="__(':app || Loan Application', ['app' => config('app.name')])">

    <div class="space-y-5 py-4 font-sans">
        <div class="flex items-center justify-between gap-2 flex-wrap">
            <a href="{{ route('user.loans.request') }}"
                class="bg-sky-600 text-white flex items-center hover:shadow-2xl justify-center gap-1 px-3 py-2 rounded-md">
                <x-flux::icon.plus variant="solid" class="w-4 h-4" />
                <span class="text-sm font-medium">Loan Request</span>
            </a>

            <a href="{{ route('user.loans.index') }}"
                class="bg-sky-600 text-white flex items-center hover:shadow-2xl justify-center gap-1 px-3 py-2 rounded-md">
                <x-flux::icon.hand-coins class="w-4 h-4" />
                <span class="text-sm font-medium">View Loans History</span>
            </a>
        </div>
        <div
            class="bg-white dark:bg-gray-900 border border-gray-100 dark:border-gray-800 rounded-xl p-4 md:p-6 space-y-4">

            <!-- WHY CHOOSE US -->
            <h2 class="flex items-center gap-3 text-sm md:text-base font-semibold text-gray-800 dark:text-gray-100">
                <span
                    class="bg-sky-500/10 dark:bg-sky-400/10 w-9 h-9 flex items-center justify-center rounded-full text-sky-600 dark:text-sky-400">
                    <x-flux::icon.check-circle variant="solid" class="w-5 h-5" />
                </span>
                Why Choose Our Loan Services
            </h2>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-gray-50 dark:bg-gray-800/60 hover:border-sky-400 dark:hover:border-sky-500 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.clock variant="solid" class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Quick Approval</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Receive a credit decision within hours and funds shortly after approval.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-gray-50 dark:bg-gray-800/60 hover:border-sky-400 dark:hover:border-sky-500 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.arrows-right-left variant="solid"
                            class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Competitive Rates</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Flexible interest rates aligned with your financial profile.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-gray-50 dark:bg-gray-800/60 hover:border-sky-400 dark:hover:border-sky-500 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.bookmark-slash variant="solid"
                            class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Simple Process</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Minimal documentation with a straightforward digital application.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-gray-50 dark:bg-gray-800/60 hover:border-sky-400 dark:hover:border-sky-500 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.shield-check variant="solid"
                            class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Secure & Confidential</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Your data is protected with bank-level encryption and privacy controls.
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- LOAN TYPES -->
            <h2 class="flex items-center gap-3 text-sm md:text-base font-semibold text-gray-800 dark:text-gray-100">
                <span
                    class="bg-sky-500/10 dark:bg-sky-400/10 w-9 h-9 flex items-center justify-center rounded-full text-sky-600 dark:text-sky-400">
                    <x-flux::icon.square-3-stack-3d variant="solid" class="w-5 h-5" />
                </span>
                Available Loan Types
            </h2>

            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-white dark:bg-gray-800 hover:bg-sky-50 dark:hover:bg-gray-700/60 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.home variant="solid" class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Personal Home Loans</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Home financing with flexible repayment terms.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-white dark:bg-gray-800 hover:bg-sky-50 dark:hover:bg-gray-700/60 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.car-front class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Automobile Loans</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Affordable auto financing to get you moving.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-white dark:bg-gray-800 hover:bg-sky-50 dark:hover:bg-gray-700/60 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.briefcase variant="solid" class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Business Loans</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Financing solutions designed for business growth.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-white dark:bg-gray-800 hover:bg-sky-50 dark:hover:bg-gray-700/60 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.user-group variant="solid" class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Joint Mortgage</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Shared responsibility with co-borrowers.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-white dark:bg-gray-800 hover:bg-sky-50 dark:hover:bg-gray-700/60 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.lock-closed variant="solid" class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Secured Overdraft</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Access funds when needed with asset backing.
                            </p>
                        </div>
                    </div>
                </div>

                <div
                    class="rounded-lg border border-gray-200 dark:border-gray-800 p-4 bg-white dark:bg-gray-800 hover:bg-sky-50 dark:hover:bg-gray-700/60 transition">
                    <div class="flex gap-3">
                        <x-flux::icon.heart variant="solid" class="w-5 h-5 text-sky-600 dark:text-sky-400 mt-1" />
                        <div>
                            <h3 class="text-sm font-medium text-gray-900 dark:text-white">Health Finance</h3>
                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                Cover medical expenses with flexible payment options
                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <!-- HOW IT WORKS TIMELINE -->
            <h2 class="flex items-center gap-3 text-sm md:text-base font-semibold text-gray-800 dark:text-gray-100">
                <span
                    class="bg-sky-500/10 dark:bg-sky-400/10 w-9 h-9 flex items-center justify-center rounded-full text-sky-600 dark:text-sky-400">
                    <x-flux::icon.information-circle variant="solid" class="w-5 h-5" />
                </span>
                How It Works
            </h2>
            <div class="relative">
                <!-- Line connector -->
                <div class="absolute left-[0.9rem] top-8 bottom-8 w-0.5 bg-gray-200 dark:bg-gray-600 z-0"></div>

                <div class="space-y-4 relative z-10">
                    <!-- Step 1 -->
                    <div class="flex">
                        <div
                            class="shrink-0 h-8 w-8 rounded-full bg-sky-100 dark:bg-sky-900/50 flex items-center justify-center mr-3 z-10">
                            <span class="text-sky-600 dark:text-sky-400 font-bold text-sm">1</span>
                        </div>
                        <div class="pt-1">
                            <h4 class="font-medium text-gray-900 dark:text-white mb-1 text-sm">Apply Online</h4>
                            <p class="text-xs text-gray-600 dark:text-gray-400">Complete our simple online
                                application form with your details and loan requirements</p>
                        </div>
                    </div>

                    <!-- Step 2 -->
                    <div class="flex">
                        <div
                            class="shrink-0 h-8 w-8 rounded-full bg-sky-100 dark:bg-sky-900/50 flex items-center justify-center mr-3 z-10">
                            <span class="text-sky-600 dark:text-sky-400 font-bold text-sm">2</span>
                        </div>
                        <div class="pt-1">
                            <h4 class="font-medium text-gray-900 dark:text-white mb-1 text-sm">Quick Review</h4>
                            <p class="text-xs text-gray-600 dark:text-gray-400">Our team reviews your application
                                and may contact you for additional information</p>
                        </div>
                    </div>

                    <!-- Step 3 -->
                    <div class="flex">
                        <div
                            class="shrink-0 h-8 w-8 rounded-full bg-sky-100 dark:bg-sky-900/50 flex items-center justify-center mr-3 z-10">
                            <span class="text-sky-600 dark:text-sky-400 font-bold text-sm">3</span>
                        </div>
                        <div class="pt-1">
                            <h4 class="font-medium text-gray-900 dark:text-white mb-1 text-sm">Approval &amp;
                                Disbursement</h4>
                            <p class="text-xs text-gray-600 dark:text-gray-400">Once approved, the loan amount will
                                be transferred to your account</p>
                        </div>
                    </div>
                </div>
            </div>

            <div
                class="relative overflow-hidden rounded-xl 
           bg-linear-to-r from-sky-500/20 to-sky-400/10 
           dark:from-sky-500/10 dark:to-sky-400/5
           backdrop-blur-md p-6">

                <div class="max-w-full md:max-w-2xl mx-auto text-center space-y-4">

                    <h2
                        class="text-sm md:text-base font-semibold 
                   text-gray-900 dark:text-gray-100">
                        Ready to get started?
                    </h2>

                    <p class="text-xs md:text-sm leading-relaxed 
                   text-gray-700 dark:text-gray-300">
                        Apply now and receive a quick decision on your loan application.
                    </p>

                    <a href="{{ route('user.loans.request') }}"
                        class="inline-flex items-center gap-2 rounded-lg 
                  bg-sky-700 dark:bg-sky-600
                  px-4 py-2.5 text-sm font-semibold text-white
                  shadow-sm transition
                  hover:bg-sky-600 dark:hover:bg-sky-500
                  focus:outline-none focus:ring-2
                  focus:ring-sky-400 dark:focus:ring-sky-500
                  focus:ring-offset-2 focus:ring-offset-white dark:focus:ring-offset-gray-900">

                        <x-flux::icon.pencil-square variant="solid" class="h-5 w-5 text-white" />

                        Apply for a Loan
                    </a>

                </div>
            </div>


        </div>

    </div>
</x-layouts::app>
