<x-layouts::front :title="__('Web Accessibility Privacy Policy', ['app' => config('app.name')])">
<div class="">
            <x-hero-static
    title="Web Accessibility"
    backgroundType="gradient"
    gradient="bg-gradient-to-r from-sky-700 via-sky-600 to-sky-800"
    height="h-[60vh] md:h-[40vh]"
/>
@php
$loanTypes = [
    [
        'heading' => 'Commitment to Web Accessibility',
        'content' => '
            <p>
                Digital accessibility is an essential part of providing inclusive financial services. 
                Online services are designed to be accessible to individuals of all abilities, 
                including those who use assistive technologies such as screen readers, 
                speech recognition software, magnifiers, and alternative input devices.
            </p>

            <p>
                Ongoing efforts are made to align digital properties with recognized 
                accessibility standards and best practices. Accessibility is considered 
                during design, development, content updates, and platform enhancements.
            </p>
        ',
    ],

    [
        'heading' => 'Accessibility Standards',
        'content' => '
            <p>
                Digital platforms aim to conform to the Web Content Accessibility Guidelines (WCAG) 2.1, 
                Level AA standards. These guidelines are developed by the World Wide Web Consortium (W3C) 
                and provide technical recommendations for making web content more accessible.
            </p>

            <table class="min-w-full border border-gray-300 dark:border-gray-700 mt-4 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-800">
                    <tr>
                        <th class="border px-4 py-2 text-left">Standard</th>
                        <th class="border px-4 py-2 text-left">Focus Area</th>
                        <th class="border px-4 py-2 text-left">Purpose</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="border px-4 py-2">WCAG 2.1 Level AA</td>
                        <td class="border px-4 py-2">Perceivable & Operable Content</td>
                        <td class="border px-4 py-2">Ensures content can be accessed through multiple assistive technologies</td>
                    </tr>
                    <tr>
                        <td class="border px-4 py-2">ADA Compliance</td>
                        <td class="border px-4 py-2">Equal Digital Access</td>
                        <td class="border px-4 py-2">Supports nondiscrimination and accessibility in digital services</td>
                    </tr>
                </tbody>
            </table>
        '
    ],

    [
        'heading' => 'Accessibility Features',
        'content' => '
            <p>
                Several features are implemented to improve usability and accessibility across devices:
            </p>

            <table class="min-w-full border border-gray-300 dark:border-gray-700 mt-4 text-sm">
                <thead class="bg-gray-100 dark:bg-gray-800">
                    <tr>
                        <th class="border px-4 py-2 text-left">Feature</th>
                        <th class="border px-4 py-2 text-left">Description</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="border px-4 py-2">Keyboard Navigation</td>
                        <td class="border px-4 py-2">Full site functionality available without a mouse</td>
                    </tr>
                    <tr>
                        <td class="border px-4 py-2">Alternative Text</td>
                        <td class="border px-4 py-2">Descriptive alt text for meaningful images</td>
                    </tr>
                    <tr>
                        <td class="border px-4 py-2">Color Contrast</td>
                        <td class="border px-4 py-2">Text and background contrast ratios meet accessibility standards</td>
                    </tr>
                    <tr>
                        <td class="border px-4 py-2">Resizable Text</td>
                        <td class="border px-4 py-2">Content remains readable when zoomed up to 200%</td>
                    </tr>
                    <tr>
                        <td class="border px-4 py-2">Form Labels</td>
                        <td class="border px-4 py-2">Proper labeling and instructions for screen readers</td>
                    </tr>
                </tbody>
            </table>
        '
    ],

    [
        'heading' => 'Ongoing Improvements',
        'content' => '
            <p>
                Accessibility is an ongoing process. Digital properties are regularly reviewed 
                using automated testing tools, manual audits, and assistive technology testing. 
                Feedback from users is carefully evaluated and used to prioritize enhancements.
            </p>

            <p>
                Third-party vendors and service providers are encouraged to maintain 
                accessibility standards consistent with internal policies whenever feasible.
            </p>
        '
    ],

    [
        'heading' => 'Need Assistance?',
        'content' => '
            <p>
                If difficulty is experienced accessing any portion of the website, 
                assistance is available. Support can be requested by phone, by visiting 
                a local branch, or by submitting a message through the Contact page.
            </p>

            <p>
                When contacting support, please include details about the issue encountered, 
                the page URL (if known), and the type of assistive technology being used. 
                This information helps resolve concerns more efficiently.
            </p>
        '
    ],
];
@endphp

<x-privacy-section
   updated="Last Updated: {{ now()->format('F d, Y') }}"
    textColor="text-sky-900 dark:text-sky-50"
    :sections="$loanTypes"
/>

</div>
</x-layouts::front>