<x-layouts::front :title="__('Privacy & Data', ['app' => config('app.name')])">
<div class="">
            <x-hero-static
    title="Privacy & Data"
    backgroundType="gradient"
    gradient="bg-gradient-to-r from-sky-700 via-sky-600 to-sky-800"
    height="h-[60vh] md:h-[40vh]"
/>

@php
    $appName = config('app.name');
    $contactUrl = route('about.contact');
    $host = request()->getHost();
    $privacyEmail = "privacy@{$host}";

    $additionalPrivacySections = [

        [
            'heading' => 'Third-Party Services',
            'content' => "
                <p>
                    {$appName} may use third-party service providers for analytics, marketing, IT services, customer support, payment processing, and fraud prevention.
                    These providers are contractually required to protect your personal information and may only use it for the purposes we authorize.
                </p>
                <p>
                    Examples include cloud hosting, identity verification services, fraud monitoring tools, email delivery providers, and customer communication platforms.
                    We evaluate providers carefully to ensure they meet our privacy and security standards.
                </p>
            ",
        ],

        [
            'heading' => 'International Data Transfers',
            'content' => "
                <p>
                    If information is accessed or transferred outside the United States, we take steps to ensure that the data remains protected in accordance with U.S. privacy laws and banking security standards.
                </p>
                <p>
                    Certain operations may involve cross-border processing for regulatory compliance, payment processing, customer support, or technology infrastructure.
                    Regardless of where processing occurs, we apply consistent security and confidentiality requirements.
                </p>
            ",
        ],

        [
            'heading' => 'Marketing & Communications',
            'content' => "
                <p>
                    We may use your contact information to send informational messages about your account, service updates, or product announcements.
                    Where permitted by law, we may also send promotional communications about products, services, and events.
                </p>
                <p>
                    You can opt out of marketing communications at any time by using the unsubscribe link in an email, updating preferences (where available),
                    or contacting our support team through our <a href='{$contactUrl}' class='text-primary-600 hover:underline'>Contact Us</a> page.
                </p>
            ",
        ],

        [
            'heading' => 'Automated Decision Making',
            'content' => "
                <p>
                    In some cases, automated systems may be used to evaluate applications, detect fraud, reduce risk, or assess creditworthiness.
                    These systems may use algorithms and scoring models based on the information you provide and information from permitted third-party sources.
                </p>
                <p>
                    If legally required, you may request human review of certain automated decisions.
                    If you have questions about a decision, please contact us through our <a href='{$contactUrl}' class='text-primary-600 hover:underline'>Contact Us</a> page.
                </p>
            ",
        ],

        [
            'heading' => 'Data Breach Notifications',
            'content' => "
                <p>
                    In the unlikely event of a data breach, {$appName} will comply with federal and state notification requirements.
                    If your personal information is impacted, we will notify you promptly with information about what happened and recommended steps to protect your account.
                </p>
                <p>
                    Notifications may be delivered via email, postal mail, secure message, or phone depending on the nature and severity of the incident.
                </p>
            ",
        ],

        [
            'heading' => 'Cookies & Tracking Technologies',
            'content' => "
                <p>
                    We use cookies and similar technologies to support essential site functionality, protect against fraud, measure performance, and improve user experience.
                    Some cookies are necessary for secure login sessions and to maintain site preferences.
                </p>
                <p>
                    You may control cookies through your browser settings. Disabling certain cookies may limit functionality such as secure login sessions or preference saving.
                </p>

                <div class='overflow-x-auto mt-4'>
                    <table class='min-w-full border border-gray-200 dark:border-gray-700 text-left text-gray-700 dark:text-gray-300'>
                        <thead class='bg-gray-100 dark:bg-gray-800'>
                            <tr>
                                <th class='px-4 py-2 font-medium border-b border-gray-200 dark:border-gray-700'>Type</th>
                                <th class='px-4 py-2 font-medium border-b border-gray-200 dark:border-gray-700'>Purpose</th>
                                <th class='px-4 py-2 font-medium border-b border-gray-200 dark:border-gray-700'>Duration</th>
                            </tr>
                        </thead>
                        <tbody class='bg-white dark:bg-gray-900 divide-y divide-gray-200 dark:divide-gray-700'>
                            <tr>
                                <td class='px-4 py-2'>Essential Cookies</td>
                                <td class='px-4 py-2'>Maintain secure login sessions, security controls, and core functionality</td>
                                <td class='px-4 py-2'>Session</td>
                            </tr>
                            <tr>
                                <td class='px-4 py-2'>Analytics Cookies</td>
                                <td class='px-4 py-2'>Help us understand usage patterns to improve performance and content</td>
                                <td class='px-4 py-2'>Up to 1 year</td>
                            </tr>
                            <tr>
                                <td class='px-4 py-2'>Marketing Cookies</td>
                                <td class='px-4 py-2'>Deliver relevant offers and measure campaign performance (where applicable)</td>
                                <td class='px-4 py-2'>Up to 6 months</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            ",
        ],

        [
            'heading' => 'Policy Updates',
            'content' => "
                <p>
                    {$appName} may update this Privacy & Data policy from time to time to reflect changes in legal requirements, banking practices, or technology.
                    The “Last Updated” date at the top of this page indicates the most recent revision.
                </p>
                <p>
                    We encourage you to review this policy periodically. Continued use of our services after an update constitutes acceptance of the revised policy.
                </p>
            ",
        ],

        [
            'heading' => 'User Access, Correction & Requests',
            'content' => "
                <p>
                    You have the right to request access to the personal information we hold about you and request corrections to inaccurate, incomplete, or outdated data.
                    Depending on your jurisdiction, you may also have the right to request deletion, restriction, or portability of certain personal information.
                </p>
                <p>
                    Requests can be submitted through our
                    <a href='{$contactUrl}' class='text-primary-600 hover:underline'>Contact Us</a>
                    page or via your secure online banking portal (where available).
                </p>
                <p>
                    For security purposes, we may require identity verification before processing a request. We aim to respond within a reasonable timeframe and in accordance with applicable privacy laws.
                </p>
            ",
        ],

        [
            'heading' => 'Data Retention',
            'content' => "
                <p>
                    We retain personal information only as long as necessary to provide services, comply with legal and regulatory obligations,
                    resolve disputes, and enforce agreements.
                </p>
                <p>
                    Retention periods vary depending on the type of data, regulatory requirements, and business needs.
                    When data is no longer required, it is securely deleted, anonymized, or archived according to legal requirements.
                </p>
            ",
        ],

        [
            'heading' => 'Security Measures',
            'content' => "
                <p>
                    {$appName} employs industry-standard technical, administrative, and physical safeguards to protect personal information against unauthorized access,
                    disclosure, alteration, or destruction.
                </p>
                <p>
                    Security measures may include encryption in transit and at rest, multi-factor authentication, access controls, secure firewalls,
                    intrusion detection systems, and routine security audits.
                </p>
                <p>
                    Even with strong safeguards, no method of electronic storage or transmission is completely secure.
                    Users are encouraged to protect their credentials and report suspicious activity immediately.
                </p>
            ",
        ],

        [
            'heading' => 'Children’s Privacy',
            'content' => "
                <p>
                    Our services are not directed at children under the age of 13 (or a higher minimum age required by local law).
                    We do not knowingly collect personal information from children without parental consent.
                </p>
                <p>
                    If you believe we have inadvertently collected information from a child, please contact us through our
                    <a href='{$contactUrl}' class='text-primary-600 hover:underline'>Contact Us</a> page and we will take appropriate steps to delete it.
                </p>
            ",
        ],

        [
            'heading' => 'Data Portability',
            'content' => "
                <p>
                    Where legally required, you may request a copy of certain personal information in a structured, commonly used, and machine-readable format.
                    This may allow you to transfer your data to another provider or retain it for your records.
                </p>
                <p>
                    Requests must be submitted through secure channels and may require identity verification.
                </p>
            ",
        ],

        [
            'heading' => 'Legal Disclosures',
            'content' => "
                <p>
                    We may disclose personal information if required by law, court order, subpoena, regulatory authority,
                    or to prevent fraud, financial crime, or illegal activity.
                </p>
                <p>
                    When disclosure is required, we limit it to what is necessary and handle the process with strict confidentiality and security.
                </p>
            ",
        ],

        [
            'heading' => 'Behavioral & Interest-Based Advertising',
            'content' => "
                <p>
                    We may use cookies, pixels, or similar technologies to deliver advertising that may be more relevant based on your browsing activity.
                    This is sometimes called interest-based advertising.
                </p>
                <p>
                    You may opt out of interest-based advertising through industry tools such as
                    <a href='https://optout.aboutads.info/' class='text-primary-600 hover:underline'>YourAdChoices</a>
                    or through your browser/device settings.
                </p>
            ",
        ],

        [
            'heading' => 'Do Not Track Signals',
            'content' => "
                <p>
                    Some browsers transmit “Do Not Track” signals. At this time, our systems do not automatically alter tracking behavior in response to these signals.
                    However, we provide options to manage cookies and marketing preferences where applicable.
                </p>
            ",
        ],

        [
            'heading' => 'Browser & Device Information',
            'content' => "
                <p>
                    We may collect technical information such as browser type, IP address, operating system, and device identifiers.
                    This helps us maintain site functionality, optimize performance, detect fraud, and improve security.
                </p>
                <p>
                    This information is generally used in aggregated form and is not intended to identify you personally unless needed for security purposes.
                </p>
            ",
        ],

        [
            'heading' => 'Accessibility Compliance',
            'content' => "
                <p>
                    {$appName} is committed to making its website accessible in accordance with the
                    <a href='https://www.w3.org/WAI/WCAG21/quickref/' class='text-primary-600 hover:underline'>WCAG 2.1 AA guidelines</a>.
                </p>
                <p>
                    If you encounter accessibility barriers or require alternate formats, please contact us via our
                    <a href='{$contactUrl}' class='text-primary-600 hover:underline'>Contact Us</a> page.
                </p>
            ",
        ],

        [
            'heading' => 'Links to Other Sites',
            'content' => "
                <p>
                    Our website may contain links to third-party websites. We are not responsible for the privacy practices or content of external sites.
                    We encourage you to review their privacy policies before providing any personal information.
                </p>
            ",
        ],

        [
            'heading' => 'Policy Contact',
            'content' => "
                <p>
                    If you have questions, concerns, or complaints regarding this Privacy & Data policy, you may contact our Privacy Officer:
                </p>
                <ul class='list-disc list-inside space-y-1'>
                    <li>Email: <a href='mailto:{$privacyEmail}' class='text-primary-600 hover:underline'>{$privacyEmail}</a></li>
                    <li>Phone: 1-800-XXX-XXXX</li>
                    <li>Mail: {$appName}, Attn: Privacy Officer, 123 Main Street, City, State ZIP</li>
                </ul>
                <p class='mt-3'>
                    We take privacy inquiries seriously and will respond within a reasonable timeframe.
                </p>
            ",
        ],

        [
            'heading' => 'Legal Disclaimers',
            'content' => "
                <p>
                    This Privacy & Data policy is provided for informational purposes only and does not create a contract or alter any existing agreements.
                    Terms may change without notice.
                </p>
                <p>
                    {$appName} reserves the right to update policies as necessary to comply with applicable laws and regulations.
                    Users are responsible for reviewing this page periodically.
                </p>
            ",
        ],

        [
            'heading' => 'Retention of Non-Personal Information',
            'content' => "
                <p>
                    Non-personal or aggregated data may be retained indefinitely for analysis, reporting, product improvement, and service optimization.
                    Examples include anonymized traffic statistics and aggregated survey results.
                </p>
            ",
        ],

        [
            'heading' => 'Third-Party Analytics',
            'content' => "
                <p>
                    We may use analytics tools to monitor website performance, measure engagement, and improve usability.
                    Analytics providers may collect information through cookies or scripts.
                </p>
                <p>
                    Where possible, analytics are anonymized or aggregated to reduce privacy impact.
                </p>
            ",
        ],

        [
            'heading' => 'Feedback & Surveys',
            'content' => "
                <p>
                    If you participate in surveys, polls, or feedback forms, responses may be used to improve our products and services.
                    Participation is voluntary and any personal information submitted will be handled according to this policy.
                </p>
            ",
        ],
        [
    'heading' => 'Account & Transaction Information',
    'content' => "
        <p>
            When you use {$appName}, we may collect and process account-related information such as account numbers (masked where appropriate),
            balances, transaction history, payment instructions, beneficiary details, and related metadata.
        </p>
        <p>
            This information is used to provide banking services, process transactions, prevent fraud, comply with financial regulations,
            and provide accurate customer support.
        </p>
    ",
],

[
    'heading' => 'Identity Verification (KYC)',
    'content' => "
        <p>
            As a financial institution, we may be required to verify your identity under Know Your Customer (KYC) and anti-money laundering laws.
            This may include collecting and verifying information such as your name, address, date of birth, government-issued identification,
            and other supporting documentation.
        </p>
        <p>
            We may also use third-party identity verification services to confirm authenticity and reduce fraud risk.
        </p>
    ",
],

[
    'heading' => 'Anti-Fraud & Financial Crime Monitoring',
    'content' => "
        <p>
            We actively monitor accounts and transactions to detect fraud, account takeover attempts, identity theft, and other suspicious activity.
            This may involve automated systems, behavioral analytics, and risk scoring.
        </p>
        <p>
            Where required, suspicious activity may be reported to relevant authorities in accordance with applicable laws.
        </p>
    ",
],

[
    'heading' => 'Information We Collect Automatically',
    'content' => "
        <p>
            When you access our website or online banking portal, we may automatically collect information such as IP address,
            device type, browser type, operating system, session timestamps, pages visited, and error logs.
        </p>
        <p>
            This information helps us maintain security, troubleshoot issues, prevent abuse, and improve performance.
        </p>
    ",
],

[
    'heading' => 'Customer Support & Communications',
    'content' => "
        <p>
            If you contact us through phone, email, chat, or online forms, we may keep records of those communications.
            This may include support tickets, call recordings (where permitted by law), chat transcripts, and email history.
        </p>
        <p>
            These records help us resolve issues, improve service quality, and meet regulatory requirements.
        </p>
    ",
],

[
    'heading' => 'Biometric & Authentication Data',
    'content' => "
        <p>
            If supported by your device, you may choose to use biometric authentication such as fingerprint or facial recognition
            to access your account. Biometric data is generally stored on your device and not transmitted to {$appName}.
        </p>
        <p>
            We may store authentication logs such as login timestamps, failed login attempts, and security events to protect your account.
        </p>
    ",
],

[
    'heading' => 'Two-Factor Authentication (2FA)',
    'content' => "
        <p>
            To protect your account, we may use multi-factor authentication (MFA/2FA) such as one-time codes via SMS, email,
            authenticator apps, or secure banking portal verification.
        </p>
        <p>
            You are responsible for keeping your authentication credentials secure and not sharing one-time codes with anyone.
        </p>
    ",
],

[
    'heading' => 'How We Use Your Information',
    'content' => "
        <p>
            We use personal information for the following purposes:
        </p>
        <ul class='list-disc list-inside space-y-1'>
            <li>To provide, operate, and maintain our banking services</li>
            <li>To process payments and transactions</li>
            <li>To verify identity and comply with regulatory requirements</li>
            <li>To detect, prevent, and investigate fraud and security incidents</li>
            <li>To provide customer support and respond to requests</li>
            <li>To improve our website, mobile experience, and product offerings</li>
            <li>To send important account, security, or service communications</li>
        </ul>
    ",
],

[
    'heading' => 'When We Share Your Information',
    'content' => "
        <p>
            We do not sell your personal information. However, we may share information in limited circumstances such as:
        </p>
        <ul class='list-disc list-inside space-y-1'>
            <li>With service providers who help us operate and secure our services</li>
            <li>With payment networks, processors, and financial partners to complete transactions</li>
            <li>With regulators, auditors, and law enforcement where legally required</li>
            <li>With affiliates or successor entities in the event of a merger, acquisition, or restructuring</li>
            <li>With your consent or at your direction</li>
        </ul>
    ",
],

[
    'heading' => 'Affiliates & Corporate Restructuring',
    'content' => "
        <p>
            We may share information with affiliated entities for operational, compliance, and risk management purposes.
            If {$appName} is involved in a merger, acquisition, financing, or sale of assets, personal information may be transferred
            as part of that transaction, subject to applicable confidentiality and privacy requirements.
        </p>
    ",
],

[
    'heading' => 'Regulatory Compliance & Recordkeeping',
    'content' => "
        <p>
            As a regulated financial institution, we may be required to retain certain records for a minimum period of time,
            even if you close your account. These requirements may arise from banking, tax, anti-money laundering, and consumer protection laws.
        </p>
        <p>
            Where required, we retain information securely and limit access to authorized personnel.
        </p>
    ",
],

[
    'heading' => 'Your Privacy Rights (General)',
    'content' => "
        <p>
            Depending on your jurisdiction, you may have privacy rights such as:
        </p>
        <ul class='list-disc list-inside space-y-1'>
            <li>The right to access personal information we hold about you</li>
            <li>The right to request correction of inaccurate information</li>
            <li>The right to request deletion (subject to legal obligations)</li>
            <li>The right to object to certain processing activities</li>
            <li>The right to withdraw consent where processing is based on consent</li>
        </ul>
        <p class='mt-3'>
            To submit a request, please use our <a href='{$contactUrl}' class='text-primary-600 hover:underline'>Contact Us</a> page.
        </p>
    ",
],

[
    'heading' => 'Email Security & Phishing Awareness',
    'content' => "
        <p>
            {$appName} will never ask for your password, PIN, or full authentication codes via email or unsolicited phone calls.
            If you receive suspicious messages claiming to be from us, do not click links or share personal information.
        </p>
        <p>
            If you believe your account has been compromised, contact us immediately through official channels.
        </p>
    ",
],

[
    'heading' => 'How to Keep Your Account Secure',
    'content' => "
        <p>
            We recommend the following best practices to help protect your account:
        </p>
        <ul class='list-disc list-inside space-y-1'>
            <li>Use a strong, unique password</li>
            <li>Enable multi-factor authentication where available</li>
            <li>Do not share login credentials or one-time codes</li>
            <li>Log out after using shared or public devices</li>
            <li>Keep your browser and operating system updated</li>
            <li>Monitor your account regularly for unusual activity</li>
        </ul>
    ",
],

[
    'heading' => 'Data Minimization & Purpose Limitation',
    'content' => "
        <p>
            We only collect personal information that is reasonably necessary for banking operations, legal compliance,
            service delivery, and account security. We do not collect personal information that is unrelated to these purposes.
        </p>
        <p>
            Access to personal information is restricted to authorized personnel and service providers who need it to perform their duties.
        </p>
    ",
],

[
    'heading' => 'Confidentiality & Employee Access',
    'content' => "
        <p>
            Employees and contractors are required to follow confidentiality obligations and security policies.
            Access to customer information is controlled and monitored. Unauthorized access or misuse may result in disciplinary action
            and legal consequences.
        </p>
    ",
],

[
    'heading' => 'Data Integrity & Accuracy',
    'content' => "
        <p>
            We take reasonable steps to ensure personal information is accurate, complete, and up to date.
            Customers are encouraged to update account details promptly when changes occur.
        </p>
        <p>
            If you believe information is incorrect, you may request an update through your secure online banking portal
            or via our <a href='{$contactUrl}' class='text-primary-600 hover:underline'>Contact Us</a> page.
        </p>
    ",
],

[
    'heading' => 'Incident Response & Security Monitoring',
    'content' => "
        <p>
            We maintain an internal incident response process to detect, respond to, and recover from security events.
            Our systems may generate logs and alerts to monitor suspicious activity, protect infrastructure, and ensure availability.
        </p>
        <p>
            Where appropriate, we may temporarily restrict access or require additional verification to protect customers.
        </p>
    ",
],

    ];
@endphp


<x-privacy-section
    textColor="text-red-900 dark:text-red-50"
       updated="Last Updated: {{ now()->format('F d, Y') }}"
    :sections="$additionalPrivacySections"
/>

</div>
</x-layouts::front>
