<x-layouts::front :title="__('about || Credit Card', ['app' => config('app.name')])">
    <div class="">
        <!-- Hero Section -->
      <x-hero-static
    title="Credit Cards Designed for Your Life"
    description="Enjoy flexibility, rewards, and security with credit cards that fit your spending habits. Shop confidently with competitive rates and powerful fraud protection."
      badge="For individual"
    badgeIcon="user"
/>

        <!-- Breadcrumbs -->
        <x-breadcrumbs config-key="personal_banking" />

        <!-- Credit Card Account Card -->
        <x-account-card
            title="Empower Rewards Credit Card"
            icon="credit-card"
            iconVariant="solid"
            iconColor="bg-sky-900"
            :features="[
                'description' => 'Earn rewards while managing your spending responsibly. Enjoy perks, cashback, and exclusive offers tailored to your lifestyle.',
                'list' => [
                    'No annual fee',
                    'Cashback on every purchase',
                    'Rewards points redeemable for travel, gift cards, or statement credit',
                    'Fraud protection and purchase security',
                    'Online account management and mobile app',
                    '0% APR on balance transfers for the first 12 months',
                ]
            ]"
            ctaText="Apply Now"
            ctaLink="{{ route('user.virtual.cards') }}"
        />

        <section class="py-8 md:py-12 bg-gray-50 dark:bg-gray-900">
    <div class="max-w-7xl mx-auto px-6 lg:px-16 fade-in-up">

        <div class="grid lg:grid-cols-2 gap-16 items-center">

            <!-- LEFT: Stacked Credit Cards -->
          <div class="relative w-full max-w-md mx-auto h-64">

    <!-- Back Card -->
    <div class="absolute top-6 left-6 w-full h-56 rounded-2xl 
                bg-linear-to-br from-gray-800 to-gray-900 
                text-white shadow-xl 
                p-6 flex flex-col justify-between
                transform transition duration-500 hover:-translate-y-1">

        <!-- Card Top -->
        <div class="flex justify-between items-start">
            <div class="text-sm tracking-widest opacity-70">
                CREDIT CARD
            </div>

            <!-- Mastercard Logo -->
            <div class="relative w-12 h-8">
                <span class="absolute w-8 h-8 bg-red-500 rounded-full left-0"></span>
                <span class="absolute w-8 h-8 bg-yellow-400 rounded-full right-0 opacity-90"></span>
            </div>
        </div>

        <!-- Card Number -->
        <div class="text-lg tracking-widest font-mono">
            •••• •••• •••• 4821
        </div>

        <!-- Card Footer -->
        <div class="flex justify-between items-center text-sm">
            <div>
                <p class="opacity-60">CARD HOLDER</p>
                <p class="font-semibold">JOHN DOE</p>
            </div>
            <div>
                <p class="opacity-60">EXPIRES</p>
                <p class="font-semibold">08/28</p>
            </div>
        </div>
    </div>

    <!-- Front Card -->
    <div class="absolute top-0 left-0 w-full h-56 rounded-2xl 
                bg-linear-to-br from-sky-700 via-sky-800 to-sky-900 
                text-white shadow-2xl 
                p-6 flex flex-col justify-between
                backdrop-blur-md
                transition duration-500 hover:-translate-y-2">

        <!-- Card Top -->
        <div class="flex justify-between items-start">
            <div class="text-sm tracking-widest opacity-80">
                {{ config('app.name') }}
            </div>

            <!-- Mastercard Logo -->
            <div class="relative w-12 h-8">
                <span class="absolute w-8 h-8 bg-red-500 rounded-full left-0"></span>
                <span class="absolute w-8 h-8 bg-yellow-400 rounded-full right-0 opacity-90"></span>
            </div>
        </div>

        <!-- Chip + Number -->
        <div>
            <div class="w-10 h-7 bg-yellow-300 rounded-md mb-4"></div>
            <div class="text-xl tracking-widest font-mono">
                5283  9012  4821  7745
            </div>
        </div>

        <!-- Card Footer -->
        <div class="flex justify-between items-center text-sm">
            <div>
                <p class="opacity-60">CARD HOLDER</p>
                <p class="font-semibold">JOHN DOE</p>
            </div>
            <div>
                <p class="opacity-60">EXPIRES</p>
                <p class="font-semibold">08/28</p>
            </div>
        </div>
    </div>

</div>


            <!-- RIGHT: Content Section -->
            <div class="space-y-6 text-center lg:text-left">

                <h2 class="text-3xl md:text-4xl font-bold text-gray-900 dark:text-white leading-tight">
                    A credit card aligned with your financial goals
                </h2>

                <p class="text-gray-600 dark:text-gray-300 text-lg leading-relaxed max-w-xl">
                    Contact your primary officer or client team for more information on the program features and application.
                    If you have an existing credit card and need support, please contact us at
                    <span class="font-medium text-sky-700 dark:text-sky-400">
                        {{ config('app.email') }}
                    </span>.
                </p>

                <div>
                    <a href="{{ route('user.virtual.cards') }}"
                       class="inline-flex items-center gap-3 px-8 py-4 
                              bg-sky-700 hover:bg-sky-800 
                              text-white font-semibold rounded-full 
                              shadow-lg hover:shadow-xl 
                              transition-all duration-300">
                        Get a Card
                        <x-flux::icon.arrow-right class="w-5 h-5"/>
                    </a>
                </div>

            </div>

        </div>

    </div>
</section>

<section class="relative bg-gray-50 dark:bg-gray-900 overflow-hidden">
            <div x-data="cardSections()" class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-0 py-16 space-y-10 ">

    <!-- ========================================================= -->
    <!-- 1) Stacked Credit Card Showcase -->
    <!-- ========================================================= -->
    <section class="relative">
        <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-6 text-center fade-in-up">
            Featured Credit Cards
        </h2>
        <p class="text-center text-gray-600 dark:text-gray-300 mb-12 max-w-2xl mx-auto">
            Explore our premium card options designed to suit your lifestyle. See rewards, interest rates, and exclusive benefits at a glance.
        </p>

        <div class="relative w-full max-w-md mx-auto">
            <!-- Stacked cards using absolute positioning -->
            <div class="relative h-64">
                <template x-for="(card, index) in stackedCards" :key="card.id">
                    <div 
                        class="absolute w-full h-48 rounded-2xl shadow-xl transition-transform duration-300"
                        :style="`top: ${index * 12}px; left: ${index * 8}px; z-index: ${100 - index}; background: linear-gradient(135deg, ${card.bgFrom}, ${card.bgTo}); transform: rotate(${index - 1}deg)`">
                        <div class="p-6 flex flex-col justify-between h-full text-white">
                            <div>
                                <span class="text-lg font-semibold" x-text="card.name"></span>
                            </div>
                            <div class="mt-auto flex justify-between items-end">
                                <span class="text-sm" x-text="card.type"></span>
                                <span class="text-2xl font-bold" x-text="card.limit"></span>
                            </div>
                        </div>
                    </div>
                </template>
            </div>
        </div>
    </section>

    <!-- ========================================================= -->
    <!-- 2) Card Selection Grid -->
    <!-- ========================================================= -->
    <section class="fade-in-up">
        <h2 class="text-3xl font-bold text-gray-900 dark:text-white mb-6 text-center">
            Find the Right Card for You
        </h2>
        <p class="text-center text-gray-600 dark:text-gray-300 mb-12 max-w-2xl mx-auto">
            Compare features, rewards, and interest rates across all our credit cards and choose one that matches your needs.
        </p>

        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
            <template x-for="card in allCards" :key="card.id">
                <div class="bg-white dark:bg-gray-900 rounded-2xl shadow-lg p-6 flex flex-col justify-between hover:scale-105 transform transition duration-300 cursor-pointer">
                    <div>
                        <h3 class="text-xl font-semibold text-gray-800 dark:text-gray-100 mb-2" x-text="card.name"></h3>
                        <p class="text-gray-500 dark:text-gray-400 text-sm mb-4" x-text="card.description"></p>
                    </div>
                    <div class="mt-auto flex justify-between items-center">
                        <span class="text-gray-700 dark:text-gray-300 font-bold" x-text="card.limit"></span>
                        <span class="text-green-500 dark:text-green-400 text-sm font-semibold" x-text="card.rewards"></span>
                    </div>
                </div>
            </template>
        </div>
    </section>

</div>
        </section>

<script>
function cardSections() {
    return {
        stackedCards: [
            { id: 1, name: "Platinum Elite", type: "Premium", limit: "$15,000", bgFrom: "#1e3a8a", bgTo: "#3b82f6" },
            { id: 2, name: "Gold Rewards", type: "Rewards", limit: "$10,000", bgFrom: "#b45309", bgTo: "#facc15" },
            { id: 3, name: "Everyday Cash", type: "Cashback", limit: "$5,000", bgFrom: "#065f46", bgTo: "#10b981" },
        ],
        allCards: [
            { id: 1, name: "Platinum Elite", description: "Premium benefits including lounge access, concierge, and high rewards.", limit: "$15,000", rewards: "5% Cashback" },
            { id: 2, name: "Gold Rewards", description: "Great for shopping and dining with exclusive discounts.", limit: "$10,000", rewards: "3% Cashback" },
            { id: 3, name: "Everyday Cash", description: "Perfect for daily expenses with cashback on groceries and utilities.", limit: "$5,000", rewards: "1.5% Cashback" },
            { id: 4, name: "Travel Explorer", description: "Ideal for frequent travelers with travel insurance and miles.", limit: "$12,000", rewards: "3x Miles" },
            { id: 5, name: "Student Card", description: "Designed for students with low fees and flexible limits.", limit: "$2,000", rewards: "1% Cashback" },
            { id: 6, name: "Business Advantage", description: "Manage business expenses with advanced reporting and limits.", limit: "$20,000", rewards: "2% Cashback" },
        ]
    }
}
</script>

        <!-- Benefits Section -->
        <div class="-mt-13">
            <x-benefits-section
                banner="**Terms and conditions apply. See full cardholder agreement for details. Some offers may require credit approval."
                :benefitGroups="[
                    [
                        'title' => 'Rewards & Cashback',
                        'subtitle' => 'Maximize your spending power with flexible rewards options.',
                        'items' => [
                            'Earn 1.5% cashback on all purchases',
                            'Bonus rewards on select categories each quarter',
                            'Redeem points for travel, gift cards, or statement credits',
                        ],
                    ],
                    [
                        'title' => 'Security & Protection',
                        'subtitle' => 'Peace of mind with advanced security features.',
                        'items' => [
                            'Zero liability for unauthorized purchases',
                            'Fraud monitoring and alerts',
                            'Purchase protection on eligible items',
                            'Travel and emergency assistance',
                        ],
                    ],
                    [
                        'title' => 'Convenience',
                        'subtitle' => 'Manage your card easily anytime, anywhere.',
                        'items' => [
                            'Online account management',
                            'Mobile app access and alerts',
                            'Autopay setup to avoid missed payments',
                            'Digital wallet compatible',
                        ],
                    ],
                ]"
            />
        </div>

        <!-- CTA Banner -->
        <x-cta-banner 
            primaryLinkText="Apply for Credit Card" 
            primaryLinkUrl="{{ route('user.virtual.cards') }}" 
        />
    </div>
</x-layouts::front>
