<x-layouts::front :title="__('about || Nonprofit Banking', ['app' => config('app.name')])">
<div class="">
 <x-hero-static
    title="Banking for Nonprofits"
    description="Financial solutions designed to support your mission, strengthen your impact, and serve your community."
         badge="Non Profit"
    badgeIcon="beaker"
/>

<x-breadcrumbs config-key="nonprofit_banking" />

<x-image-top-service
  :grid-cols="3"
  description="We are committed to investing in nonprofit organizations that contribute to community wellbeing and are proud to offer deposit and loan products that cater to your needs. Our nonprofit clients inspire and energize us, making an impact through affordable housing, social justice, health and wellbeing, and environment sustainability.
  
  Join our community of nonprofits, B Corps, small businesses, and conscientious organizations with lending and deposit services that help you grow your impact.."
  :cards="[
    [
      'image' => 'images/nonprofit/Nonprofit-Banking-Checking-A-group-of-volunteers-wearing-vests-clean-up-trash-on-the-beach.webp',
      'title' => 'Nonprofit Savings Accounts',
      'description' => 'We offer a variety of accounts designed for a range of nonprofits, from small to large and new to established.',
      'buttonText' => 'Checking Account',
      'buttonLink' => route('nonprofit.checking')
    ],
    [
      'image' => 'images/nonprofit/Nonprofit-Banking-Savings-Two-people-plant-a-sapling-together.webp',
      'title' => 'Nonprofit Savings Accounts',
      'description' => 'Start saving money for your nonprofit and earn money on the money you save with dividends.',
      'buttonText' => 'Saving Account',
      'buttonLink' => route('nonprofit.savings')
    ],
    [
      'image' => 'images/nonprofit/Nonprofit-Banking-Lending-Exterior-of-Affordable-Housing-Building.webp',
      'title' => 'Nonprofit Lending',
      'description' => 'We offer several ways to help your organization meet its long-term goals. We tailor your financing to meet your nonprofit\'s needs.',
      'buttonText' => 'Learn more',
      'buttonLink' => route('nonprofit.lending')
    ],
  ]"
/>

<div class="-mt-20">
  <x-image-top-service
  :grid-cols="2"
    :fixedHeight="false" 
    :imgHeight="false"
    py="py-3 md:py-5"
  :cards="[
    [
      'image' => 'images/nonprofit/Nonprofit-Banking-CDARS-and-ICS-Profession-Women-and-Man-Look-at-Computer-Screen.webp',
      'title' => 'CDARS and ICS',
      'description' => 'A great solution for clients with over $250K in deposits. You can rest assured knowing that funds are eligible for FDIC insurance protection with IntraFi Network deposit products.',
      'buttonText' => 'Learn More',
      'buttonLink' => route('nonprofit.cdars')
    ],
    [
      'image' => 'images/nonprofit/Nonprofit-Banking-Treasury-Management-Man-with-Computer-Smiles.webp',
      'title' => 'Treasury Management',
      'description' => 'With our online banking tools, you can save time, improve your cash flow, and streamline your treasury management solutions, all in a fully secured environment.',
      'buttonText' => 'Learn More',
      'buttonLink' => route('personal.savings')
    ],
  ]"
/>
</div>
</div>
</x-layouts::front>