<x-layouts::front :title="config('app.name')">

    <div class="">
        @php
            $heroSlides = [
                [
                    'title' => config('app.name'),
                    'description' =>
                        'We do banking differently. We believe that people come first, and that everyone deserves a great experience every step of the way.',
                    'image' => 'images/home/metro.jpg',
                    'alt' => 'Modern banking experience',
                    'cta' => [
                        [
                            'text' => 'Open Account Today',
                            'href' => route('user.register'),
                            'type' => 'primary',
                            'icon' => 'sparkles',
                        ],
                        [
                            'text' => 'Login to Banking',
                            'href' => route('login'),
                            'type' => 'secondary',
                            'icon' => 'arrow-left-end-on-rectangle',
                        ],
                    ],
                ],
                [
                    'title' => 'Invest in Your Tomorrow',
                    'description' =>
                        'Our tailored investment and savings solutions help you grow your wealth with confidence and clarity.',
                    'image' => 'images/home/hero-kidsSaving.avif',
                    'alt' => 'Smart investment solutions',
                    'cta' => [
                        [
                            'text' => 'Start Investing Today',
                            'href' => route('user.deposit'),
                            'type' => 'primary',
                            'icon' => 'chart-bar',
                        ],
                    ],
                ],
                [
                    'title' => 'Banking Made Simple',
                    'description' =>
                        'Manage your money anytime, anywhere with our secure digital banking tools designed for your lifestyle.',
                    'image' => 'images/home/hero-wereOpen.avif',
                    'alt' => 'Easy digital banking',
                    'cta' => [
                        [
                            'text' => 'Learn More',
                            'href' => route('personal.overview'),
                            'type' => 'primary',
                            'icon' => 'book-open',
                        ],
                    ],
                ],
            ];
        @endphp


        <section class="relative w-full h-[60vh] md:h-[90vh] overflow-hidden bg-gray-900 dark:bg-gray-800">
            <div class="swiper heroSwiper h-full w-full">

                <div class="swiper-wrapper">
                    @foreach ($heroSlides as $slide)
                        <div class="swiper-slide opacity-0 relative h-full w-full flex items-center bg-cover bg-no-repeat bg-center"
                            style="background-image: url('{{ $slide['image'] }}');">

                            <!-- Overlay -->
                            <div class="absolute inset-0 bg-black/40 dark:bg-black/60"></div>

                            <!-- Left-aligned Content -->
                            <div class="relative z-10 max-w-2xl px-6 lg:px-16 py-12 flex flex-col justify-center h-full">

                                <!-- Title -->
                                <h1
                                    class="text-3xl sm:text-4xl slide-title md:text-5xl font-bold tracking-tight leading-tight text-white dark:text-gray-100">
                                    {{ $slide['title'] }}
                                </h1>

                                <!-- Description -->
                                @if (!empty($slide['description']))
                                    <p class="mt-4 text-lg text-white/90 slide-desc dark:text-gray-300 leading-relaxed">
                                        {{ $slide['description'] }}
                                    </p>
                                @endif

                                <!-- CTA Buttons -->
                                @if (!empty($slide['cta']))
                                    <div class="mt-6 flex flex-col sm:flex-row gap-4">
                                        @foreach ($slide['cta'] as $button)
                                            <a href="{{ $button['href'] }}"
                                                class="inline-flex items-center justify-center px-7 py-3 text-sm font-medium rounded-md transition duration-200 slide-button
                                              @if ($button['type'] === 'primary') bg-primary-600 text-white hover:bg-primary-700 dark:bg-primary-500 dark:text-white dark:hover:bg-primary-600
                                              @else
                                                  border border-white/50 text-white hover:bg-white/20 dark:border-gray-300 dark:text-gray-200 dark:hover:bg-gray-700/30 @endif">

                                                <!-- Optional Icon -->
                                                @if (!empty($button['icon']))
                                                    <x-dynamic-component :component="'flux::icon.' . $button['icon']"
                                                        class="w-5 h-5 flex-none mr-2" />
                                                @endif

                                                <span class="whitespace-nowrap">{{ $button['text'] }}</span>
                                            </a>
                                        @endforeach
                                    </div>
                                @endif

                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>

        <section class="relative -mt-16 z-30 font-sans bg-gray-50 dark:bg-gray-950">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">

                <div
                    class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 
                    rounded-xl shadow-sm overflow-hidden">

                    <!-- Accent Top Border -->
                    <div class="h-1 w-full bg-primary-600"></div>

                    <div class="grid grid-cols-1 md:grid-cols-3">

                        <!-- Routing Number -->
                        <div class="p-10 border-b md:border-b-0 md:border-r border-gray-200 dark:border-gray-800">
                            <div class="flex items-start gap-5">

                                <div
                                    class="w-14 h-14 flex items-center justify-center rounded-lg 
                                    bg-primary-50 dark:bg-primary-900/30 
                                    text-primary-600 dark:text-primary-400">
                                    <x-flux::icon.building-library variant="solid" class="w-4 h-4" />
                                </div>

                                <div>
                                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400 tracking-wide">
                                        ROUTING NUMBER
                                    </p>

                                    <!-- Stronger Visual Hierarchy -->
                                    <p
                                        class="text-2xl md:text-3xl font-semibold 
                                      tracking-tight text-gray-900 dark:text-white mt-2">
                                        {{ config('app.routing_number') }}
                                    </p>
                                </div>

                            </div>
                        </div>

                        <!-- Branch Hours -->
                        <div class="p-10 border-b md:border-b-0 md:border-r border-gray-200 dark:border-gray-800">
                            <div class="flex items-start gap-5">

                                <div
                                    class="w-14 h-14 flex items-center justify-center rounded-lg 
                                    bg-primary-50 dark:bg-primary-900/30 
                                    text-primary-600 dark:text-primary-400">
                                    <x-flux::icon.clock variant="solid" class="w-4 h-4" />
                                </div>

                                <div>
                                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400 tracking-wide">
                                        BRANCH HOURS
                                    </p>

                                    <p class="text-lg font-semibold text-gray-900 dark:text-white mt-2">
                                        Mon – Fri: 9AM – 5PM
                                    </p>

                                    <p class="text-sm text-gray-600 dark:text-gray-400">
                                        Saturday: 9AM – 1PM
                                    </p>
                                </div>

                            </div>
                        </div>

                        <!-- 24/7 Support -->
                        <div class="p-10">
                            <div class="flex items-start gap-5">

                                <div
                                    class="w-14 h-14 flex items-center justify-center rounded-lg 
                                    bg-primary-50 dark:bg-primary-900/30 
                                    text-primary-600 dark:text-primary-400">
                                    <x-flux::icon.chat-bubble-oval-left-ellipsis variant="solid" class="w-4 h-4" />
                                </div>

                                <div>
                                    <p class="text-sm font-medium text-gray-500 dark:text-gray-400 tracking-wide">
                                        24/7 SUPPORT
                                    </p>

                                    <p class="text-lg font-semibold text-gray-900 dark:text-white mt-2">
                                        +1 (800) 555-1234
                                    </p>

                                    <p class="text-sm text-gray-600 dark:text-gray-400">
                                        Always here to assist you
                                    </p>
                                </div>

                            </div>
                        </div>

                    </div>
                </div>

            </div>
        </section>
        <div class="-mt-30">
            <x-rates-section ptTop="md:pt-40" :rates="[
                [
                    'label' => 'HIGH YIELD SAVINGS',
                    'value' => '3.75%',
                    'type' => 'APY*',
                    'icon' => 'hand-coins',
                ],
                [
                    'label' => '18 MONTH CERTIFICATE',
                    'value' => '3.65%',
                    'type' => 'APY*',
                    'icon' => 'shield-check',
                ],
                [
                    'label' => 'CREDIT CARDS',
                    'value' => '4.00%',
                    'type' => 'APR*',
                    'icon' => 'credit-card',
                ],
                [
                    'label' => 'LOANS',
                    'value' => '15.49%',
                    'type' => 'APR*',
                    'icon' => 'hand-coins',
                ],
            ]" />
        </div>

        <div class="">
            <x-image-top-service :grid-cols="3" py="py-0 md:py-0" :cards="[
                [
                    'image' => 'images/home/2022-07-27-Homepage-Three-Up-Personal.webp',
                    'title' => 'Be a Financial Activist',
                    'description' =>
                        'Bank where your values are. Open a free checking account, build interest on your savings, finance a car loan, or apply for an environmentally responsible credit card..',
                    'buttonText' => 'Personal Banking',
                    'buttonLink' => route('personal.overview'),
                ],
                [
                    'image' => 'images/home/2022-07-27-Homepage-Three-Up-Business.webp',
                    'title' => 'Build Your Business',
                    'description' =>
                        'Join our community of B Corps, small businesses, and other do-no-harm enterprises with lending and deposits to help you grow..',
                    'buttonText' => 'Commercial Banking',
                    'buttonLink' => route('business.overview'),
                ],
                [
                    'image' => 'images/home/2022-07-27-Homepage-Three-Up-Nonprofit.webp',
                    'title' => 'Strengthen the Community',
                    'description' =>
                        'Whether you’re a small group of volunteers or an international powerhouse, we’ve got a host of specially-tailored offerings for our 501(c)(3) clients..',
                    'buttonText' => 'Nonprofit Banking',
                    'buttonLink' => route('nonprofit.overview'),
                ],
            ]" />

        </div>

        <x-feature-section title="Open Your Account with Confidence"
            description="Start your financial journey with a trusted partner. Secure accounts, dedicated support, and convenient services designed for your everyday banking needs."
            image="images/home/feature.jpg" imageAlt="Family managing finances at the bank" imagePosition="right"
            buttonText="Open Account Now" buttonLink="{{ route('user.register') }}" badgeText="$200 Welcome Bonus"
            :benefits="[
                'No minimum balance required',
                'Free online and mobile banking',
                '24/7 dedicated customer support',
            ]" />

        <x-feature-section title="Plan and Grow Your Wealth"
            description="Take control of your financial future with personalized savings and investment solutions. Trusted guidance, tailored to help you achieve your goals securely and efficiently."
            image="images/home/header-coworkersComputer.jpg" imageAlt="Professional reviewing savings and investments"
            imagePosition="left" buttonText="Learn More" buttonLink={{ route('personal.savings') }}
            badgeText="Trusted Investment Guidance" :benefits="['Customizable savings plans', 'Personalized investment advice', 'Secure, monitored accounts']" />

        <x-services-section title="Banking Services Made Simple"
            description="Experience seamless banking with our range of secure and innovative financial services."
            :smCols="2" :lgCols="3" :cards="[
                [
                    'icon' => 'document-check',
                    'title' => 'Open an Account',
                    'description' => 'Start your journey with us in minutes, fully online and secure.',
                    'link' => route('user.register'),
                    'iconBg' => 'bg-amber-50 dark:bg-amber-900/30',
                    'iconColor' => 'text-amber-600 dark:text-amber-400',
                ],
                [
                    'icon' => 'credit-card',
                    'title' => 'Get a Card',
                    'description' => 'Access fast, secure transactions worldwide with our premium cards.',
                    'link' => route('personal.credit-cards'),
                    'iconBg' => 'bg-blue-50 dark:bg-blue-900/30',
                    'iconColor' => 'text-blue-600 dark:text-blue-400',
                ],
                [
                    'icon' => 'chart-bar',
                    'title' => 'Track Spending',
                    'description' => 'Monitor your spending in real-time with smart insights and alerts.',
                    'link' => route('login'),
                    'iconBg' => 'bg-green-50 dark:bg-green-900/30',
                    'iconColor' => 'text-green-600 dark:text-green-400',
                ],
                [
                    'icon' => 'shield-check',
                    'title' => 'Secure Banking',
                    'description' => 'Your security is our top priority with advanced protection features.',
                    'link' => route('login'),
                    'iconBg' => 'bg-purple-50 dark:bg-purple-900/30',
                    'iconColor' => 'text-purple-600 dark:text-purple-400',
                ],
                [
                    'icon' => 'currency-dollar',
                    'title' => 'Instant Transfers',
                    'description' => 'Send and receive money instantly with zero hassle and full security.',
                    'link' => route('user.local.transfer'),
                    'iconBg' => 'bg-indigo-50 dark:bg-indigo-900/30',
                    'iconColor' => 'text-indigo-600 dark:text-indigo-400',
                ],
                [
                    'icon' => 'chart-pie',
                    'title' => 'Investment Insights',
                    'description' => 'Grow your wealth with personalized insights and portfolio recommendations.',
                    'link' => route('user.dashboard'),
                    'iconBg' => 'bg-pink-50 dark:bg-pink-900/30',
                    'iconColor' => 'text-pink-600 dark:text-pink-400',
                ],
            ]" />
        <x-feature-grid-section title="Building Financial Strength Together"
            description="Nova Chase Bank is a full-service bank built on a foundation of trust and personalized service. We help our members achieve their financial goals through guidance, stability, and competitive rates."
            badgeText="Member-Focused Banking" buttonText="Learn More" buttonLink="{{ route('about.contact') }}"
            imagePosition="right" :benefits="[
                [
                    'icon' => 'chart-bar',
                    'title' => 'Competitive Rates',
                    'description' =>
                        'Better rates on savings, loans, and credit cards designed to maximize your financial growth.',
                ],
                [
                    'icon' => 'users',
                    'title' => 'Member-Focused',
                    'description' => 'We are owned by our members, not shareholders. Your success is our priority.',
                ],
                [
                    'icon' => 'heart',
                    'title' => 'Community Committed',
                    'description' => 'Supporting local communities and initiatives that matter to our members.',
                ],
            ]" :imageGrid="[
                ['src' => 'images/home/feature1.jpg', 'alt' => 'Team collaboration'],
                ['src' => 'images/home/feature2.jpg', 'alt' => 'Bank consultant meeting'],
                ['src' => 'images/home/feature3.jpg', 'alt' => 'Modern banking technology'],
                ['src' => 'images/home/header-womanLaptop.jpg', 'alt' => 'Community support in banking'],
            ]" />

        @include('partials.testimonial')
        <!-- Enhanced Footer -->

    </div>
</x-layouts::front>
