<x-layouts::front :title="__('Grants', ['app' => config('app.name')])">

<div class="">
  
<x-hero-static
    title="Grants & Financial Aid"
    description="Supporting your dreams with accessible funding opportunities and financial assistance programs"
        badge="Financial Assistance"
    badgeIcon="hand-coins"
/>

<!-- Available Grants Section -->
<section class="py-16 bg-white dark:bg-gray-900">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                Available Grant Programs
            </h2>
            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Explore our comprehensive grant programs designed to support various financial needs
            </p>
        </div>

        <div class="grid md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Small Business Grant -->
            <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-blue-100 dark:bg-blue-900/30 rounded-2xl flex items-center justify-center mb-6">
                    <x-flux::icon.building-storefront variant="solid" class="text-blue-600 dark:text-blue-400 w-8 h-8" />
                    
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Small Business Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Up to $50,000 in funding for small business startups and expansion projects.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>No collateral required</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Flexible repayment terms</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Business mentorship included</li>
                </ul>
                <a href="{{ route('user.grants.index') }}"  class="inline-flex items-center text-blue-600 dark:text-blue-400 font-semibold hover:text-blue-700 dark:hover:text-blue-300 transition-colors">
                    Apply Now<x-flux::icon.arrow-right variant="solid" class="ml-2 w-4 h-4" />

                </a>
            </div>

            <!-- Education Grant -->
            <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-purple-100 dark:bg-purple-900/30 rounded-2xl flex items-center justify-center mb-6">
                   <x-flux::icon.academic-cap variant="solid" class="w-8 h-8 text-purple-600 dark:text-purple-400" />
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Education Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Financial assistance for higher education, vocational training, and skill development.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to $25,000 per year</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Merit-based selection</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Career guidance support</li>
                </ul>
                <a href="{{ route('user.grants.index') }}"  class="inline-flex items-center text-purple-600 dark:text-purple-400 font-semibold hover:text-purple-700 dark:hover:text-purple-300 transition-colors">
                    Apply Now <x-flux::icon.arrow-right variant="solid" class="ml-2 w-4 h-4" />
                </a>
            </div>

            <!-- Home Ownership Grant -->
            <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-green-100 dark:bg-green-900/30 rounded-2xl flex items-center justify-center mb-6">
            <x-flux::icon.home variant="solid" class="w-8 h-8 text-green-600 dark:text-green-400" />
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Home Ownership Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Down payment assistance and closing cost support for first-time homebuyers.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to $15,000 assistance</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>First-time buyer priority</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Homebuyer education</li>
                </ul>
                <a href="{{ route('user.grants.index') }}"  class="inline-flex items-center text-green-600 dark:text-green-400 font-semibold hover:text-green-700 dark:hover:text-green-300 transition-colors">
                    Apply Now <x-flux::icon.arrow-right variant="solid" class="ml-2 w-4 h-4" />
                </a>
            </div>

            <!-- Emergency Relief Grant -->
            <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-red-100 dark:bg-red-900/30 rounded-2xl flex items-center justify-center mb-6">
            <x-flux::icon.heart variant="solid" class="w-8 h-8 text-red-600 dark:text-red-400" />

                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Emergency Relief Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Immediate financial assistance for unexpected emergencies and hardships.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Quick approval process</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to $10,000 immediate</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>24/7 application support</li>
                </ul>
                <a href="{{ route('user.grants.index') }}"  class="inline-flex items-center text-red-600 dark:text-red-400 font-semibold hover:text-red-700 dark:hover:text-red-300 transition-colors">
                    Apply Now <x-flux::icon.arrow-right variant="solid" class="ml-2 w-4 h-4" />
                </a>
            </div>

            <!-- Community Development Grant -->
            <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-orange-100 dark:bg-orange-900/30 rounded-2xl flex items-center justify-center mb-6">
            <x-flux::icon.user-group variant="solid" class="w-8 h-8 text-orange-600 dark:text-orange-400" />
                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Community Development</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Support for community projects, non-profits, and local development initiatives.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Up to $100,000 funding</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Community impact focus</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Ongoing project support</li>
                </ul>
                <a href="{{ route('user.grants.index') }}"  class="inline-flex items-center text-orange-600 dark:text-orange-400 font-semibold hover:text-orange-700 dark:hover:text-orange-300 transition-colors">
                    Apply Now <x-flux::icon.arrow-right variant="solid" class="ml-2 w-4 h-4" />
                </a>
            </div>

            <!-- Healthcare Grant -->
            <div class="bg-white dark:bg-gray-800 rounded-2xl p-8 shadow-xl border border-gray-200 dark:border-gray-700 hover:shadow-2xl transition-all duration-300">
                <div class="w-16 h-16 bg-teal-100 dark:bg-teal-900/30 rounded-2xl flex items-center justify-center mb-6">
                                <x-flux::icon.cursor-arrow-rays variant="solid" class="w-8 h-8 text-teal-600 dark:text-teal-400" />

                </div>
                <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-3">Healthcare Grant</h3>
                <p class="text-gray-600 dark:text-gray-300 mb-4">
                    Medical expense assistance and healthcare accessibility support programs.
                </p>
                <ul class="space-y-2 text-sm text-gray-600 dark:text-gray-300 mb-6">
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Medical bill assistance</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Prescription drug support</li>
                    <li class="flex items-center"><i class="fa-solid fa-check text-green-500 mr-2"></i>Health insurance help</li>
                </ul>
                <a href="{{ route('user.grants.index') }}" class="inline-flex items-center text-teal-600 dark:text-teal-400 font-semibold hover:text-teal-700 dark:hover:text-teal-300 transition-colors">
                    Apply Now <x-flux::icon.arrow-right variant="solid" class="ml-2 w-4 h-4" />
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Application Process Section -->
<section id="apply" class="py-16 bg-gray-50 dark:bg-gray-800">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-12">
            <h2 class="text-3xl lg:text-4xl font-bold text-gray-900 dark:text-white mb-4">
                How to Apply
            </h2>
            <p class="text-lg text-gray-600 dark:text-gray-300 max-w-2xl mx-auto">
                Simple steps to get the financial assistance you need
            </p>
        </div>

        <div class="grid md:grid-cols-4 gap-8">
            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 dark:bg-primary-900/30 rounded-full flex items-center justify-center mx-auto mb-4">
                    <span class="text-2xl font-bold text-primary-600 dark:text-primary-400">1</span>
                </div>
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Choose Program</h3>
                <p class="text-gray-600 dark:text-gray-300">Select the grant program that best fits your needs</p>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 dark:bg-primary-900/30 rounded-full flex items-center justify-center mx-auto mb-4">
                    <span class="text-2xl font-bold text-primary-600 dark:text-primary-400">2</span>
                </div>
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Submit Application</h3>
                <p class="text-gray-600 dark:text-gray-300">Complete our online application with required documents</p>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 dark:bg-primary-900/30 rounded-full flex items-center justify-center mx-auto mb-4">
                    <span class="text-2xl font-bold text-primary-600 dark:text-primary-400">3</span>
                </div>
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Review Process</h3>
                <p class="text-gray-600 dark:text-gray-300">Our team reviews your application within 5-7 business days</p>
            </div>

            <div class="text-center">
                <div class="w-16 h-16 bg-primary-100 dark:bg-primary-900/30 rounded-full flex items-center justify-center mx-auto mb-4">
                    <span class="text-2xl font-bold text-primary-600 dark:text-primary-400">4</span>
                </div>
                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">Receive Funding</h3>
                <p class="text-gray-600 dark:text-gray-300">Approved grants are disbursed directly to your account</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-16 bg-primary-600 dark:bg-primary-700">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl lg:text-4xl font-bold text-white mb-4">
            Ready to Apply for a Grant?
        </h2>
        <p class="text-xl text-primary-100 mb-8">
            Take the first step towards achieving your financial goals with our grant programs
        </p>
              <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="{{ route('user.register') }}" class="inline-flex items-center px-8 py-4 bg-primary-600 hover:bg-primary-700 text-white font-bold rounded-2xl transition-all duration-300 shadow-lg hover:shadow-xl hover:-translate-y-1">
                 <x-flux::icon.user-plus variant="solid" class="w-5 h-5 mr-3" />
                Open an Account
            </a>
            <a href="{{ route('about.contact') }}" class="inline-flex items-center px-8 py-4 bg-gray-100 dark:bg-gray-800 hover:bg-gray-200 dark:hover:bg-gray-700 text-gray-900 dark:text-white font-semibold rounded-2xl transition-all duration-300">
                <x-flux::icon.phone variant="solid" class="w-5 h-5 mr-3" />
                Contact Us
            </a>
        </div>
    </div>
</section>
</div>
</x-layouts::front>