<x-layouts::front :title="__('about || Business Banking', ['app' => config('app.name')])">
<div class="">
 <x-hero-static
    title="Business Banking Solutions"
    description="Smart financial tools designed to help your business grow, manage cash flow, and operate with confidence."
       badge="For Business's"
    badgeIcon="briefcase"
/>

<x-breadcrumbs config-key="business_banking" />

<x-image-top-service
  :grid-cols="3"
  :cards="[
    [
      'image' => 'images/business/Business-Banking-Checking-Woman-Small-Business-Owner-with-Computer.webp',
      'title' => 'Business Checking Accounts',
      'description' => 'We offer a variety of accounts designed for a range of businesses, whether you\'re well-established or just starting up.',
      'buttonText' => 'Checking Account',
      'buttonLink' => route('business.checking')
    ],
    [
      'image' => 'images/business/Business-Banking-Savings-Man-and-Woman-Business-Owners.webp',
      'title' => 'Business Savings Accounts',
      'description' => 'Start saving money for your business and earn money on the money you save with dividends.',
      'buttonText' => 'Saving Account',
      'buttonLink' => route('business.savings')
    ],
    [
      'image' => 'images/business/Business-Banking-Lending-Exterior-of-Affordable-Housing-Building.webp',
      'title' => 'Business Lending',
      'description' => 'We offer several ways to help your company meet its long-term goals. We tailor your financing to meet your business needs.',
      'buttonText' => 'Loan Account',
      'buttonLink' => route('business.lending')
    ],
  ]"
/>

<div class="py-8 max-w-6xl mx-auto space-y-4">
      <h2 class="text-sm md:text-base text-primary-700 font-semibold uppercase">Building a Better World</h2>
      <p class="text-gray-700 dark:text-gray-100 text-sm leading-normal">
            Depositors aren't just another line item at {{ config('app.name') }}. We value what our accountholders bring to the table—the opportunity for our organization to "crowdfund" and engage in lending practices that build toward a more inclusive, environmentally regenerative, racial- and gender-just world. That's our vision. <a href="{{ route('about.vision') }}" class="font-medium text-primary-700">Learn More</a>.
      </p>
</div>
    <x-cta-banner 
            primaryLinkText="Open an account" 
            primaryLinkUrl="{{ route('user.register') }}" 
        />

</div>
</x-layouts::front>