<x-layouts::front :title="__('about || Business Checking Account', ['app' => config('app.name')])">
<div class="">
<x-hero-static
    title="Business Lending"
    description="Flexible financing solutions to support expansion, equipment purchases, and working capital needs."
      badge="For Business's"
    badgeIcon="briefcase"
/>
<x-breadcrumbs config-key="business_banking" />
<div class="-mt-5">
      <x-account-card
    title="Lending With Purpose"
    :features="[
        'description' => 'Our lending solutions to both for-profit and nonprofit entities not only offer strong terms for you, but also for the local community. At least 75% of our issued loans apply to mission categories, including environmental and community services, nonprofits, alternative ownership structures, and affordable housing. The remainder of our loans are reviewed to help ensure that we do not finance endeavors that are contra-mission. Our lending areas are primarily in the counties with branch and office locations, along with their contiguous counties.
        
        Our bankers are experts in commercial, small business, nonprofit, and SBA lending. Whether you\'re maintaining or growing a business, our team of experts is here to assist you with your financial goals.',
    ]"
    ctaLink=""
    ctaText="Connect With Us"
/>
</div>


@php
$cards = [
    [
        'title' => 'Real Estate Loans',
        'description' => "We offer tailored financing for many types of commercial properties, for both for-profit and nonprofit clients. Our commercial real estate products include.",
        'list' => [
            "Construction/renovation, acquisition, and refinance of Affordable Housing Multifamily properties",
            "Construction/renovation, acquisition, and refinance of owner-occupied properties",
            "Acquisition and refinance for multifamily properties",
            "Other forms of interim and long-term commercial real estate financing"
        ],
        'image' => '/images/lending/pexels-andrea-piacquadio-3762927.webp',
        'buttonText' => 'Apply Now',
        'buttonLink' => route('user.loans.request'),
    ],
     [
        'title' => 'Commercial and Nonprofit Loans',
        'description' => "We offer lines of credit and term loans to help your organization meet its goals. Our loans may be used to finance:.",
        'list' => [
            "Working capital for A/R and Inventory",
            "Equipment and other capital expenditures",
            "Tenant improvements",
            "Business expansion",
            "Business expansion",
            "Construction and term loans for renewable energy (primarily solar photovoltaic: ground mount and rooftop)",
            "Other long-term projects"
        ],
        'image' => '/images/lending/pexels-monica-silvestre-4249477-2.webp',
        'buttonText' => 'Apply Now',
        'buttonLink' => route('user.loans.request'),
    ],
      [
        'title' => 'Business and Nonprofit Builder Loans',
        'description' => "This loan type is for clients looking to borrow $10,000 to $150,000. These loans are available for working capital or multiple advances or term loans for asset purchases or tenant improvements..",
        'list' => [
            "Term loans",
            "Revolving lines of credit",
            "Purchases or tenant improvements"
        ],
        'image' => '/images/lending/pexels-anastasia-shuraeva-4079281.webp',
        'buttonText' => 'Apply Now',
        'buttonLink' => route('user.loans.request'),
    ],
      [
        'title' => 'Small Business and SBA Loans',
        'description' => "We offer financing solutions in partnership with the Small Business Administration (SBA), the United States Department of Agriculture (USDA), and our West Coast states. These programs can help your small business grow with favorable and flexible terms and competitive loan rates.",
        'list' => [
            "SBA 7(a) loans for equipment, tenant improvements, owner-occupied real estate, and business acquisition",
            "SBA 504 loans for owner-occupied real estate and equipment purchase",
            "SBA Express: Coming soon!",
            "USDA Business & Industry and other state programs!"
        ],
        'image' => '/images/lending/pexels-polina-tankilevitch-3738387.webp',
        'buttonText' => 'Apply Now',
        'buttonLink' => route('user.loans.request'),
    ],
];
@endphp

<div class="-mt-20">
      <x-image-top-service :cards="$cards" 
    :gridCols="2" 
    title="Our Credit Cards" 
    :fixedHeight="false"  />
</div>
</div>

<x-cta-banner 
    primaryLinkText="Open Savings Account" 
    primaryLinkUrl="{{ route('user.register') }}" 
/>
</x-layouts::front>
