<x-layouts::front :title="__('about || Business Checking Account', ['app' => config('app.name')])">
<div class="">
<x-hero-static
    title="Business Checking"
    description="Flexible checking accounts built to support your daily operations and simplify cash flow management."
    badge="For Business's"
    badgeIcon="briefcase"
/>

<x-breadcrumbs config-key="business_banking" />
<x-account-card
    title="PositiveChange Business Accounts"
    :features="[
        'description' => 'Your deposits matter. They allow us to empower changemakers who are working toward meaningful social justice outcomes and environmental sustainability. Your deposits can create positive change in our communities..',
    ]"
/>
<div class="-mt-22">
      <x-benefits-section :grid-cols="2" 
    :benefitGroups="[
        [
            'title' => 'Small Business Checking',
            'subtitle' => 'Perfect account for low-volume businesses.',
            'items' => [
                'Minimum opening balance: $100',
            'Service charge: $0',
            '150 free transactions/month; then $0.25/each',
            'eStatements required'
            ],
        ],
        [
            'title' => 'Business Checking',
            'subtitle' => 'Great for established businesses with low- to medium-volume.',
            'items' => [
                'Minimum opening balance: $100',
                       [
        'text' => 'Service charge: $15/month, waived if:',
        'subitems' => [
            '$3,000/month average balance for this account',
            '$10,000/month average balance combined across accounts under the same business tax owner',
        ],
    ],
      '250 free transactions/month; then $0.25/each',
            ],
        ],
        [
            'title' => 'Certificate of Deposit (CD) Accounts',
            'subtitle' => 'Earn interest on your deposit for a fixed time period.',
            'items' => [
                'Minimum opening balance: $250',
                'Service charge: $0',
                'Terms of 3 to 60 months; early withdrawal penalty may apply.',
                'Paid interest may be withdrawn without penalty or rolled over at maturity into the principal balance. Assessment of penalties can reduce principal and earnings.',
                'Interest: Compounded daily, credited monthly by adding back to the CD.'
            ],
            
        ],
          [
            'title' => 'Individual Retirement Accounts (IRAs)',
            'subtitle' => 'A tax-advantaged long-term savings account to help you save for retirement.',
            'items' => [
                'Minimum opening balance: $250',
                'Service charge: N/A',
                'Terms of 3 to 60 months; early withdrawal penalty may apply',
                'Bank and IRS penalties may be imposed for early withdrawal. Assessment of penalties can reduce principal and earnings.',
                'Interest: Compounded daily. Paid quarterly.'
            ],
            
        ],
    ]"
/>
</div>
<div class="-mt-22">
      <x-benefits-section :grid-cols="3" 
      banner="*$2.50 transaction fee for withdrawals at foreign ATMs (other banks may charge a fee). Any ATM not in the {{ config('app.name') }} ATM network is a non-network ATM.
      
      **Additional fees may apply. Please see Schedule of Fees and Charges."
    :benefitGroups="[
        [
            'title' => 'Business Interest Checking',
            'subtitle' => 'An interest-bearing account for businesses.',
            'items' => [
                'Minimum opening balance: $100',
                          [
        'text' => 'Service charge: $17/month, waived if:',
        'subitems' => [
            '$5,000/month average balance for this account',
            '$15,000/month average balance combined across accounts under the same business tax owner',
        ],
    ],
            ],
        ],
        [
            'title' => 'Changemaker Business Interest Checking',
            'subtitle' => 'An interest-bearing account for qualified changemakers, such as nonprofits, certified B Corps, CDFIs, and more.',
            'items' => [
                'Minimum opening balance: $100',
      'Service charge: $0',
      'eStatements required',
            ],
        ],
        [
            'title' => 'Analyzed Business Checking',
            'subtitle' => 'Ideal for high-activity with enhanced services to accommodate your growing organization.',
            'items' => [
                'Minimum opening balance: $100',
                'Service charge: $15/month',
                'Schedule of Fees and Services',
            ],
            
        ],
    ]"
/>
</div>

<div class="-mt-20">
      <x-account-card
    title="The following account services are available:**"
    :features="[
        'list' => [
            'Debit Card*',
            'eStatements',
            'Online and Mobile Banking',
            'Mobile and Merchant Check Deposit',
            'Merchant Card Services',
            'Wholesale Lockbox',
            'Cash Services',
            'Bill Pay',
            'Fraud Tools: ACH Filters and Positive Pay',
            'ACH and Wires',
            'Sweeps',
        ]
    ]"
    ctaText="Contact Our Support"
    ctaLink="{{ route('user.register') }}"
/>
</div>

<x-cta-banner 
    primaryLinkText="Open Checking Account" 
    primaryLinkUrl="{{ route('user.register') }}" 
/>
</div>
</x-layouts::front>
