@props([
    'paymentMethods', // Collection of methods
    'title' => 'Choose a Transfer Method', // Default heading
])

<div x-data="{ showAll: false }" x-cloak x-show="$wire.selectedMethod === null"
    x-transition:enter="transition ease-out duration-300" x-transition:enter-start="opacity-0 translate-y-3"
    x-transition:enter-end="opacity-100 translate-y-0" x-transition:leave="transition ease-in duration-200"
    x-transition:leave-start="opacity-100 translate-y-0" x-transition:leave-end="opacity-0 translate-y-3"
    class="space-y-4">

    {{-- Title --}}
    <h2 class="text-lg font-bold text-gray-900 dark:text-white mb-3">
        {{ $title }}
    </h2>

    {{-- Main grid: always show first 2 methods --}}
    <ul class="grid grid-cols-1 md:grid-cols-2 w-full gap-2">
        @foreach ($paymentMethods as $index => $method)
            @if ($index < 6)
                <li class="flex flex-col w-full">
                    <button type="button" wire:click="selectMethod({{ $method->id }})" wire:loading.attr="disabled"
                        wire:target="selectMethod({{ $method->id }})" class="relative cursor-pointer w-full">
                        <x-payment-method-card :method="$method" :clickable="true" />

                        {{-- Loading overlay --}}
                        <div wire:loading wire:target="selectMethod({{ $method->id }})"
                            class="absolute inset-0 bg-white/50 dark:bg-gray-800/50 flex items-center justify-center rounded-xl">
                            <svg class="animate-spin h-5 w-5 text-sky-500" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 24 24">
                                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                                    stroke-width="4"></circle>
                                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8H4z"></path>
                            </svg>
                        </div>
                    </button>
                </li>
            @endif
        @endforeach
    </ul>

    {{-- Extra methods: collapsible grid --}}
    @if ($paymentMethods->count() > 6)
        <div x-show="showAll" x-collapse class="grid grid-cols-1 md:grid-cols-2 w-full gap-2 mt-2">
            @foreach ($paymentMethods as $index => $method)
                @if ($index >= 6)
                    <div class="flex flex-col w-full">
                        <button type="button" wire:click="selectMethod({{ $method->id }})"
                            class="cursor-pointer w-full">
                            <x-payment-method-card :method="$method" :clickable="true" />
                        </button>
                    </div>
                @endif
            @endforeach
        </div>

        @php
            $hiddenMethods = $paymentMethods->slice(6);
            $hiddenCount = $hiddenMethods->count();
            $firstHiddenName = $hiddenMethods->first()?->name ?? '';
        @endphp

        {{-- Show more / Show less button --}}
        <div class="mt-2" x-data>
            <button type="button" @click="showAll = !showAll" class="w-full">
                <div :class="showAll ? 'bg-sky-50 dark:bg-sky-950 border-sky-400' :
                    'bg-white dark:bg-gray-900 border-dashed border-gray-300 dark:border-gray-700'"
                    class="group flex items-center gap-4 rounded-2xl border px-6 py-5 transition shadow-sm hover:shadow-md hover:border-sky-400">

                    <div class="flex h-12 w-12 items-center justify-center rounded-xl bg-gray-100 dark:bg-gray-800">
                        <svg x-show="!showAll" class="w-6 h-6 text-sky-500" fill="none" stroke="currentColor"
                            stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 4v16m8-8H4" />
                        </svg>
                        <svg x-show="showAll" class="w-6 h-6 text-sky-600" fill="none" stroke="currentColor"
                            stroke-width="2" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M20 12H4" />
                        </svg>
                    </div>

                    <div class="flex-1 text-left">
                        <p class="font-medium text-gray-900 dark:text-gray-100"
                            x-text="showAll ? 'Show fewer methods' : 'Show {{ $hiddenCount }} more methods'">
                        </p>
                        <p class="text-xs text-gray-500 truncate max-w-[320px]"
                            x-text="showAll ? 'Collapse list' : '{{ $firstHiddenName }}'"></p>
                    </div>

                    <span
                        :class="showAll ? 'bg-sky-600 text-white' :
                            'bg-gray-100 dark:bg-gray-800 text-gray-500 group-hover:bg-sky-600 group-hover:text-white'"
                        class="text-xs px-3 py-1 rounded-full transition"
                        x-text="showAll ? 'Less' : '+{{ $hiddenCount }}'"></span>
                </div>
            </button>
        </div>
    @endif
</div>
