    @php
    $testimonials = [
        [
            'image' => 'images/Quote.webp',
            'quote' => config('app.name') . ' made opening a business account seamless. Their support team guided us through every step, making the process quick and stress-free.',
            'name' => 'Jessica Joyner',
            'role' => 'Founder, Horizon Consulting',
        ],
        [
            'image' => 'images/Quote.webp',
            'quote' => 'I was impressed by ' . config('app.name') . '\'s digital banking platform — intuitive, secure, and fast. Managing multiple accounts has never been easier.',
            'name' => 'Michael Trent',
            'role' => 'Entrepreneur, Acme Solutions',
        ],
        [
            'image' => 'images/Quote.webp',
            'quote' => 'Applying for our mortgage through ' . config('app.name') . ' was a breeze. The team provided clear guidance and helped us get the best rates.',
            'name' => 'Sara Malik',
            'role' => 'Homeowner, FinTrust Estates',
        ],
        [
            'image' => 'images/Quote.webp',
            'quote' => config('app.name') . ' has been instrumental in helping us manage corporate finances efficiently. Their advisors are knowledgeable and always accessible.',
            'name' => 'Brandon Lee',
            'role' => 'CFO, InvestEdge Capital',
        ],
        [
            'image' => 'images/Quote.webp',
            'quote' => 'Thanks to ' . config('app.name') . ', we were able to streamline our international transfers. Their low fees and fast processing save us both time and money.',
            'name' => 'Amanda Costa',
            'role' => 'Operations Manager, Credible Enterprises',
        ],
        [
            'image' => 'images/Quote.webp',
            'quote' => 'The customer service at ' . config('app.name') . ' is exceptional. They helped me resolve a complicated account issue quickly and professionally.',
            'name' => 'Liam Parker',
            'role' => 'Software Engineer, CapitalWise Tech',
        ],
        // New Banking Testimonials
        [
            'image' => 'images/Quote.webp',
            'quote' => 'I rely on ' . config('app.name') . ' for all my personal banking needs. Their mobile app is intuitive, and I can manage my savings and checking effortlessly.',
            'name' => 'Olivia Chen',
            'role' => 'Freelancer, Creative Solutions',
        ],
        [
            'image' => 'images/Quote.webp',
            'quote' => config('app.name') . ' helped us secure a small business loan with favorable terms. Their guidance made a complex process simple and transparent.',
            'name' => 'Rajesh Kapoor',
            'role' => 'Owner, Global Finance Corp',
        ],
        [
            'image' => 'images/Quote.webp',
            'quote' => 'Switching to ' . config('app.name') . ' for our family banking was the best decision. Their savings programs and personalized advice really help us plan for the future.',
            'name' => 'Emily Foster',
            'role' => 'Teacher, SecureBank Community',
        ],
    ];
    @endphp


<section class="relative w-full bg-cover bg-center py-12 text-white"
         style="background-image: url('{{ asset('images/home/feature4.jpg') }}');">

  <!-- Overlay for better contrast -->
  <div class="absolute inset-0 bg-black/30 dark:bg-black/50"></div>

  <!-- Full-width flex container to push slider to right -->
  <div class="relative flex justify-end w-full px-6 md:px-16 fade-in-up">
    
    <!-- Testimonial Card -->
    <div class="w-full max-w-lg bg-white dark:bg-gray-900 shadow-lg dark:shadow-xl rounded-xl p-8">
      
      <div class="swiper testimonial-swiper">
        <div class="swiper-wrapper">
          @foreach ($testimonials as $testimonial)
          <div class="swiper-slide">
            <div class="flex flex-col items-start gap-4">
              
              <!-- Author Image -->
              <img src="{{ asset($testimonial['image']) }}" alt="{{ $testimonial['name'] }}"
                   class="w-16 h-16 object-cover rounded-full border-2 border-gray-200 dark:border-gray-700" />

              <!-- Quote -->
              <div class="border-l-4 border-sky-600 pl-4 text-gray-800 dark:text-gray-100 text-base font-medium leading-relaxed">
                “{{ $testimonial['quote'] }}”
              </div>

              <!-- Author Info -->
              <div class="pt-2">
                <h3 class="font-semibold text-gray-900 dark:text-white text-sm">{{ $testimonial['name'] }}</h3>
                <p class="text-gray-600 dark:text-gray-400 text-xs">{{ $testimonial['role'] }}</p>
              </div>

            </div>
          </div>
          @endforeach
        </div>

        <!-- Navigation Buttons -->
        <div class="mt-6 flex gap-4">
          <div class="testimonial-prev w-10 h-10 rounded-full bg-sky-600 hover:bg-sky-700 text-white dark:bg-sky-500 dark:hover:bg-sky-600 flex items-center justify-center transition duration-300 shadow-md">
            <x-flux::icon.arrow-right class="w-5 h-5 rotate-180" />
          </div>
          <div class="testimonial-next w-10 h-10 rounded-full bg-sky-600 hover:bg-sky-700 text-white dark:bg-sky-500 dark:hover:bg-sky-600 flex items-center justify-center transition duration-300 shadow-md">
            <x-flux::icon.arrow-right class="w-5 h-5" />
          </div>
        </div>
      </div>

    </div>
  </div>
</section>




      