<div
    class="bg-white/90 dark:bg-gray-800/90 backdrop-blur-md rounded-2xl shadow-lg dark:shadow-gray-900/50 overflow-hidden border border-white/20 dark:border-gray-700/50">

    {{-- Header --}}
    <div class="px-5 py-3 border-b border-gray-200 dark:border-gray-700 flex items-center justify-between">
        <div class="flex items-center gap-3">
            <div class="w-8 h-8 bg-sky-500 dark:bg-sky-600 rounded-lg flex items-center justify-center">
                <x-flux::icon.arrows-right-left class="w-4 h-4 text-white" />
            </div>
            <h3 class="text-sm font-semibold text-gray-900 dark:text-gray-50">
                Recent Activity
            </h3>
        </div>

        <a href="{{ $viewAllUrl ?? '#' }}"
            class="text-xs font-medium text-sky-600 dark:text-sky-400 hover:text-sky-500 dark:hover:text-sky-300 transition-colors">
            View all
        </a>
    </div>

    @if ($latestTransactions->isEmpty())
        {{-- Empty --}}
        <div class="py-12 text-center text-sm text-gray-500 dark:text-gray-400">
            No transactions yet
        </div>
    @else
        <ul class="divide-y divide-gray-100 dark:divide-gray-700">
            @foreach ($latestTransactions as $transaction)
                @php
                    $icons = [
                        'deposit' => 'arrow-down-tray',
                        'withdrawal' => 'arrow-up-tray',
                        'transfer_in' => 'arrow-down-tray',
                        'transfer_out' => 'arrow-up-tray',
                        'trade' => 'chart-bar',
                        'referral_bonus' => 'user-plus',
                        'signup_bonus' => 'user-plus',
                    ];

                    // [badge classes, icon background]
                    [$badgeClass, $iconBg] = match ($transaction->status) {
                        'approved', 'completed' => [
                            'bg-green-100 text-green-800 dark:bg-green-800/20 dark:text-green-300',
                            'bg-green-500',
                        ],
                        'pending', 'review' => [
                            'bg-yellow-100 text-yellow-800 dark:bg-yellow-900/20 dark:text-yellow-300',
                            'bg-yellow-600',
                        ],
                        'failed', 'rejected' => [
                            'bg-red-100 text-red-800 dark:bg-red-800/20 dark:text-red-300',
                            'bg-red-500',
                        ],
                        default => ['bg-gray-100 text-gray-600 dark:bg-gray-700/20 dark:text-gray-300', 'bg-gray-400'],
                    };
                @endphp

                <li
                    class="px-5 py-3 flex items-center justify-between hover:bg-gray-50 dark:hover:bg-gray-800/40 transition rounded-lg my-1">
                    {{-- Left --}}
                    <div class="flex items-center gap-3">
                        <div class="w-8 h-8 rounded-lg flex items-center justify-center {{ $iconBg }}">
                            <flux:icon name="{{ $icons[$transaction->type] ?? 'square-3-stack-3d' }}"
                                class="w-4 h-4 text-white" />
                        </div>

                        <div class="flex flex-col">
                            <p class="text-sm font-medium text-gray-700 dark:text-gray-200 capitalize">
                                {{ str_replace('_', ' ', $transaction->type) }}
                            </p>
                            <p class="text-xs text-gray-400 dark:text-gray-500">
                                {{ $transaction->created_at->diffForHumans() }}
                            </p>
                        </div>
                    </div>

                    {{-- Right --}}
                    <div class="text-right flex flex-col items-end gap-1">
                        <p class="text-sm font-semibold text-gray-900 dark:text-white">
                            ${{ number_format($transaction->amount, 2) }}
                        </p>
                        <span class="px-2 py-0.5 text-xs font-medium rounded-full {{ $badgeClass }}">
                            {{ ucfirst($transaction->status) }}
                        </span>
                    </div>
                </li>
            @endforeach
        </ul>
    @endif
</div>
