<div class="flex items-center justify-between gap-4 flex-wrap">

    {{-- LEFT: Switch Account --}}
    @if ($accounts->count() > 1)
        <div class="relative" x-data="{ open: false }">

            {{-- Trigger --}}
            <x-flux::button type="button" variant="ghost" class="flex items-center gap-2 text-sm font-medium"
                @click="open = !open">

                <span>Switch Account</span>

                <x-flux::icon.chevron-down class="w-4 h-4 transition-transform duration-200"
                    x-bind:class="open ? 'rotate-180' : ''" />
            </x-flux::button>

            {{-- Dropdown --}}
            <div x-show="open" x-cloak @click.away="open = false" x-transition
                class="absolute mt-2 w-64 rounded-xl
                       bg-white dark:bg-gray-900
                       border border-gray-200 dark:border-gray-700
                       shadow-lg p-2 space-y-1 z-50">

                @foreach ($accounts as $account)
                    <div
                        class="flex items-center justify-between px-3 py-2 rounded-lg
                hover:bg-gray-100 dark:hover:bg-gray-800 transition">

                        <button wire:click="setFocusedAccount({{ $account->id }})" wire:loading.attr="disabled"
                            wire:target="setFocusedAccount({{ $account->id }})"
                            class="text-left text-xs font-medium flex-1 text-gray-700 dark:text-gray-200 flex items-center gap-2">

                            {{-- Spinner while loading --}}
                            <flux:icon.loading wire:loading wire:target="setFocusedAccount({{ $account->id }})"
                                class="h-4 w-4 text-gray-700 dark:text-gray-200" />

                            {{ ucwords(str_replace('_', ' ', preg_replace('/[^a-zA-Z0-9_]/', '', $account->bank_account_type))) }}
                        </button>

                        <div class="flex items-center gap-2">
                            @if ($account->id === $focusedAccountId)
                                <span
                                    class="text-xs px-2 py-0.5 rounded-full bg-sky-100 text-sky-700 dark:bg-sky-700/40 dark:text-sky-200">
                                    Focused
                                </span>
                            @endif

                            <x-toggle :checked="$account->is_active" :title="$account->is_active ? 'Active' : 'Inactive'" wire:key="account-toggle-{{ $account->id }}"
                                wire:click="toggleAccountActive({{ $account->id }})"
                                loadingTarget="toggleAccountActive({{ $account->id }})" />
                        </div>
                    </div>
                @endforeach

            </div>
        </div>
    @endif
    {{-- RIGHT: Refresh --}}
    <a href="{{ route('user.dashboard') }}"
        class="text-xs flex items-center gap-1 font-medium
              text-gray-600 dark:text-gray-300
              hover:text-sky-600 dark:hover:text-sky-400
              transition">

        <x-flux::icon.arrow-path variant="solid" class="w-4 h-4" />
        <span>Refresh</span>
    </a>
</div>

<div
    class="relative rounded-xl space-y-6 bg-white dark:bg-gray-800
 text-gray-800 dark:text-gray-100 transition-colors duration-300 border border-gray-200 dark:border-gray-700">

    <div x-data="bankSlider({{ $focusedIndex ?? 0 }})" class="relative" wire:ignore>
        <!-- Swiper Container -->
        <div class="swiper bank-swiper">
            <div class="swiper-wrapper">

                <!-- Repeat Card for Each Account -->
                @foreach ($accounts as $account)
                    <div wire:key="account-{{ $account->id }}" class="swiper-slide">
                        <div x-cloak
                            class="relative flex-1 rounded-2xl space-y-6
           bg-linear-to-r from-sky-500 to-sky-700 dark:from-sky-800 dark:to-sky-900
           py-6 px-6 text-gray-900 dark:text-white
           shadow-xl transition-colors duration-300">

                            <!-- Decorative Circles -->
                            <div
                                class="absolute p-20 right-4 top-6 aspect-square rounded-full bg-white/10 dark:bg-sky-500/10">
                            </div>
                            <div
                                class="absolute p-20 top-1/2 aspect-square rounded-full bg-white/10 dark:bg-sky-500/10">
                            </div>
                            <div
                                class="absolute p-20 top-1/2 left-1/2 -translate-y-1/2 -translate-x-1/2 aspect-square rounded-full bg-white/10 dark:bg-sky-500/10 z-10">
                            </div>

                            <!-- Header -->
                            <div class="flex flex-wrap items-center justify-between">
                                <!-- Bank Info -->
                                <div class="flex items-center gap-3">
                                    <div
                                        class="w-12 h-12 flex items-center justify-center rounded-full bg-white/20 dark:bg-sky-700/40">
                                        <x-flux::icon.building-library class="w-5 h-5 text-white" />
                                    </div>
                                    <div>
                                        <span
                                            class="block text-sm font-semibold tracking-wide text-white">{{ config('app.name') }}</span>
                                        <p class="text-xs text-white capitalize">
                                            {{ $account->bank_account_type }}</p>
                                    </div>
                                </div>

                                <!-- Account Number -->
                                <div x-data="{
                                    copied: false,
                                    copyText(text) {
                                        navigator.clipboard.writeText(text).then(() => {
                                            this.copied = true;
                                            setTimeout(() => this.copied = false, 2000); // revert after 2s
                                        });
                                    }
                                }" class="relative text-right space-y-1">

                                    <p class="text-xs uppercase tracking-wider text-white">Account Number</p>

                                    <div class="flex items-center justify-end gap-2">
                                        <span
                                            class="text-lg font-mono tracking-widest text-white">{{ $account->masked_account_number ?? '—' }}</span>

                                        <!-- Clipboard / Checkmark Button -->
                                        @if ($account->account_number)
                                            <button @click="copyText('{{ $account->account_number }}')"
                                                class="text-white transition flex items-center justify-center w-6 h-6 rounded-full hover:bg-white/20">

                                                <!-- Show checkmark if copied, else clipboard icon -->
                                                <template x-if="copied">
                                                    <x-flux::icon.check class="w-5 h-5 text-green-500" />
                                                </template>
                                                <template x-if="!copied">
                                                    <x-flux::icon.clipboard class="w-4 h-4" />
                                                </template>
                                            </button>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <div class="z-20 flex items-center justify-center text-center relative">
                                <!-- Fiat Balance -->
                                <div x-cloak x-data="maskedBalance(
                                    {{ $account->id === $focusedAccountId ? '$wire.availableWalletBalance' : bcsub($account->balance, $account->reserve_balance, 2) }},
                                    '{{ $currencySymbol }}'
                                )" class="space-y-3">

                                    <p class="text-xs uppercase tracking-widest text-white">
                                        Fiat Balance
                                    </p>

                                    <div class="flex items-center gap-3 text-white">
                                        <p class="text-2xl font-bold flex-1 text-right font-mono">
                                            <span x-text="display"></span>
                                        </p>

                                        <button @click="show = !show" class="text-white transition">
                                            <template x-if="!show" x-cloak>
                                                <x-flux::icon.eye x-transition.opacity class="w-6 h-6" />
                                            </template>

                                            <template x-if="show" x-cloak>
                                                <x-flux::icon.eye-slash x-transition.opacity class="w-6 h-6" />
                                            </template>
                                        </button>
                                    </div>

                                    <p class="text-xs text-white">
                                        Available balance
                                    </p>
                                </div>

                            </div>

                            <!-- Details -->
                            <div x-data="{
                                accountId: {{ $account->id }},
                                isActive: @js($account->is_active),
                                focusedId: $wire.entangle('focusedAccountId'),
                                focusedUpdated: $wire.entangle('focusedAccountUpdated')
                            }"
                                x-on:account-status-updated.window="
if ($event.detail.id === accountId) {
isActive = $event.detail.is_active
}
"
                                class="flex flex-wrap items-center justify-between gap-6 z-20 relative">
                                <div class="flex items-center gap-2">
                                    <template x-if="isActive">
                                        <div class="flex items-center gap-2 text-white">
                                            <span class="bg-green-400/20 text-green-400 rounded-full p-2">
                                                <x-flux::icon.shield-check class="w-4 h-4" />
                                            </span>
                                            <div class="text-xs">
                                                <p class="font-medium">Account Active</p>
                                                <p class="">Verified & Secured</p>
                                            </div>
                                        </div>
                                    </template>

                                    <template x-if="!isActive">
                                        <div class="flex items-center gap-2">
                                            <span class="bg-red-400/20 text-red-400 rounded-full p-2">
                                                <x-flux::icon.shield-exclamation class="w-4 h-4" />
                                            </span>
                                            <p class="text-xs font-medium">Inactive</p>
                                        </div>
                                    </template>

                                    <template x-if="focusedId === accountId">
                                        <span
                                            class="px-2 py-0.5 bg-sky-100 dark:bg-sky-700 text-sky-800 dark:text-white rounded-full text-xs font-semibold ml-2">
                                            Focused
                                        </span>
                                    </template>
                                </div>

                                <p class="text-xs font-medium italic text-white">
                                    Last updated:
                                    <span x-show="focusedId === accountId" x-text="focusedUpdated"></span>
                                    <span x-show="focusedId !== accountId">
                                        {{ $account->updated_at->diffForHumans() }}
                                    </span>
                                </p>

                            </div>
                        </div>
                    </div>
                @endforeach

                @foreach ($userCryptoBalances as $crypto)
                    <div class="swiper-slide" wire:key="crypto-{{ $crypto->id }}">
                        <div x-cloak
                            class="relative flex-1 rounded-2xl space-y-6
                    bg-linear-to-r from-gray-600 to-gray-800 w-full h-full
                    py-6 px-6 text-white shadow-xl transition-colors duration-300 flex flex-col  gap-4">

                            <!-- Decorative Circles -->
                            <div class="absolute p-20 right-4 top-6 aspect-square rounded-full bg-white/10"></div>
                            <div class="absolute p-20 top-1/2 aspect-square rounded-full bg-white/10"></div>
                            <div
                                class="absolute p-20 top-1/2 left-1/2 -translate-y-1/2 -translate-x-1/2 aspect-square rounded-full bg-white/10 z-10">
                            </div>

                            <!-- Header -->
                            <div class="flex flex-wrap items-center justify-between">
                                <!-- Crypto Info -->
                                <div class="flex items-center gap-3">
                                    <div class="w-12 h-12 flex items-center justify-center rounded-full bg-white/20">
                                        <x-flux::icon.bitcoin class="w-5 h-5 text-white" />
                                    </div>
                                    <div>
                                        <span
                                            class="block text-sm font-semibold tracking-wide text-white">{{ $crypto->label() }}</span>
                                        <p class="text-xs text-white capitalize">
                                            {{ $crypto->account?->name ?? 'Wallet' }}</p>
                                    </div>
                                </div>

                                <!-- Balance & Copy Button -->
                                <div x-data="{
                                    copied: false,
                                    show: false,
                                    display: '{{ $crypto->available_balance }}',
                                    masked: '{{ str_repeat('*', strlen((string) $crypto->available_balance)) }}',
                                    copyText(text) {
                                        navigator.clipboard.writeText(text).then(() => {
                                            this.copied = true;
                                            setTimeout(() => this.copied = false, 2000);
                                        });
                                    }
                                }" class="relative text-right space-y-1">
                                    <p class="text-xs uppercase tracking-wider text-white">Available Balance</p>
                                    <div class="flex items-center justify-end gap-2">
                                        <p class="text-lg font-mono tracking-widest text-white flex-1 text-right"
                                            x-text="show ? display : masked"></p>

                                        <button @click="show = !show" class="text-white transition">
                                            <template x-if="!show" x-cloak>
                                                <x-flux::icon.eye x-transition.opacity class="w-6 h-6" />
                                            </template>
                                            <template x-if="show" x-cloak>
                                                <x-flux::icon.eye-slash x-transition.opacity class="w-6 h-6" />
                                            </template>
                                        </button>

                                        <button @click="copyText(display)"
                                            class="text-white transition flex items-center justify-center w-6 h-6 rounded-full hover:bg-white/20">
                                            <template x-if="copied">
                                                <x-flux::icon.check class="w-5 h-5 text-green-500" />
                                            </template>
                                            <template x-if="!copied">
                                                <x-flux::icon.clipboard class="w-4 h-4" />
                                            </template>
                                        </button>
                                    </div>
                                </div>
                            </div>

                            <!-- Locked Balance -->
                            <div class="z-20 flex items-center justify-center text-center relative">
                                <div class="space-y-3 text-white">
                                    <p class="text-xs uppercase tracking-widest">Locked Balance</p>
                                    <p class="text-2xl font-bold flex-1 text-right font-mono">
                                        {{ $crypto->locked_balance }}</p>
                                </div>
                            </div>

                            <!-- Status -->
                            <div x-data="{ isActive: @js($crypto->is_active) }"
                                class="flex flex-wrap items-center justify-between gap-6 z-20 relative">
                                <div class="flex items-center gap-2">
                                    <template x-if="isActive">
                                        <div class="flex items-center gap-2 text-white">
                                            <span class="bg-green-400/20 text-green-400 rounded-full p-2">
                                                <x-flux::icon.shield-check class="w-4 h-4" />
                                            </span>
                                            <div class="text-xs">
                                                <p class="font-medium">Active</p>
                                                <p>Verified & Secured</p>
                                            </div>
                                        </div>
                                    </template>

                                    <template x-if="!isActive">
                                        <div class="flex items-center gap-2">
                                            <span class="bg-red-400/20 text-red-400 rounded-full p-2">
                                                <x-flux::icon.shield-exclamation class="w-4 h-4" />
                                            </span>
                                            <p class="text-xs font-medium">Inactive</p>
                                        </div>
                                    </template>
                                </div>

                                <p class="text-xs font-medium italic text-white">
                                    Last updated: {{ $crypto->updated_at->diffForHumans() }}
                                </p>
                            </div>
                        </div>
                    </div>
                @endforeach

                <!-- Add Account Card -->
                <div class="swiper-slide">
                    <button @click="$dispatch('open-add-account-modal')"
                        class="relative flex-1 rounded-2xl space-y-6 w-full h-full
           bg-linear-to-tr from-gray-100 to-gray-300
           dark:from-gray-800 dark:to-gray-900
           py-6 px-6 text-gray-900 dark:text-white
           shadow-xl flex flex-col items-center justify-center gap-4
           cursor-pointer hover:bg-gray-200 dark:hover:bg-gray-700 transition">

                        <div
                            class="w-16 h-16 flex items-center justify-center rounded-full bg-sky-200 dark:bg-sky-700">
                            <x-flux::icon.plus class="w-6 h-6 text-sky-600 dark:text-white" />
                        </div>
                        <p class="text-lg font-semibold">Add New Account</p>
                        <p class="text-sm text-gray-500 dark:text-sky-200 text-center">Connect a new
                            bank
                            account to manage your funds.</p>
                    </button>
                </div>
            </div>
            <!-- Pagination OUTSIDE everything -->
            <div id="bank-pagination" class="swiper-pagination"></div>
        </div>
    </div>

</div>

<!-- Add Account Modal -->
<div x-data="{ open: false }" x-on:open-add-account-modal.window="open = true"
    x-on:account-added.window="open = false" x-show="open" x-cloak x-collapse @click.away="open = false"
    class="fixed inset-0 z-50 flex items-center justify-center bg-black/40 backdrop-blur-sm">

    <div class="bg-white dark:bg-gray-900 rounded-xl shadow-xl w-full max-w-md p-6 transform transition-all">

        <!-- Header -->
        <div class="flex justify-between items-center mb-6">
            <h2 class="text-xl font-semibold text-gray-900 dark:text-white">Add New Account</h2>
            <button @click="open = false"
                class="text-gray-400 hover:text-gray-600 dark:hover:text-gray-300 transition">
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>

        <!-- Body -->
        <div class="space-y-4">
            <x-select wire:model.defer="bank_account_type" label="Account Type" placeholder="Select Account Type"
                class="w-full">
                @foreach ($bankAccountTypes as $type)
                    <option value="{{ $type['value'] }}" @if (in_array($type['value'], $existingAccountTypes)) disabled @endif>
                        {{ $type['label'] }}
                        @if (in_array($type['value'], $existingAccountTypes))
                            (Owned)
                        @endif
                    </option>
                @endforeach
            </x-select>
        </div>

        <!-- Actions -->
        <div class="mt-6 flex flex-col space-y-3">
            <x-button wire:click="addAccount" class="w-full bg-sky-600 hover:bg-sky-700 text-white">
                Add Account
            </x-button>

            <x-button type="button" @click="open = false"
                class="w-full border border-gray-300 dark:border-gray-700 text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-800">
                Cancel
            </x-button>
        </div>
    </div>
</div>

<div class="text-center justify-center mx-auto text-xs text-gray-800 dark:text-white flex items-center gap-2">
    <x-flux::icon.hand-raised class="w-4 h-4" />
    <span>
        Swipe to switch between accounts
    </span>
</div>

<div x-data="toggle()" class="relative block md:hidden">

    <div class="grid grid-cols-4 gap-3">

        <a href="{{ route('user.deposit') }}" class="flex flex-col items-center gap-1">
            <div
                class="w-14 h-14 rounded-full flex items-center justify-center
         bg-yellow-600 dark:bg-yellow-400/10
         backdrop-blur-xl
         border border-yellow-200/30 dark:border-yellow-400/20
         shadow-[inset_5px_5px_15px_rgba(255,255,255,0.3),inset_-5px_-5px_15px_rgba(0,0,0,0.15)]
         hover:shadow-[inset_3px_3px_10px_rgba(255,255,255,0.3),inset_-3px_-3px_10px_rgba(0,0,0,0.2),0_8px_15px_rgba(0,0,0,0.25)]
         hover:bg-yellow-300/30 dark:hover:bg-yellow-400/20
         hover:scale-105
         transition-all duration-300">
                <x-flux::icon.plus class="w-5 h-5 text-white" />
            </div>
            <span class="text-xs font-medium text-gray-900 dark:text-gray-100 uppercase tracking-wide">
                Top Up
            </span>
        </a>

        <a href="{{ route('user.local.transfer') }}" class="flex flex-col items-center gap-1">
            <div
                class="w-14 h-14 rounded-full flex items-center justify-center
       bg-white/20 dark:bg-white/10
       backdrop-blur-xl
       border border-white/30 dark:border-white/20
       shadow-[inset_5px_5px_15px_rgba(255,255,255,0.3),inset_-5px_-5px_15px_rgba(0,0,0,0.2)]
       hover:shadow-[inset_3px_3px_10px_rgba(255,255,255,0.3),inset_-3px_-3px_10px_rgba(0,0,0,0.2),0_8px_15px_rgba(0,0,0,0.25)]
       hover:bg-white/30 dark:hover:bg-white/20
       hover:scale-105
       transition-all duration-300 text-gray-900 dark:text-gray-100">
                <x-flux::icon.paper-airplane class="w-5 h-5  -rotate-45" />
            </div>
            <span class="text-xs font-medium  uppercase tracking-wide">
                Send
            </span>
        </a>

        <a href="{{ route('user.deposit') }}" class="flex flex-col items-center gap-1">
            <div
                class="w-14 h-14 rounded-full flex items-center justify-center bg-white/10 dark:bg-white/10
       backdrop-blur-xl
       border border-white/30 dark:border-white/20
       shadow-[inset_5px_5px_15px_rgba(255,255,255,0.3),inset_-5px_-5px_15px_rgba(0,0,0,0.2)]
       hover:shadow-[inset_3px_3px_10px_rgba(255,255,255,0.3),inset_-3px_-3px_10px_rgba(0,0,0,0.2),0_8px_15px_rgba(0,0,0,0.25)]
       hover:bg-white/30 dark:hover:bg-white/20
       hover:scale-105
       transition-all duration-300 text-gray-900 dark:text-gray-100">
                <x-flux::icon.arrow-down class="w-5 h-5 " />
            </div>
            <span class="text-xs font-medium uppercase tracking-wide">
                receive
            </span>
        </a>

        <button type="button" @click="toggle()" class="flex flex-col items-center gap-1">
            <div
                class="w-14 h-14 rounded-full flex items-center justify-center
       bg-white/20 dark:bg-white/10
       backdrop-blur-xl
       border border-white/30 dark:border-white/20
       shadow-[inset_5px_5px_15px_rgba(255,255,255,0.3),inset_-5px_-5px_15px_rgba(0,0,0,0.2)]
       hover:shadow-[inset_3px_3px_10px_rgba(255,255,255,0.3),inset_-3px_-3px_10px_rgba(0,0,0,0.2),0_8px_15px_rgba(0,0,0,0.25)]
       hover:bg-white/30 dark:hover:bg-white/20
       hover:scale-105
       transition-all duration-300 text-gray-900 dark:text-gray-100">
                <x-flux::icon.squares-2x2 class="w-5 h-5 " />
            </div>
            <span class="text-xs font-medium uppercase tracking-wide">
                more
            </span>
        </button>
    </div>

    <!-- Slide-in Menu -->
    <div x-show="open" x-cloak x-transition:enter="transition ease-out duration-300"
        x-transition:enter-start="translate-y-full opacity-0" x-transition:enter-end="translate-y-0 opacity-100"
        x-transition:leave="transition ease-in duration-300" x-transition:leave-start="translate-y-0 opacity-100"
        x-transition:leave-end="translate-y-full opacity-0" @click.away="close()"
        class="fixed inset-x-0 bottom-0 bg-white dark:bg-gray-900 shadow-xl rounded-t-2xl p-4 z-50">

        <div class="flex justify-between items-center mb-3">
            <h3 class="text-sm font-semibold">Quick Actions</h3>
            <button @click="close()" class="text-gray-500 hover:text-gray-900 dark:hover:text-white">
                ✕
            </button>
        </div>

        <div class="grid grid-cols-3 gap-4">
            <!-- Deposit -->
            <a href="{{ route('user.deposit') }}" class="flex flex-col items-center gap-1">
                <div class="w-12 h-12 bg-blue-500 rounded-full flex items-center justify-center text-white">
                    💰
                </div>
                <span class="text-xs font-medium">Deposit</span>
            </a>

            <!-- Withdrawal -->
            <a href="{{ route('user.withdrawal') }}" class="flex flex-col items-center gap-1">
                <div class="w-12 h-12 bg-green-500 rounded-full flex items-center justify-center text-white">
                    📤
                </div>
                <span class="text-xs font-medium">Withdraw</span>
            </a>

            <!-- Local Transfer -->
            <a href="{{ route('user.local.transfer') }}" class="flex flex-col items-center gap-1">
                <div class="w-12 h-12 bg-red-500 rounded-full flex items-center justify-center text-white">
                    ⚡
                </div>
                <span class="text-xs font-medium">Transfer</span>
            </a>
        </div>
    </div>

</div>
