<div class="space-y-6">
    <h2 class="text-2xl font-bold mb-4 border-b pb-2">Preview Your Information</h2>

    <!-- Personal Info -->
    <section class="space-y-2">
        <h3 class="text-xl font-semibold">Personal Info</h3>
        <div class="grid grid-cols-2 gap-4">
            <p><span class="font-medium">Name:</span> {{ $this->previewData['name'] }}</p>
            <p><span class="font-medium">Username:</span> {{ $this->previewData['username'] }}</p>
            <p><span class="font-medium">Date of Birth:</span> {{ $this->previewData['date_of_birth'] }}</p>
            <p><span class="font-medium">Gender:</span> {{ ucfirst($this->previewData['gender']) }}</p>
        </div>
        <button wire:click="goToStep(1)"
            class="mt-2 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600 transition">
            Edit Personal Info
        </button>
    </section>

    <!-- Address & Contact -->
    <section class="space-y-2">
        <h3 class="text-xl font-semibold">Address & Contact</h3>
        <div class="grid grid-cols-2 gap-4">
            <p><span class="font-medium">Country:</span> {{ $this->previewData['country'] }}</p>
            <p><span class="font-medium">State:</span> {{ $this->previewData['state'] }}</p>
            <p><span class="font-medium">City:</span> {{ $this->previewData['city'] }}</p>
            <p><span class="font-medium">Zip Code:</span> {{ $this->previewData['zip_code'] }}</p>
            <p><span class="font-medium">Phone:</span> {{ $this->previewData['phone'] }}</p>
        </div>
        <button wire:click="goToStep(2)"
            class="mt-2 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600 transition">
            Edit Address & Contact
        </button>
    </section>

    <!-- Account Info -->
    <section class="space-y-2">
        <h3 class="text-xl font-semibold">Account Info</h3>
        <div class="grid grid-cols-2 gap-4">
            <p><span class="font-medium">Account Type:</span> {{ ucfirst($this->previewData['bank_account_type']) }}</p>
            <p><span class="font-medium">Currency:</span> {{ strtoupper($this->previewData['currency']) }}</p>
            <p><span class="font-medium">Password:</span> ••••••••</p>
        </div>
        <button wire:click="goToStep(3)"
            class="mt-2 px-4 py-2 bg-blue-500 text-white rounded hover:bg-blue-600 transition">
            Edit Account Info
        </button>
    </section>

    <div class="flex items-start space-x-2 mt-4">
        <div class="flex flex-col gap-2">
            <div class="flex items-center">
                <!-- Agreement Checkbox -->
                <input type="checkbox" id="terms" wire:model.defer="formData.agreement_accepted"
                    class="mt-1 h-4 w-4 text-sky-600 border-gray-300 rounded focus:ring-sky-500">

                <!-- Label -->
                <label for="terms" class="ml-2 text-sm text-gray-700 leading-5">
                    I agree to the
                    <a href="{{ route('privacy.terms') }}" target="_blank" class="text-sky-600 hover:underline">Terms of
                        Service</a>
                    and
                    <a href="{{ route('privacy.data') }}" target="_blank" class="text-sky-600 hover:underline">Privacy
                        Policy</a>.
                </label>
            </div>

            <!-- Validation Error -->
            @error('formData.agreement_accepted')
                <p class="mt-1 text-sm text-red-600 dark:text-red-400 flex items-center gap-1">
                    <x-flux::icon name="exclamation-circle" class="h-4 w-4" />
                    {{ $message }}
                </p>
            @enderror
        </div>
    </div>

</div>
