<div class="space-y-6">

    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">

        <!-- Account Type (Optional) -->
        <div>
            <x-select wire:model.defer="formData.bank_account_type" placeholder="Select Account" label="Account Type">
                @foreach ($bankAccountTypes as $type)
                    <option value="{{ $type['value'] }}">{{ $type['label'] }}</option>
                @endforeach
            </x-select>
        </div>

        <!-- Currency -->
        <div>
            <x-select wire:model.defer="formData.currency" label="Currency" placeholder="Select Currency">
                @foreach ($currencies as $currency)
                    <option value="{{ $currency['code'] }}">
                        {{ $currency['symbol'] }} {{ $currency['code'] }}
                    </option>
                @endforeach
            </x-select>
        </div>

    </div>

    <!-- Password -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
        <div>
            <flux:input type="password" label="Password" wire:model.defer="password" :placeholder="__('Password')"
                viewable
                description:trailing="Must be at least 8 characters long, include an uppercase letter, a number, and a special character." />
        </div>

        <div>
            <flux:input wire:model.defer="password_confirmation" :label="__('Confirm Password')" type="password"
                required autocomplete="confirm-password" :placeholder="__('Confirm Password')" viewable />
        </div>
    </div>

</div>
