    <form wire:submit.prevent="submit" enctype="multipart/form-data" class=" space-y-5" x-data="{
        isUploadingIdImages: false,
        idImagesProgress: 0
    }">
        <h2 class="text-lg font-semibold text-gray-800 dark:text-gray-100 text-center">Upload Your ID</h2>
        <p class="text-gray-500 dark:text-gray-300 text-sm text-center">
            Please upload an original government-issued ID.
        </p>

        <!-- Document type -->
        <flux:select wire:model.defer="id_type" label="Document Type">
            <option value="">Select Document Type</option>
            @foreach ($kyc_docs as $type)
                <option value="{{ $type['value'] }}">{{ $type['label'] }}</option>
            @endforeach
        </flux:select>

        <div x-data="{ uploading: false, progress: 0 }" x-on:livewire-upload-start="uploading = true"
            x-on:livewire-upload-finish="uploading = false" x-on:livewire-upload-cancel="uploading = false"
            x-on:livewire-upload-error="uploading = false"
            x-on:livewire-upload-progress="progress = $event.detail.progress">
            <!-- File Input -->
            <label for="id_images"
                class="flex flex-col items-center justify-center p-6 border-2 border-dashed border-gray-300 dark:border-gray-600 rounded-lg cursor-pointer hover:border-blue-500 transition-colors text-center">
                <x-flux::icon.arrow-up-on-square class="w-8 h-8 text-blue-600 dark:text-white mb-2" />
                <span class="text-gray-600 dark:text-gray-200 font-medium">Click or drag files here</span>
                <span class="text-gray-400 dark:text-gray-400 text-sm mt-1">JPG, PNG, WEBP (max 2MB each)</span>
                <input type="file" id="id_images" multiple wire:model="id_images"
                    accept="image/jpeg, image/png, image/webp" class="hidden" />
            </label>

            <!-- Progress Bar -->
            <div x-show="uploading">
                <progress max="100" x-bind:value="progress"></progress>
                <!-- Cancel upload button -->
                <button type="button" wire:click="$cancelUpload('id_images')">Cancel Upload</button>
            </div>

            <!-- Preview thumbnails -->
            <div class="flex flex-wrap gap-3 mt-4 justify-center">
                @if ($temp_id_images)
                    @foreach ($temp_id_images as $index => $image)
                        <div wire:key="id_image_{{ $index }}"
                            class="relative w-20 h-20 rounded overflow-hidden border border-gray-300 dark:border-gray-600 shadow-sm">
                            <img src="{{ $image->temporaryUrl() }}" alt="Preview {{ $index + 1 }}"
                                class="w-full h-full object-cover" />
                            <button type="button" wire:click="removeImage('temp_id_images', {{ $index }})"
                                class="absolute top-1 right-1 bg-red-600 text-white rounded-full w-5 h-5 flex items-center justify-center hover:bg-red-800 shadow"
                                title="Remove image">
                                &times;
                            </button>
                        </div>
                    @endforeach
                @endif
            </div>

            @error('id_images')
                <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
            @enderror
            @error('id_images.*')
                <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
            @enderror
        </div>

        <button type="submit" wire:loading.attr="disabled" wire:target="id_images,submit"
            class="w-full flex items-center justify-center gap-2 px-4 py-3 bg-blue-600 hover:bg-blue-700 text-white font-semibold rounded-md transition disabled:opacity-50">
            <svg wire:loading wire:target="submit" class="animate-spin h-5 w-5 text-white" fill="none"
                viewbox="0 0 24 24">
                <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor"
                    stroke-width="4" />
                <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8v8z" />
            </svg>
            <span wire:loading.remove wire:target="submit">Continue</span>
        </button>

        <flux:button variant="primary" color="red" @click="open = false">Close & Cancel</flux:button>

    </form>
