{{-- Compact Fiat Account Cards --}}
<div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-4">

    @foreach ($this->accounts as $account)
        @php
            $isSelected = (string) $selectedFromAccount === (string) $account->id;
        @endphp

        <div wire:click="$set('selectedFromAccount', '{{ $account->id }}')"
            class="relative cursor-pointer rounded-xl p-4 transition-all duration-200
                   flex justify-between items-center
                   {{ $isSelected
                       ? 'bg-sky-600 text-white shadow-lg scale-[1.03]'
                       : 'bg-white dark:bg-gray-800 text-gray-800 dark:text-gray-100 hover:shadow-md hover:scale-[1.01]' }}">

            {{-- Left Section --}}
            <div class="flex items-center gap-3">
                <div
                    class="w-10 h-10 rounded-full flex items-center justify-center
                           bg-sky-100 text-sky-600 dark:bg-sky-900 dark:text-sky-300 text-sm">
                    🏦
                </div>

                <div>
                    <div class="text-sm font-semibold truncate">
                        {{ $account->masked_account_number }}
                    </div>
                    <div class="text-xs text-gray-400 dark:text-gray-300 uppercase tracking-wide">
                        {{ str_replace('_', ' ', $account->bank_account_type) }}
                    </div>
                </div>
            </div>

            {{-- Right Section --}}
            <div class="text-right flex flex-col items-end gap-1">
                {{-- Balance --}}
                <div class="text-lg font-bold">
                    {{ $currencySymbol }}{{ number_format($account->dashboard_balances['available'], 2) }}
                </div>

                {{-- Status --}}
                <div
                    class="text-xs px-2 py-0.5 rounded-full
                            {{ $account->is_active
                                ? 'bg-green-100 text-green-700 dark:bg-green-700 dark:text-green-100'
                                : 'bg-red-100 text-red-700 dark:bg-red-700 dark:text-red-100' }}">
                    {{ $account->is_active ? 'Active' : 'Inactive' }}
                </div>
            </div>

            {{-- Selected Check --}}
            @if ($isSelected)
                <div
                    class="absolute -top-2 -right-2 w-6 h-6 rounded-full
                           bg-white text-sky-600 dark:bg-gray-800 dark:text-sky-400
                           flex items-center justify-center text-xs font-bold shadow-md">
                    ✓
                </div>
            @endif
        </div>
    @endforeach

</div>
