@if ($errors->any())
    <div wire:key="errors-{{ now()->timestamp }}" x-cloak x-data="{ show: false }" x-init="show = true;
    setTimeout(() => show = false, 5000)" x-show="show"
        class="fixed top-6 right-6 z-50 space-y-3">
        @foreach ($errors->all() as $error)
            <div class="flex items-start gap-2 bg-red-600 text-white px-4 py-3 rounded-lg shadow-lg min-w-70">
                <x-flux::icon name="exclamation-circle" class="h-5 w-5 mt-0.5 shrink-0" />
                <span class="text-sm">{{ $error }}</span>
            </div>
        @endforeach
    </div>
@endif
