<div
    class="bg-white/80 dark:bg-gray-800/80 backdrop-blur-xl rounded-2xl shadow-lg dark:shadow-gray-900/50 overflow-hidden border border-white/20 dark:border-gray-700/50">
    <!-- Header -->
    <div
        class="px-4 py-2 bg-linear-to-r from-sky-50/80 to-sky-100/50 dark:from-gray-900/80 dark:to-gray-800/50 border-b border-sky-100/50 dark:border-gray-700/50">
        <div class="flex items-center justify-between">
            <div class="flex items-center">
                <div class="w-6 h-6 bg-sky-500 rounded-lg flex items-center justify-center mr-2">
                    <x-flux::icon.credit-card class="w-4 h-4 text-white" />
                </div>
                <h3 class="text-sm font-bold text-sky-900 dark:text-sky-100">Your Active Cards</h3>
            </div>
            <a href="{{ route('user.virtual.cards') }}"
                class="text-xs font-medium text-sky-600 dark:text-sky-400 hover:text-sky-700 dark:hover:text-sky-300 flex items-center transition-colors">
                Manage Cards
                <x-flux::icon.chevron-down class="w-5 h-5  ml-1" />
            </a>
        </div>
    </div>

    <!-- Content -->
    <div wire:ignore class="swiper mySwiper">
        <div class="swiper-wrapper">

            @forelse ($this->creditCards as $card)
                @php
                    $statusClass = match ($card->status) {
                        'active' => 'bg-green-100 text-green-800',
                        'pending' => 'bg-yellow-100 text-yellow-800',
                        'blocked' => 'bg-red-100 text-red-800',
                        default => 'bg-gray-100 text-gray-800',
                    };

                    $cardBgClass = match (strtolower($card->card_type)) {
                        'visa' => 'from-blue-800 via-blue-600 to-blue-500',
                        'mastercard' => 'from-red-600 via-orange-500 to-yellow-400',
                        'amex' => 'from-green-600 via-teal-500 to-cyan-400',
                        'discover' => 'from-purple-600 via-pink-500 to-indigo-400',
                        default => 'from-gray-600 via-gray-500 to-gray-400',
                    };

                    $chipClass = match (strtolower($card->card_type)) {
                        'visa' => 'from-yellow-400 to-yellow-500',
                        'mastercard' => 'from-red-400 to-orange-500',
                        'amex' => 'from-green-400 to-teal-500',
                        'discover' => 'from-purple-400 to-pink-500',
                        default => 'from-gray-400 to-gray-500',
                    };
                @endphp

                <div class="swiper-slide">
                    <div
                        class="group bg-linear-to-br from-sky-50/50 to-sky-100/30 dark:from-gray-900/50 dark:to-gray-800/30 rounded-xl border border-sky-100/50 dark:border-gray-700/50 hover:border-sky-200 dark:hover:border-gray-600 transition-all duration-300 hover:shadow-lg hover:shadow-sky-500/20 dark:hover:shadow-gray-900/30 overflow-hidden">
                        <!-- Card Visual -->
                        <div class="p-3">
                            <div
                                class="w-full h-32 rounded-xl relative overflow-hidden shadow-sm group-hover:shadow-md transition-all duration-300 transform group-hover:scale-[1.02]">
                                <div class="absolute inset-0 bg-linear-to-br {{ $cardBgClass }}">
                                </div>

                                <!-- Card Content -->
                                <div class="absolute inset-0 p-3 flex flex-col justify-between text-white">
                                    <!-- Top Section -->
                                    <div class="flex justify-between items-start">
                                        <div>
                                            <div class="font-semibold text-xs tracking-wide"> {{ config('app.name') }}
                                            </div>
                                            <div class="text-xs opacity-70">Virtual Banking</div>
                                        </div>
                                        <div>
                                            <x-flux::icon.credit-card class="w-4 h-4 text-white" />
                                        </div>
                                    </div>

                                    <!-- Card Number -->
                                    <div class="font-mono text-sm tracking-widest">
                                        **** •••• •••• {{ $card->last_four }}
                                    </div>

                                    <!-- Bottom Section -->
                                    <div class="flex justify-between items-end">
                                        <div class="flex-1 min-w-0">
                                            <div class="text-xs opacity-70 mb-0.5">Card Holder</div>
                                            <div class="font-medium text-xs truncate">{{ $card->user->name }}</div>
                                        </div>
                                        <div class="text-right ml-2">
                                            <div class="text-xs opacity-70 mb-0.5">Valid</div>
                                            <div class="font-medium text-xs">
                                                {{ \Carbon\Carbon::parse($card->expiry_date)->format('m/y') }}</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Card Info -->
                        <div class="px-3 pb-3">
                            <div class="flex justify-between items-center mb-2">
                                <div class="flex items-center space-x-2">
                                    <div class="text-xs text-sky-700 dark:text-sky-300 font-medium capitalize">
                                        {{ ucfirst($card->card_type) }}
                                    </div>
                                    <span
                                        class="text-xs font-semibold px-3 py-1 rounded-full inline-block {{ $statusClass }}">
                                        {{ ucfirst($card->status) }}
                                    </span>
                                </div>
                                <div class="text-xs font-semibold text-sky-900 dark:text-sky-100">
                                    {{ ucfirst($card->extra_data['currency']) }} -
                                    {{ ucfirst(number_format($card->balance, 2)) }}</div>
                            </div>
                            <a href="{{ route('user.virtual.cards', ['cardId' => $card->id]) }}"
                                class="block w-full text-center px-3 py-1.5 bg-sky-100 dark:bg-gray-700/50 hover:bg-sky-200 dark:hover:bg-gray-600/50 rounded-lg text-xs font-medium text-sky-700 dark:text-sky-300 transition-colors duration-200">
                                View Details
                            </a>
                        </div>
                    </div>

                </div>

            @empty

                {{-- Empty State --}}
                <div class="flex flex-col items-center justify-center py-10 gap-2 text-center max-w-md mx-auto">
                    <div class="flex h-14 w-14 items-center justify-center rounded-full bg-sky-100 dark:bg-sky-500/20">
                        <flux:icon name="credit-card" class="h-6 w-6 text-white" variant="solid" />
                    </div>

                    <p class="text-sm text-gray-600 dark:text-sky-300">
                        Apply for a virtual card to get started with secure online payments.
                    </p>

                    <a href="{{ route('user.virtual.cards') }}"
                        class="mt-2 inline-flex items-center gap-2 rounded-lg bg-sky-600 px-5 py-2.5 text-sm font-medium text-white transition hover:bg-sky-700 focus:outline-none focus:ring-2 focus:ring-sky-400 dark:bg-sky-500 dark:hover:bg-sky-400">
                        <x-flux::icon.plus variant="solid" class="h-4 w-4" />
                        Apply for a card
                    </a>
                </div>
            @endforelse

        </div>
        <div class="swiper-pagination my-pagination"></div>

    </div>

</div>
