<div
    class="md:hidden flex bg-white dark:bg-gray-800 rounded-lg p-5 border border-gray-200 dark:border-gray-700 relative hover:shadow-lg transition-shadow duration-200  flex-col space-y-4 text-white">

    <!-- Heading -->
    <div class="flex items-center justify-between text-gray-800 dark:text-gray-200">
        <h2 class="text-base font-semibold tracking-wide">Need Assistance?</h2>
        <a href="{{ route('user.ticket.create') }}" class="text-sm text-sky-700 dark:text-sky-400 hover:underline">Support
            Center</a>
    </div>

    <!-- Support Options -->
    <div class="grid grid-cols-1 sm:grid-cols-2 gap-4">
        <!-- Live Chat -->
        <div
            class="flex flex-col h-full bg-white dark:bg-gray-900 rounded-lg p-5 text-center border border-gray-200 dark:border-gray-700 hover:shadow-md transition-shadow duration-200 space-y-2">
            <div
                class="w-10 h-10 flex items-center justify-center mx-auto rounded-lg bg-linear-to-br from-sky-50 to-sky-100 dark:from-sky-800 dark:to-sky-700">
                <x-flux::icon.chat-bubble-left class="w-5 h-5 text-sky-700 dark:text-sky-300" variant="solid" />
            </div>
            <h3 class="text-sm font-medium text-gray-800 dark:text-gray-100">Live Chat</h3>
            <p class="text-xs text-gray-500 dark:text-gray-400">Instant assistance from our team.</p>
        </div>

        <!-- Email Support -->
        <div
            class="flex flex-col h-full bg-white dark:bg-gray-900 rounded-lg p-5 text-center border border-gray-200 dark:border-gray-700 hover:shadow-md transition-shadow duration-200 space-y-2">
            <div
                class="w-10 h-10 flex items-center justify-center mx-auto rounded-lg bg-linear-to-br from-green-50 to-green-100 dark:from-green-800 dark:to-green-700">
                <x-flux::icon.envelope class="w-5 h-5 text-green-700 dark:text-green-300" variant="solid" />
            </div>
            <h3 class="text-sm font-medium text-gray-800 dark:text-gray-100">Email Support</h3>
            <p class="text-xs text-gray-500 dark:text-gray-400">Send your enquiry via email.</p>
        </div>
    </div>

    <!-- 24/7 Support Info -->
    <div
        class="flex flex-col h-full bg-white dark:bg-gray-900 rounded-lg border border-gray-200 dark:border-gray-700 space-y-3 hover:shadow-md transition-shadow duration-200">
        <div
            class="flex items-center space-x-2 text-gray-800 dark:text-gray-100 bg-gray-50 dark:bg-gray-800 py-2 px-3 rounded-t-lg">
            <div class="w-8 h-8 bg-sky-700/50 aspect-square rounded-2xl text-xs flex items-center justify-center ">
                <x-flux::icon.headset class="w-5 h-5 text-gray-600 dark:text-gray-400" />
            </div>

            <h3 class="font-medium text-sm">24/7 Support</h3>
        </div>

        <div class="p-4 text-center space-y-2">
            <p class="text-sm text-gray-500 dark:text-gray-400">
                We're available anytime to assist you.
            </p>

            <div class="flex items-center justify-center text-gray-600 dark:text-gray-300 text-sm space-x-6">
                <div class="flex items-center flex-col space-y-1">
                    <div
                        class="w-8 h-8 bg-sky-700/60 aspect-square rounded-2xl text-xs flex items-center justify-center mx-auto">
                        <x-flux::icon.clock class="w-5 h-5" />
                    </div>
                    <span>24/7</span>
                </div>

                <div class="flex items-center flex-col space-y-1">
                    <div
                        class="w-8 h-8 bg-green-700/60 aspect-square rounded-2xl text-xs flex items-center justify-center mx-auto">
                        <x-flux::icon.headset class="w-5 h-5" />
                    </div>
                    <span>Support</span>
                </div>

                <div class="flex items-center flex-col space-y-1">
                    <div
                        class="w-8 h-8 bg-sky-700/60 aspect-square rounded-2xl text-xs flex items-center justify-center mx-auto">
                        <x-flux::icon.bolt class="w-5 h-5" />
                    </div>
                    <span>Fast</span>
                </div>

            </div>
        </div>
    </div>

</div>

<div
    class="hidden md:flex bg-white dark:bg-gray-800 rounded-lg p-5 border border-gray-200 dark:border-gray-700 relative hover:shadow-lg transition-shadow duration-200  flex-col space-y-4">

    <!-- Header / Icon -->
    <div class="text-center space-y-2">
        <div class="w-12 h-12 flex items-center justify-center rounded-2xl bg-sky-600 text-white mx-auto relative">
            <x-flux::icon.chat-bubble-left-right variant="solid" class="w-6 h-6" />
            <!-- Ping dot for new message -->
            <span class="absolute top-0 right-0 block w-2 h-2 bg-green-400 rounded-full animate-ping"></span>
        </div>

        <h3 class="text-sm font-semibold tracking-wide">Need Assistance?</h3>
        <p class="text-sm text-gray-600 dark:text-sky-200">Our expert support team is ready to help
        </p>
        <p class="text-xs font-bold text-sky-600">24/7 Live Support</p>
    </div>

    <!-- Features -->
    <div class="grid grid-cols-1 md:grid-cols-2 gap-2">
        <div
            class="flex items-center gap-2 bg-white dark:bg-gray-900 p-3 rounded-lg shadow-sm text-gray-700 dark:text-sky-200">
            <x-flux::icon.clock variant="solid" class="w-4 h-4 text-sky-600" />
            <div class="text-sm">
                <p class="font-medium">Quick Response</p>
                <p class="text-xs text-gray-500 dark:text-sky-400">
                    < 5 minutes</p>
            </div>
        </div>

        <div
            class="flex items-center gap-2 bg-white dark:bg-gray-900 p-3 rounded-lg shadow-sm text-gray-700 dark:text-sky-200">
            <x-flux::icon.shield-check variant="solid" class="w-4 h-4 text-emerald-600" />
            <div class="text-sm">
                <p class="font-medium">Secure Chat</p>
                <p class="text-xs text-gray-500 dark:text-sky-400">Encrypted</p>
            </div>
        </div>
    </div>

    <!-- Actions -->
    <div class="space-y-3 text-center">
        <a href="{{ route('user.ticket.create') }}"
            class="inline-flex items-center gap-2 bg-sky-600 hover:scale-105 transition-transform font-semibold px-2 py-3 text-white rounded-2xl text-sm">
            <x-flux::icon.chat-bubble-oval-left variant="solid" class="w-5 h-5" />
            Open Ticket
        </a>

        <div class="flex items-center justify-center gap-2 text-gray-700 dark:text-sky-200">
            <x-flux::icon.phone class="w-5 h-5 text-sky-600" variant="solid" />
            <p class="text-sm">Or call us directly for urgent matters</p>
        </div>
    </div>
</div>
