<!-- Cookie Consent -->
<div x-data="bankCookieConsent()" x-init="init()" x-cloak>

    <!-- Floating Cookie Settings Button -->
    <div class="z-50">
      <button
    @click="openPreferences = true"
    class="relative flex items-center justify-center
           w-12 h-12
           bg-sky-700 hover:bg-sky-800
           text-white
           rounded-full
           shadow-lg
           focus:outline-none focus:ring-4 focus:ring-sky-200
           transition"
    aria-label="Cookie settings"
>

    <!-- Icon -->
    <x-dynamic-component 
        :component="'flux::icon.person-standing'" 
        class="w-5 h-5"
    />

    <!-- Red dot if no consent -->
    <span
        x-show="!consentGiven"
        class="absolute top-2 right-2
               w-2.5 h-2.5
               bg-red-500
               rounded-full"
    ></span>

</button>

    </div>

    <!-- Modal Backdrop -->
    <div
        x-show="openPreferences"
        x-trap.noscroll="openPreferences"
        x-transition.opacity
        class="fixed inset-0 z-9999 flex items-center justify-center bg-black/70 p-4"
        role="dialog"
        aria-modal="true"
        aria-labelledby="cookie-title"
        style="display:none"
    >
  <div
    @click.away="openPreferences = false"
    class="bg-white dark:bg-gray-900 rounded-2xl max-w-3xl w-full shadow-2xl overflow-hidden
           max-h-[85vh] flex flex-col"
>


            <!-- Header -->
            <div class="px-6 py-5 border-b border-gray-200 dark:border-gray-800">
                <h2 id="cookie-title" class="text-xl md:text-2xl font-bold text-gray-900 dark:text-gray-100">
                    Cookie & Tracking Preferences
                </h2>

                <p class="mt-2 text-sm text-gray-600 dark:text-gray-300 leading-relaxed">
                    We use cookies and similar technologies to provide secure online banking services, improve performance,
                    and personalize your experience. You can choose which optional cookies we may use.
                </p>
            </div>

            <!-- Body -->
            <div class="px-6 py-6 space-y-5 overflow-y-auto">

                <!-- Quick Actions -->
                <div class="flex flex-col sm:flex-row gap-3">
                    <button
                        type="button"
                        @click="acceptAll()"
                        class="w-full sm:w-auto px-5 py-3 rounded-xl bg-sky-700 hover:bg-sky-800 text-white font-semibold transition focus:outline-none focus:ring-4 focus:ring-sky-200"
                    >
                        Accept All
                    </button>

                    <button
                        type="button"
                        @click="rejectAll()"
                        class="w-full sm:w-auto px-5 py-3 rounded-xl bg-gray-100 hover:bg-gray-200 dark:bg-gray-800 dark:hover:bg-gray-700 text-gray-900 dark:text-gray-100 font-semibold transition focus:outline-none focus:ring-4 focus:ring-gray-200 dark:focus:ring-gray-700"
                    >
                        Reject Non-Essential
                    </button>

                    <button
                        type="button"
                        @click="resetPreferences()"
                        class="w-full sm:w-auto px-5 py-3 rounded-xl border border-gray-300 dark:border-gray-700 text-gray-700 dark:text-gray-200 hover:bg-gray-50 dark:hover:bg-gray-800 font-semibold transition"
                    >
                        Reset
                    </button>
                </div>

                <!-- Preference Form -->
                <form @submit.prevent="savePreferences()" class="space-y-4">

                    <!-- Essential -->
                    <div class="p-4 rounded-xl bg-sky-50 dark:bg-gray-800 border border-sky-100 dark:border-gray-700">
                        <label class="flex justify-between items-start gap-4">
                            <div>
                                <p class="font-semibold text-gray-900 dark:text-gray-100">
                                    Essential Cookies (Always On)
                                </p>
                                <p class="text-sm text-gray-600 dark:text-gray-300">
                                    Required for security, session management, fraud prevention, and core features.
                                </p>
                            </div>

                            <input type="checkbox" checked disabled class="mt-1" />
                        </label>
                    </div>

                    <!-- Performance -->
                    <div class="p-4 rounded-xl border border-gray-200 dark:border-gray-700">
                        <label class="flex justify-between items-start gap-4">
                            <div>
                                <p class="font-semibold text-gray-900 dark:text-gray-100">Performance</p>
                                <p class="text-sm text-gray-600 dark:text-gray-300">
                                    Helps us measure load times, errors, and stability to improve reliability.
                                </p>
                            </div>
                            <input type="checkbox" x-model="preferences.performance" class="mt-1" />
                        </label>
                    </div>

                    <!-- Analytics -->
                    <div class="p-4 rounded-xl border border-gray-200 dark:border-gray-700">
                        <label class="flex justify-between items-start gap-4">
                            <div>
                                <p class="font-semibold text-gray-900 dark:text-gray-100">Analytics</p>
                                <p class="text-sm text-gray-600 dark:text-gray-300">
                                    Understand how visitors use the site so we can improve navigation and content.
                                </p>
                            </div>
                            <input type="checkbox" x-model="preferences.analytics" class="mt-1" />
                        </label>
                    </div>

                    <!-- Functional -->
                    <div class="p-4 rounded-xl border border-gray-200 dark:border-gray-700">
                        <label class="flex justify-between items-start gap-4">
                            <div>
                                <p class="font-semibold text-gray-900 dark:text-gray-100">Functional</p>
                                <p class="text-sm text-gray-600 dark:text-gray-300">
                                    Remembers your settings (theme, language, accessibility preferences).
                                </p>
                            </div>
                            <input type="checkbox" x-model="preferences.functional" class="mt-1" />
                        </label>
                    </div>

                    <!-- Personalization -->
                    <div class="p-4 rounded-xl border border-gray-200 dark:border-gray-700">
                        <label class="flex justify-between items-start gap-4">
                            <div>
                                <p class="font-semibold text-gray-900 dark:text-gray-100">Personalization</p>
                                <p class="text-sm text-gray-600 dark:text-gray-300">
                                    Tailors content and recommended services based on your activity.
                                </p>
                            </div>
                            <input type="checkbox" x-model="preferences.personalization" class="mt-1" />
                        </label>
                    </div>

                    <!-- Advertising -->
                    <div class="p-4 rounded-xl border border-gray-200 dark:border-gray-700">
                        <label class="flex justify-between items-start gap-4">
                            <div>
                                <p class="font-semibold text-gray-900 dark:text-gray-100">Advertising</p>
                                <p class="text-sm text-gray-600 dark:text-gray-300">
                                    Used to measure campaigns and show relevant offers. Disabled by default.
                                </p>
                            </div>
                            <input type="checkbox" x-model="preferences.advertising" class="mt-1" />
                        </label>
                    </div>

                    <!-- Do Not Sell / Share -->
                    <div class="p-4 rounded-xl border border-gray-200 dark:border-gray-700">
                        <label class="flex justify-between items-start gap-4">
                            <div>
                                <p class="font-semibold text-gray-900 dark:text-gray-100">
                                    Do Not Sell or Share My Personal Information
                                </p>
                                <p class="text-sm text-gray-600 dark:text-gray-300">
                                    If enabled, we will disable tracking used for cross-context behavioral advertising.
                                </p>
                            </div>
                            <input type="checkbox" x-model="preferences.doNotSellShare" class="mt-1" />
                        </label>
                    </div>

                    <!-- Footer Buttons -->
                    <div class="flex flex-col sm:flex-row justify-end gap-3 pt-3">
                        <button
                            type="button"
                            @click="openPreferences = false"
                            class="px-5 py-3 rounded-xl bg-gray-100 hover:bg-gray-200 dark:bg-gray-800 dark:hover:bg-gray-700 text-gray-900 dark:text-gray-100 font-semibold transition"
                        >
                            Cancel
                        </button>

                        <button
                            type="submit"
                            class="px-5 py-3 rounded-xl bg-sky-700 hover:bg-sky-800 text-white font-semibold transition focus:outline-none focus:ring-4 focus:ring-sky-200"
                        >
                            Save Preferences
                        </button>
                    </div>
                </form>

                <!-- Small legal note -->
                <p class="text-xs text-gray-500 dark:text-gray-400 leading-relaxed">
                    Your choices are saved on this device. You can update your preferences at any time.
                </p>
            </div>
        </div>
    </div>
</div>

<script>
    function bankCookieConsent() {
        return {
            openPreferences: false,
            consentGiven: false,

            storageKey: "bank_cookie_consent_v1",
            consentVersion: 1,

            preferences: {
                // Essential is implied (always on)
                performance: false,
                analytics: false,
                functional: false,
                personalization: false,
                advertising: false,
                doNotSellShare: true, // banking-friendly default
            },

            init() {
                const saved = this.getSavedConsent();

                if (saved) {
                    this.preferences = saved.preferences;
                    this.consentGiven = true;
                    this.applyPreferences();
                } else {
                    // Optional: auto-open on first visit
                    // this.openPreferences = true;
                }
            },

            getSavedConsent() {
                try {
                    const raw = localStorage.getItem(this.storageKey);
                    if (!raw) return null;

                    const parsed = JSON.parse(raw);

                    // If version mismatch, ignore (forces re-consent)
                    if (!parsed.version || parsed.version !== this.consentVersion) return null;

                    return parsed;
                } catch (e) {
                    return null;
                }
            },

            savePreferences() {
                // If user enabled DoNotSellShare, force-disable advertising
                if (this.preferences.doNotSellShare) {
                    this.preferences.advertising = false;
                }

                const payload = {
                    version: this.consentVersion,
                    savedAt: new Date().toISOString(),
                    preferences: this.preferences,
                };

                localStorage.setItem(this.storageKey, JSON.stringify(payload));

                this.consentGiven = true;
                this.applyPreferences();
                this.openPreferences = false;
            },

            acceptAll() {
                this.preferences.performance = true;
                this.preferences.analytics = true;
                this.preferences.functional = true;
                this.preferences.personalization = true;

                // Advertising still respects DoNotSellShare
                this.preferences.doNotSellShare = false;
                this.preferences.advertising = true;

                this.savePreferences();
            },

            rejectAll() {
                this.preferences.performance = false;
                this.preferences.analytics = false;
                this.preferences.functional = false;
                this.preferences.personalization = false;
                this.preferences.advertising = false;

                // Banking-safe default
                this.preferences.doNotSellShare = true;

                this.savePreferences();
            },

            resetPreferences() {
                localStorage.removeItem(this.storageKey);
                this.consentGiven = false;

                this.preferences = {
                    performance: false,
                    analytics: false,
                    functional: false,
                    personalization: false,
                    advertising: false,
                    doNotSellShare: true,
                };
            },

            applyPreferences() {
                // Apply feature flags
                this.applyFunctional();
                this.applyPerformance();
                this.applyAnalytics();
                this.applyPersonalization();
                this.applyAdvertising();
            },

            // ===== Categories =====

            applyFunctional() {
                if (!this.preferences.functional) return;

                // Example: enable stored theme preference
                document.documentElement.classList.add("cookies-functional-enabled");
            },

            applyPerformance() {
                if (!this.preferences.performance) return;

                // Example: basic performance beacon
                if (window.__perfLoaded) return;
                window.__perfLoaded = true;

                // You can plug in your internal monitoring tool here
                // Example placeholder:
                // console.log("Performance monitoring enabled");
            },

            applyAnalytics() {
                if (!this.preferences.analytics) return;

                if (window.__gaLoaded) return;
                window.__gaLoaded = true;

                const s = document.createElement("script");
                s.src = "https://www.googletagmanager.com/gtag/js?id=G-XXXXXXX";
                s.async = true;
                document.head.appendChild(s);

                window.dataLayer = window.dataLayer || [];
                function gtag() { dataLayer.push(arguments); }

                gtag("js", new Date());
                gtag("config", "G-XXXXXXX", {
                    anonymize_ip: true,
                });
            },

            applyPersonalization() {
                if (!this.preferences.personalization) return;

                // Example: allow personalization features
                document.documentElement.classList.add("cookies-personalization-enabled");
            },

            applyAdvertising() {
                // If doNotSellShare is ON, advertising must be OFF
                if (this.preferences.doNotSellShare) return;
                if (!this.preferences.advertising) return;

                if (window.__adsLoaded) return;
                window.__adsLoaded = true;

                // Example placeholder (keep disabled in banks usually)
                console.log("Advertising enabled");
            },
        };
    }
</script>
