<footer
    class=" w-full border-t border-white/10 dark:border-gray-700/50 bg-white/70 dark:bg-gray-900/60 backdrop-blur-md">
    <div class="max-w-7xl mx-auto px-6 py-5">

        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4">

            {{-- LEFT --}}
            <div class="flex flex-col gap-1 text-center md:text-left">
                <p class="text-sm text-gray-500 dark:text-gray-400">
                    © {{ now()->year }}
                    <span class="font-semibold text-gray-700 dark:text-gray-200">
                        {{ config('app.name') }}
                    </span>.
                    All rights reserved.
                </p>

                <p class="text-xs text-gray-400 dark:text-gray-500">
                    Version: <span class="font-semibold text-gray-600 dark:text-gray-300">
                        {{ config('app.version', '1.0.0') }}
                    </span>
                </p>
            </div>


            {{-- RIGHT --}}
            <div class="flex flex-col md:flex-row items-center gap-3 justify-center md:justify-end">

                {{-- Logged in --}}
                <div class="text-xs text-gray-500 dark:text-gray-400">
                    Last login:
                    <span class="font-semibold text-gray-700 dark:text-gray-200">
                        {{ Auth::guard('admin')->user()?->last_login_at?->format('d M Y, H:i') ?? '—' }}
                    </span>
                </div>



                {{-- Back to top --}}
                <button onclick="window.scrollTo({ top: 0, behavior: 'smooth' })"
                    class="inline-flex items-center gap-2 px-3 py-1.5 rounded-full text-xs font-semibold
                           bg-sky-50 text-sky-700 hover:bg-sky-100
                           dark:bg-sky-900/30 dark:text-sky-300 dark:hover:bg-sky-900/50
                           ring-1 ring-sky-200 dark:ring-sky-700 transition">
                    <x-flux::icon.chevron-up class="w-4 h-4" />
                    Back to top
                </button>
            </div>
        </div>


    </div>
</footer>


