<x-slot:title>
    {{ config('app.name') }} || Fund Your Account
</x-slot:title>

<div class="py-3 space-y-5">

    {{-- Empty State --}}
    @if ($paymentMethods->isEmpty())
        <x-deposit.empty-state />
    @else
        {{-- Payment Methods Section --}}
        <div class="space-y-4">
            @include('partials.transfer-methods', [
                'paymentMethods' => $paymentMethods,
                'title' => 'Choose a deposit Method',
            ])

            {{-- Selected Method Form --}}
            @if ($selectedMethod)
                @php $current = $paymentMethods->firstWhere('id', $selectedMethod); @endphp
                <x-payment-method-card :method="$current" :selected="true" />

                <div class="relative overflow-hidden rounded-2xl bg-white dark:bg-gray-900 shadow-lg">
                    <x-instruction-list :instructions="$instructions" title="Deposit Instructions" icon="send" />
                    <div class="p-5 space-y-4">

                        {{-- Details --}}
                        <x-details-grid :details="$details" />

                        {{-- Deposit Form --}}
                        <form wire:submit.prevent="submitPayment" class="space-y-4" enctype="multipart/form-data">

                            {{-- Deposit Type Toggle --}}
                            <x-flux::button.group>
                                <flux:button type="button" size="sm" color="sky"
                                    variant="{{ $depositType === 'fiat' ? 'primary' : 'outline' }}"
                                    wire:click="switchDepositType('fiat')" class="w-24">
                                    Fiat
                                </flux:button>

                                <flux:button type="button" size="sm" color="sky"
                                    variant="{{ $depositType === 'crypto' ? 'primary' : 'outline' }}"
                                    wire:click="switchDepositType('crypto')" class="w-24">
                                    Crypto
                                </flux:button>
                            </x-flux::button.group>

                            {{-- Account Selection --}}
                            @if ($depositType === 'fiat')
                                <x-select wire:model="selectedAccount" label="Select Account"
                                    placeholder="Choose Account">
                                    @foreach ($userAccounts as $account)
                                        <option value="{{ $account->id }}">
                                            {{ $account->bank_account_type }} - {{ $account->masked_account_number }}
                                            {{ $currencySymbol }}{{ number_format($account->available_balance, 2) }}
                                        </option>
                                    @endforeach
                                </x-select>
                            @else
                                <x-select wire:model="selectedUserCryptoBalance" label="Select Your Crypto Balance"
                                    placeholder="Choose your wallet">
                                    @foreach ($this->userCryptoOptions as $id => $label)
                                        <option value="{{ $id }}">{{ $label }}</option>
                                    @endforeach
                                </x-select>
                            @endif

                            {{-- Amount Input --}}
                            <x-deposit.amount-selector :currencySymbol="$currencySymbol" :amount="$amount" />
                            {{-- Payment Proof --}}
                            @php
                                // Check if any dynamic field is a file
                                $hasFileField = collect($fields)->contains(fn($f) => $f['type'] === 'file');
                            @endphp

                            {{-- Show default Payment Proof only if there is no file field --}}
                            @if (empty($fields) || !$hasFileField)
                                <x-ui.custom-file-upload model="proof" label="Upload Proof"
                                    accepted-file-types="image/*" />
                            @endif
                            {{-- Dynamic File & Text Fields --}}
                            <x-deposit.dynamic-fields :fields="$fields" :fieldValues="$fieldValues" :dynamicUploads="$dynamicUploads" />

                            {{-- Crypto Wallet Section --}}
                            @if (strtolower($current->name) === 'crypto' && !empty($paymentMethodWallets))
                                <x-deposit.crypto-wallet :wallets="$paymentMethodWallets" :selectedCoin="$selectedPaymentMethodCoin" :walletAddress="$walletAddress"
                                    :walletQrCode="$walletQrCode" />
                            @endif

                            @include('partials.errors')

                            {{-- Fee & Total --}}
                            <x-deposit.fee-total :charge="$charge" :total="$total" :currencySymbol="$currencySymbol"
                                :amountEntered="strlen($amount ?? '') > 0" />

                            {{-- Submit Button --}}
                            <x-flux::button type="submit" variant="primary" color="sky" class="w-full">
                                Deposit
                            </x-flux::button>

                        </form>
                    </div>
                </div>
            @endif
        </div>
    @endif

</div>
