<x-slot:title>
    {{ config('app.name') }} || Customer Dashboard
</x-slot:title>

<div class="py-3 space-y-4">

    <div class="mb-4">
        @php $filters = [ 'all' => 'All', 'yesterday' => 'Yesterday', 'this_week' => 'This Week', 'last_week' => 'Last Week', 'this_month' => 'This Month', 'last_month' => 'Last Month' ]; @endphp
        <!-- Desktop buttons -->
        <div class="hidden sm:inline-flex flex-wrap rounded-xl bg-gray-200 dark:bg-zinc-800 p-1"
            wire:transition="content">
            @foreach ($filters as $key => $label)
                <button wire:click="updateFilter('{{ $key }}')" wire:loading.class="opacity-50"
                    class="px-4 py-1.5 text-sm font-medium rounded-lg transition-all duration-200
                    {{ $filter === $key
                        ? 'bg-white dark:bg-zinc-900 text-sky-600 shadow-sm'
                        : 'text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white' }}">
                    {{ $label }}
                </button>
            @endforeach
        </div>

        <!-- Mobile dropdown -->
        <div class="sm:hidden " x-data="{ open: false }">
            <button @click="open = !open" class="p-2 rounded-full border-2  hover:bg-gray-300 dark:hover:bg-zinc-700">
                <!-- Three dots icon -->
                <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6 text-gray-600 dark:text-gray-400" fill="none"
                    viewBox="0 0 24 24" stroke="currentColor">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                        d="M12 6v.01M12 12v.01M12 18v.01" />
                </svg>
            </button>

            <!-- Dropdown menu -->
            <div x-show="open" x-cloak @click.away="open = false" x-transition:enter="transition ease-out duration-200"
                x-transition:enter-start="opacity-0 scale-95" x-transition:enter-end="opacity-100 scale-100"
                x-transition:leave="transition ease-in duration-150" x-transition:leave-start="opacity-100 scale-100"
                x-transition:leave-end="opacity-0 scale-95"
                class="mt-2 bg-gray-200 dark:bg-zinc-800 rounded-xl shadow-lg py-2 w-40 absolute z-10">
                @foreach ($filters as $key => $label)
                    <button @click="open = false; $wire.updateFilter('{{ $key }}')"
                        class="block w-full text-left px-4 py-2 text-sm text-gray-600 dark:text-gray-400 hover:bg-gray-300 dark:hover:bg-zinc-700 rounded-lg
                        {{ $filter === $key ? 'font-semibold text-sky-600' : '' }}">
                        {{ $label }}
                    </button>
                @endforeach
            </div>
        </div>
    </div>

    <div class="space-y-5">
        <p class="text-sm text-gray-500 dark:text-gray-400 mb-2">
            Showing: <span class="font-semibold">{{ ucfirst(str_replace('_', ' ', $filter)) }}</span>
        </p>

        @include('partials.ui-card')

    </div>

    <div class="grid grid-cols-1 md:grid-cols-3 w-full gap-4">
        <div class="md:col-span-2 flex flex-col space-y-4">
            @include('partials.quick-account')
            <div
                class="bg-white dark:bg-gray-800 rounded-xl p-4 shadow-sm dark:shadow-gray-900/25 border border-gray-100 dark:border-gray-700">
                <h3 class="text-base font-semibold text-gray-900 dark:text-white mb-4">Quick Actions</h3>
                <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
                    <a href="{{ route('user.local.transfer') }}"
                        class="flex flex-col items-center p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <div class="w-10 h-10 bg-sky-500 rounded-lg flex items-center justify-center mb-2">
                            <x-flux::icon.arrows-right-left variant="solid" class="w-5 h-5 text-white" />
                        </div>
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Transfer</span>
                    </a>
                    <a href="{{ route('user.international.transfer') }}"
                        class="flex flex-col items-center p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <div class="w-10 h-10 bg-green-500 rounded-lg flex items-center justify-center mb-2">
                            <x-flux::icon.clipboard-document variant="solid" class="w-5 h-5 text-white" />
                        </div>
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Pay Bills</span>
                    </a>
                    <a href="{{ route('user.deposit') }}"
                        class="flex flex-col items-center p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <div class="w-10 h-10 bg-sky-800 rounded-lg flex items-center justify-center mb-2">
                            <x-flux::icon.currency-dollar variant="solid" class="w-5 h-5 text-white" />
                        </div>
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Request</span>
                    </a>
                    <button type="button" @click="$dispatch('open-bank-details-modal')"
                        class="flex flex-col items-center p-3 rounded-lg hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors">
                        <div class="w-10 h-10 bg-sky-500 rounded-lg flex items-center text-white justify-center mb-2">
                            <x-flux::icon.building-library variant="solid" class="w-5 h-5" />
                        </div>
                        <span class="text-xs font-medium text-gray-700 dark:text-gray-300">Bank Details</span>
                    </button>

                    {{-- BANK DETAILS MODAL --}}
                    <x-modal @open-bank-details-modal.window="openModal()" @close-bank-details-modal.window="close()">
                        <div class="space-y-6">

                            <!-- Header -->
                            <div class="text-center space-y-2">
                                <div
                                    class="w-12 h-12 bg-sky-800 rounded-xl mx-auto flex items-center justify-center text-white">
                                    <x-flux::icon.building-library class="w-5 h-5" />
                                </div>
                                <h2 class="text-base font-semibold tracking-wide capitalize">Bank Account Details</h2>
                                <span class="text-sm text-gray-600 dark:text-sky-200">{{ config('app.name') }}</span>
                            </div>

                            <!-- Account Information -->
                            <div class="space-y-4">

                                <!-- Section Header -->
                                <div class="flex items-center gap-2 text-sky-600">
                                    <x-flux::icon.information-circle class="w-5 h-5" />
                                    <h3 class="font-semibold tracking-wide text-sm">Account Information</h3>
                                </div>

                                <!-- Account Fields -->
                                <div class="grid grid-cols-1 gap-4">

                                    <!-- Account Name -->
                                    <div x-data="{ copied: false }"
                                        class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">
                                        <h4 class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">
                                            Account Name</h4>
                                        <div class="flex items-center justify-between">
                                            <span class="font-medium">{{ $authUser->name }}</span>
                                            <button
                                                @click="
                                                navigator.clipboard.writeText('{{ $authUser->name }}').then(() => {
                                                    copied = true;
                                                    setTimeout(() => copied = false, 2000);
                                                })
                                            "
                                                class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">
                                                <template x-if="!copied">
                                                    <x-flux::icon.clipboard-document class="w-5 h-5" />
                                                </template>
                                                <template x-if="copied">
                                                    <x-flux::icon.check class="w-5 h-5 text-green-500" />
                                                </template>
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Account Number -->
                                    <div x-data="{ copied: false }"
                                        class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">
                                        <h4 class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">
                                            Account Number
                                        </h4>
                                        <div class="flex items-center justify-between">
                                            <span
                                                class="font-medium">{{ $this->getFocusedAccount()->account_number }}</span>
                                            <button
                                                @click="
                                                navigator.clipboard.writeText('{{ $this->getFocusedAccount()->account_number }}').then(() => {
                                                    copied = true;
                                                    setTimeout(() => copied = false, 2000);
                                                })
                                            "
                                                class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">
                                                <template x-if="!copied">
                                                    <x-flux::icon.clipboard-document class="w-5 h-5" />
                                                </template>
                                                <template x-if="copied">
                                                    <x-flux::icon.check class="w-5 h-5 text-green-500" />
                                                </template>
                                            </button>
                                        </div>
                                    </div>

                                    <!-- Bitcoin Wallet -->
                                    @foreach ($userCryptoBalances as $crypto)
                                        <div x-data="{ copied: false }"
                                            class="bg-white dark:bg-gray-700 p-3 rounded-lg shadow-sm flex flex-col gap-2">

                                            <h4
                                                class="text-xs text-gray-500 dark:text-sky-200 uppercase tracking-wide">
                                                {{ $crypto->label() }} Wallet
                                            </h4>

                                            <div class="flex items-center justify-between">
                                                {{-- Show available balance --}}
                                                <span class="font-medium truncate">
                                                    {{ $crypto->available_balance }} {{ strtoupper($crypto->code) }}
                                                </span>

                                                {{-- Copy button --}}
                                                <button
                                                    @click="
                    navigator.clipboard.writeText('{{ $crypto->available_balance }}').then(() => {
                        copied = true;
                        setTimeout(() => copied = false, 2000);
                    })
                "
                                                    class="text-sky-600 hover:text-sky-800 dark:hover:text-white transition flex items-center">

                                                    <template x-if="!copied">
                                                        <x-flux::icon.clipboard-document class="w-5 h-5" />
                                                    </template>

                                                    <template x-if="copied">
                                                        <x-flux::icon.check class="w-5 h-5 text-green-500" />
                                                    </template>
                                                </button>
                                            </div>

                                            {{-- Other balances --}}
                                            <div class="space-y-2 text-sm mt-2">
                                                <div class="flex justify-between text-gray-500">
                                                    <span>Total</span>
                                                    <span class="font-medium text-gray-800 dark:text-gray-200">
                                                        {{ $crypto->balance }}
                                                    </span>
                                                </div>

                                                <div class="flex justify-between text-gray-500">
                                                    <span>Locked</span>
                                                    <span class="font-medium text-yellow-500">
                                                        {{ $crypto->locked_balance }}
                                                    </span>
                                                </div>
                                            </div>

                                            {{-- Footer: Rate --}}
                                            <div
                                                class="mt-4 pt-3 border-t border-gray-200 dark:border-gray-700 flex items-center justify-between text-xs">
                                                <span class="text-gray-500">Rate</span>
                                                <span class="font-semibold text-gray-800 dark:text-gray-200">
                                                    ${{ number_format((float) $crypto->getRate(), 2) }}
                                                </span>
                                            </div>
                                        </div>
                                    @endforeach


                                </div>

                            </div>

                            <!-- Security Notice -->
                            <div
                                class="bg-gray-100 dark:bg-gray-700 p-4 rounded-lg flex flex-col sm:flex-row gap-3 items-start sm:items-center shadow-sm">
                                <x-flux::icon.shield-check class="w-5 h-5 text-green-500 shrink-0" />
                                <div class="space-y-1">
                                    <h3 class="font-semibold text-sm tracking-wide">Security Notice</h3>
                                    <p class="text-xs text-gray-600 dark:text-sky-200 leading-relaxed">
                                        Always contact <strong>{{ config('app.name') }}</strong> Support before making
                                        payments to
                                        verify account details.
                                    </p>
                                </div>
                            </div>

                            <div class="flex items-end justify-end">
                                <button type="button" @click="$dispatch('close-bank-details-modal')"
                                    class=" bg-red-700 text-white shadow-lg text-xs font-medium rounded-full p-2 hover:bg-red-600 hover:scale-110 transition-transform duration-150 flex items-center justify-center focus:outline-none focus:ring-2 focus:ring-red-400 capitalize">
                                    <x-flux::icon.x-mark class="w-5 h-5" />
                                    <span>cancel</span>
                                </button>
                            </div>
                        </div>

                        {{-- Bank details content --}}
                    </x-modal>
                </div>
            </div>

            <div
                class="bg-white dark:bg-gray-800 rounded-xl p-4 shadow-sm dark:shadow-gray-900/25 border border-gray-100 dark:border-gray-700">
                <div class="flex justify-between items-center mb-4">
                    <h3 class="text-base font-semibold text-gray-900 dark:text-white">Quick Transfer</h3>
                    <a href="{{ route('user.local.transfer') }}"
                        class="text-xs text-primary-600 dark:text-primary-400 font-medium flex items-center hover:text-primary-700 dark:hover:text-primary-300 transition-colors">
                        View All
                        <x-flux::icon.chevron-down variant="solid" class="w-4 h-4" />
                    </a>
                </div>

                <div class="flex space-x-3 overflow-x-auto pb-2">
                    <!-- Add New Beneficiary -->
                    <a href="{{ route('user.local.transfer') }}"
                        class="shrink-0 flex flex-col items-center justify-center group">
                        <div
                            class="w-16 h-16 rounded-full border-2 border-dashed border-gray-300 dark:border-gray-600 bg-gray-50 dark:bg-gray-800 flex items-center justify-center mb-2 group-hover:bg-gray-100 dark:group-hover:bg-gray-700 group-hover:border-primary-400 dark:group-hover:border-primary-500 transition-all duration-200">
                            <x-flux::icon.plus variant="solid" class="w-5 h-5" />
                        </div>
                        <span
                            class="text-xs text-gray-500 dark:text-gray-400 text-center group-hover:text-primary-600 dark:group-hover:text-primary-400 transition-colors">
                            Add New
                        </span>
                    </a>

                    <!-- Beneficiaries List -->
                    @forelse ($this->recentBeneficiaries as $beneficiary)
                        <div class="shrink-0 flex flex-col items-center justify-center group relative">
                            <div
                                class="relative w-16 h-16 rounded-full flex items-center justify-center mb-2 border-2 border-white dark:border-gray-800 shadow-sm dark:shadow-gray-900/25 hover:scale-105 transition-all duration-200 {{ $beneficiary->color }}">
                                <span class="text-white font-semibold text-base">{{ $beneficiary->initials }}</span>
                            </div>

                            <span class="text-xs text-gray-700 dark:text-gray-300 text-center max-w-16 truncate">
                                {{ $beneficiary->name }}
                            </span>
                        </div>
                    @empty
                        <!-- Empty State -->
                        <div class="shrink-0 flex flex-col items-center justify-center py-6 px-8">
                            <div
                                class="w-16 h-16 rounded-full bg-gray-100 dark:bg-gray-700 flex items-center justify-center mb-3">
                                <x-flux::icon.user-group variant="solid" class="w-5 h-5" />
                            </div>
                            <p class="text-sm text-gray-500 dark:text-gray-400 text-center">No saved beneficiaries</p>
                            <p class="text-xs text-gray-400 dark:text-gray-500 text-center mt-1">Add one to get started
                            </p>
                        </div>
                    @endforelse
                </div>
            </div>

            @include('partials.quick-show')

            @include('partials.credit-card-swiper')
        </div>

        <!-- Right Column (future content) -->
        <div class="space-y-4 md:col-span-1 flex flex-col">
            <!-- Right Column (future content) -->
            @include('partials.recent-transaction-dashboard', [
                'latestTransactions' => $latestTransactions,
                'viewAllUrl' => route('user.transactions'),
            ])

            @include('partials.statistic')

            <div class="md:hidden">
                @include('partials.metrics-card')
            </div>

            @include('partials.contact-card')

            <!-- Referral Link & Sharing -->
            <section class="bg-white dark:bg-gray-900 rounded-xl shadow-sm p-6">
                <h2 class="text-xl font-semibold text-gray-800 dark:text-gray-200 mb-4">Your Referral Link</h2>

                <!-- Referral Input + Copy Button -->
                <div x-cloak x-data="{ copied: false }"
                    class="flex flex-col md:flex-row items-stretch md:items-center flex-wrap gap-3">
                    <div class="relative flex-1">
                        <input x-ref="referralInput" type="text" readonly
                            class="w-full px-4 py-2 rounded-lg border border-gray-300 dark:border-gray-700 bg-gray-100 dark:bg-gray-800 text-gray-800 dark:text-gray-100 focus:outline-none focus:ring-2 focus:ring-sky-500"
                            :value="'{{ url('/registration?ref=' . $authUser->referral_code) }}'" />
                    </div>
                    <button
                        @click="
                const input = $refs.referralInput;
                input.select();
                input.setSelectionRange(0, 99999); // For mobile
                try {
                    const success = document.execCommand('copy');
                    copied = success;
                    setTimeout(() => copied = false, 2000);
                } catch(e) {
                    alert('Failed to copy text.');
                }
            "
                        class="px-5 py-2 rounded-lg bg-sky-600 hover:bg-sky-700 text-white font-semibold transition focus:outline-none focus:ring-2 focus:ring-sky-400">
                        <span x-text="copied ? 'Copied!' : 'Copy Link'"></span>
                    </button>
                </div>

                <!-- Metrics Section -->
                <div class="mt-8  grid md:hidden grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6 text-center text-sm">
                    <!-- Referral Growth -->
                    <div
                        class="bg-gray-50 dark:bg-gray-800 p-5 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm hover:shadow transition">
                        <x-flux::icon.arrow-trending-up class="w-6 h-6 mx-auto text-sky-500 mb-2" />
                        <p class="text-2xl font-semibold text-gray-900 dark:text-gray-100">
                            {{ $authUser->referralGrowth ?? 0 }}%</p>
                        <p class="text-gray-600 dark:text-gray-400">Referral Growth</p>
                    </div>

                    <!-- Total Referral Earnings -->
                    <div
                        class="bg-gray-50 dark:bg-gray-800 p-5 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm hover:shadow transition">
                        <x-flux::icon.banknotes class="w-6 h-6 mx-auto text-green-500 mb-2" />
                        <p class="text-2xl font-semibold text-gray-900 dark:text-gray-100">
                            {{ $currencySymbol }} {{ number_format($authUser->referralEarnings(), 2) }}
                        </p>
                        <p class="text-gray-600 dark:text-gray-400">Total Referral Earnings</p>
                    </div>

                    <!-- Total Referrals -->
                    <div
                        class="bg-gray-50 dark:bg-gray-800 p-5 rounded-lg border border-gray-200 dark:border-gray-700 shadow-sm hover:shadow transition">
                        <x-flux::icon.user-group class="w-6 h-6 mx-auto text-yellow-500 mb-2" />
                        <p class="text-2xl font-semibold text-gray-900 dark:text-gray-100">
                            {{ $authUser->referrals()->count() }}
                        </p>
                        <p class="text-gray-600 dark:text-gray-400">Total Referrals</p>
                    </div>
                </div>
            </section>

        </div>
    </div>

</div>
