<x-slot:title>
    {{ config('app.name') }} || Internal Transfer
</x-slot:title>

<div class="py-3 space-y-5">

    @if ($paymentMethods->isEmpty())
        {{-- ================= Empty State ================= --}}
        <x-deposit.empty-state title="Other Bank Transfer" />
    @else
        {{-- Payment Methods Section --}}
        <div class="space-y-4">

            {{-- Selected Method Card --}}
            @if ($selectedMethod)
                @php
                    $current = $paymentMethods->firstWhere('id', $selectedMethod);
                @endphp

                <div class="flex items-center justify-between">
                    {{-- Header --}}

                    <x-payment-method-card :method="$current" :selected="true" />

                    {{-- Back Button --}}
                    <div class=" justify-end items-end hidden md:flex">
                        <a href="{{ route('user.dashboard') }}"
                            class="inline-flex items-center gap-2 text-sky-600 dark:text-sky-400 hover:text-sky-800 dark:hover:text-sky-300 font-semibold transition">
                            <x-flux::icon.arrow-left class="w-5 h-5" />
                            Back to Dashboard
                        </a>
                    </div>
                </div>

                <div x-data x-cloak x-show="$wire.selectedMethod !== null"
                    x-transition:enter="transition ease-out duration-300"
                    x-transition:enter-start="opacity-0 translate-y-4 scale-95"
                    x-transition:enter-end="opacity-100 translate-y-0 scale-100"
                    x-transition:leave="transition ease-in duration-200"
                    x-transition:leave-start="opacity-100 translate-y-0 scale-100"
                    x-transition:leave-end="opacity-0 translate-y-4 scale-95"
                    class="relative overflow-hidden rounded-2xl bg-white dark:bg-gray-800 shadow-lg">

                    {{-- Body --}}
                    <div>

                        {{-- ================= Instructions ================= --}}
                        <x-instruction-list :instructions="$instructions" title="Other Bank Transfer Instructions" icon="send" />

                        {{-- International transfer --}}
                        <livewire:pages::user.transfer.beneficiaries-card wire:key="beneficiaries-card-international"
                            :transferType="\App\Models\Beneficiary::INTERNATIONAL" />

                        <div class="p-5 space-y-3">
                            {{-- ================= Details ================= --}}
                            <x-details-grid :details="$details" />
                            <form wire:submit.prevent="validateAndShowConfirmation" class="space-y-4">
                                {{-- Account Limits --}}
                                @if ($selectedAccount)
                                    <div wire:key="account-limits-{{ $selectedAccount }}" class="mb-4">
                                        <x-account.limits :account="$accounts->firstWhere('id', $selectedAccount)" />
                                    </div>
                                @endif

                                <div>
                                    <x-select wire:model.live.blur="selectedAccount" label="Select Account"
                                        placeholder="Select Account">
                                        @foreach ($accounts as $account)
                                            <option value="{{ $account->id }}">
                                                {{ $account->bank_account_type }} -
                                                {{ $account->masked_account_number }}
                                                -
                                                {{ $currencySymbol }}{{ number_format($account->available_balance, 2) }}
                                            </option>
                                        @endforeach
                                    </x-select>
                                </div>

                                {{-- Amount Input --}}
                                <x-deposit.amount-selector :currencySymbol="$currencySymbol" :amount="$amount" />

                                {{-- Dynamic File & Text Fields --}}
                                <x-deposit.dynamic-fields :fields="$fields" :fieldValues="$fieldValues" :dynamicUploads="$dynamicUploads" />

                                @if ($pinMissing)
                                    <p class="mt-1 text-sm text-red-600 dark:text-red-400 flex items-center gap-1">
                                        <x-flux::icon name="exclamation-circle" class="h-4 w-4" />
                                        Transaction PIN not set.
                                    </p>
                                    <x-flux::button variant="primary" color="sky"
                                        @click="$dispatch('open-pin-modal')">Set
                                        PIN</x-flux::button>
                                @endif

                                @include('partials.errors')

                                {{-- Fee & Total --}}
                                <x-deposit.fee-total :charge="$fee" :total="$total" :currencySymbol="$currencySymbol"
                                    :amountEntered="strlen($amount ?? '') > 0" />

                                <div>
                                    <x-button type="submit" class="disabled:cursor-not-allowed bg-gray-400"
                                        :disabled="$pinMissing">
                                        Review & Continue
                                    </x-button>

                                </div>
                            </form>

                            <x-confirmation-modal :accounts="$accounts" :paymentMethods="$paymentMethods" :prevalidatedData="$prevalidatedData"
                                :currencySymbol="$currencySymbol" />

                            <x-pin-modal />
                        </div>

                    </div>
                </div>
            @endif
            {{-- Example usage in any Blade file --}}
            @include('partials.transfer-methods', [
                'paymentMethods' => $paymentMethods,
                'title' => 'Select a Transfer Method',
            ])

        </div>
    @endif

</div>
