<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<meta name="robots" content="noindex, nofollow">

<head>
    @include('partials.head')
</head>

<body class="min-h-screen bg-white antialiased dark:bg-neutral-900">
    @livewire('ui.toast')

    <x-ui.session-toast />
    <div class="min-h-screen flex flex-col md:flex-row bg-gray-100 dark:bg-gray-950">
        {{-- Optional Background Column --}}
        @if ($withBackground ?? true)
            <div
                class="hidden md:flex md:w-1/2 relative overflow-hidden bg-linear-300 from-sky-600 to-sky-900 items-center justify-center">

                {{-- Always visible background/animated circles --}}
                @if (isset($backgroundImage))
                    <img src="{{ $backgroundImage }}" alt="Background" class="absolute inset-0 w-full h-full object-cover">
                @else
                    <div class="absolute w-96 h-96 bg-gray-50/20 rounded-full animate-bounce-slow top-10 left-10">
                    </div>
                    <div
                        class="absolute w-72 h-72 bg-white/20 rounded-full animate-bounce-slow-slower bottom-20 right-20">
                    </div>
                    <div
                        class="absolute w-72 h-72 bg-white/20 rounded-full animate-bounce-slow-slower left-20 right-20">
                    </div>
                @endif

                {{-- Conditional content based on route (on top of background) --}}
                @php
                    $currentRoute = Route::currentRouteName();
                @endphp

                <div class="absolute inset-0 flex items-center justify-center p-10">
                    @if ($currentRoute === 'user.register')
                        {{-- Content for Registration --}}
                        <div class="text-center text-white">
                            <h1 class="text-4xl font-bold mb-4">Welcome to Registration!</h1>
                            <p class="text-sm mb-8 max-w-md text-center text-white/80 leading-relaxed">
                                Start your financial journey with {{ config('app.name') }}. Secure, fast, and reliable
                                banking at your fingertips.
                            </p>
                            <!-- Features Grid -->
                            <div class="grid grid-cols-2 gap-4 w-full max-w-md">
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.shield-check class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Secure Platform</h3>
                                        <p class="text-xs text-white/70">Bank-grade security</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.bolt class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Fast Transfers</h3>
                                        <p class="text-xs text-white/70">Instant payments</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.clock class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">24/7 Access</h3>
                                        <p class="text-xs text-white/70">Always available</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.globe-alt class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Global Banking</h3>
                                        <p class="text-xs text-white/70">Worldwide access</p>
                                    </div>
                                </div>
                            </div>
                            <a href="{{ route('home') }}"
                                class="bg-white px-4 py-2 mt-4 text-black text-sm font-medium capitalize flex items-center gap-3 w-fit mx-auto justify-center">
                                <x-flux::icon.arrow-turn-down-left class="w-4 h-4" />
                                <span>Return Home</span>
                            </a>
                        </div>
                    @elseif ($currentRoute === 'login')
                        {{-- Content for Login --}}
                        <div class="text-center text-white">
                            <h1 class="text-4xl font-bold mb-4">Welcome Back!</h1>
                            <p class="text-sm mb-8 max-w-md text-center text-white/80 leading-relaxed">
                                Welcome back to {{ config('app.name') }}. Securely access your account and manage your
                                finances with confidence.
                            </p>
                            <!-- Features Grid -->
                            <div class="grid grid-cols-2 gap-4 w-full max-w-md">
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.shield-check class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Secure Platform</h3>
                                        <p class="text-xs text-white/70">Bank-grade security</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.bolt class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Fast Transfers</h3>
                                        <p class="text-xs text-white/70">Instant payments</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.clock class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">24/7 Access</h3>
                                        <p class="text-xs text-white/70">Always available</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.globe-alt class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Global Banking</h3>
                                        <p class="text-xs text-white/70">Worldwide access</p>
                                    </div>
                                </div>
                            </div>
                            <a href="{{ route('home') }}"
                                class="bg-white px-4 py-2 mt-4 text-black text-sm font-medium capitalize flex items-center gap-3 w-fit mx-auto justify-center">
                                <x-flux::icon.arrow-turn-down-left class="w-4 h-4" />
                                <span>Return Home</span>
                            </a>
                        </div>
                    @elseif ($currentRoute === 'onboarding')
                        {{-- Content for Onboarding --}}
                        <div class="text-center text-white">
                            <h1 class="text-4xl font-bold mb-4">Welcome Onboard!</h1>
                            <p class="text-sm mb-8 max-w-md text-center text-white/80 leading-relaxed">
                                Welcome back to {{ config('app.name') }}. Enter your details below to create your
                                account
                            </p>
                            <!-- Features Grid -->
                            <div class="grid grid-cols-2 gap-4 w-full max-w-md">
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.shield-check class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Secure Platform</h3>
                                        <p class="text-xs text-white/70">Bank-grade security</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.bolt class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Fast Transfers</h3>
                                        <p class="text-xs text-white/70">Instant payments</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.clock class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">24/7 Access</h3>
                                        <p class="text-xs text-white/70">Always available</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.globe-alt class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Global Banking</h3>
                                        <p class="text-xs text-white/70">Worldwide access</p>
                                    </div>
                                </div>
                            </div>
                            {{-- Logout Button --}}
                            <form method="POST" action="{{ route('user.logout') }}" class="mt-4">
                                @csrf
                                <button type="submit"
                                    class="bg-red-800 px-4 py-2 text-white cursor-pointer text-sm font-medium capitalize flex items-center gap-3 w-fit mx-auto justify-center">
                                    <x-flux::icon.arrow-left-end-on-rectangle class="w-4 h-4" />
                                    <span>Logout</span>
                                </button>
                            </form>
                        </div>
                    @elseif ($currentRoute === 'admin.login')
                        {{-- Content for Onboarding --}}
                        <div class="text-center text-white">
                            <h1 class="text-4xl font-bold mb-4">Welcome Back, Admin!</h1>
                            <p class="text-sm mb-8 max-w-md text-center text-white/80 leading-relaxed">
                                Welcome back to {{ config('app.name') }}. Securely Access Your Admin Dashboard
                            </p>
                            <!-- Features Grid -->
                            <div class="grid grid-cols-2 gap-4 w-full max-w-md">
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.shield-check class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Secure Platform</h3>
                                        <p class="text-xs text-white/70">Bank-grade security</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.bolt class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Fast Transfers</h3>
                                        <p class="text-xs text-white/70">Instant payments</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.clock class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">24/7 Access</h3>
                                        <p class="text-xs text-white/70">Always available</p>
                                    </div>
                                </div>
                                <div
                                    class="group flex items-center space-x-3 p-3 rounded-xl bg-white/10 backdrop-blur-sm border border-white/20 hover:bg-white/15 transition-all duration-300">
                                    <div
                                        class="shrink-0 w-8 h-8 rounded-xl bg-white/20 flex items-center justify-center group-hover:scale-110 transition-transform">
                                        <x-flux::icon.globe-alt class="w-4 h-4 text-white" />
                                    </div>
                                    <div>
                                        <h3 class="text-sm font-semibold">Global Banking</h3>
                                        <p class="text-xs text-white/70">Worldwide access</p>
                                    </div>
                                </div>
                            </div>
                            {{-- Logout Button --}}
                            <a href="{{ route('home') }}"
                                class="bg-white px-4 py-2 text-black text-sm font-medium capitalize flex items-center gap-2 w-fit mx-auto justify-center rounded-md hover:bg-gray-100 transition">
                                <x-flux::icon.arrow-turn-down-left class="w-4 h-4" />
                                <span>Return Home</span>
                            </a>
                        </div>
                    @endif
                </div>
            </div>
        @endif

        {{-- Main Content Column --}}
        <div class="flex w-full md:w-1/2 items-center justify-center p-6 md:p-10 flex-1">
            <div class="flex flex-col w-full gap-6">
                <a href="{{ route('home') }}" class="flex flex-col items-center gap-2 font-medium">
                    <span class="flex h-9 w-9 mb-1 items-center justify-center rounded-md">
                        <x-app-logo-icon class="size-9 fill-current text-black dark:text-white" />
                    </span>
                    <span class="sr-only">{{ config('app.name', 'Laravel') }}</span>
                </a>

                <div class="flex flex-col gap-6">
                    {{ $slot }}
                </div>
            </div>
        </div>
    </div>

    @fluxScripts
</body>

</html>
