<!DOCTYPE html>
<html x-data="{
    darkMode: false,
    mobileMenuOpen: false
}" x-init="darkMode = localStorage.getItem('darkMode') === 'true' ||
    (!localStorage.getItem('darkMode') &&
        window.matchMedia('(prefers-color-scheme: dark)').matches);

$watch('darkMode', value => {
    localStorage.setItem('darkMode', value);
});" :class="{ 'dark': darkMode }" class="scroll-smooth">

<head>
    @include('partials.head')
    <script>
        if (
            localStorage.getItem('darkMode') === 'true' ||
            (!localStorage.getItem('darkMode') &&
                window.matchMedia('(prefers-color-scheme: dark)').matches)
        ) {
            document.documentElement.classList.add('dark');
        }
    </script>
</head>

<body class="min-h-screen bg-white dark:bg-zinc-800">

    <!-- PAGE CONTENT -->
    <main class="pt-36">
        {{ $slot }}
    </main>

    @fluxScripts
</body>

</html>
