<!doctype html>
<html>

<head>
    <meta charset="utf-8">

    <style>
        @page {
            margin: 20mm;
        }

        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 10px;
            color: #2c3e50;
            margin-bottom: 20mm;
        }

        .header {
            border-bottom: 2px solid #0a3d62;
            padding-bottom: 8px;
            margin-bottom: 15px;
        }

        .header-table {
            width: 100%;
        }

        .header-table td {
            vertical-align: top;
        }

        .title {
            font-size: 16px;
            font-weight: bold;
            color: #0a3d62;
        }

        .meta {
            font-size: 10px;
            text-align: right;
            color: #555;
        }

        table.statement {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
        }

        table.statement th,
        table.statement td {
            border: 1px solid #dcdcdc;
            padding: 6px 5px;
            word-break: break-word;
            vertical-align: top;
        }

        table.statement th {
            background-color: #f1f5f9;
            font-weight: bold;
            text-transform: uppercase;
            font-size: 9px;
            page-break-inside: avoid;
        }

        table.statement tbody tr:nth-child(even) {
            background-color: #fafafa;
        }

        thead {
            display: table-header-group;
        }

        tr {
            page-break-inside: avoid;
        }

        .footer {
            position: fixed;
            bottom: -10px;
            left: 0;
            right: 0;
            font-size: 9px;
            color: #7f8c8d;
            text-align: center;
        }

        .page-number:before {
            content: "Page " counter(page);
        }
    </style>
</head>

<body>

    {{-- HEADER --}}
    <div class="header">
        <table class="header-table">
            <tr>
                <td>
                    <div class="title">{{ $title }}</div>
                    <div style="font-size:10px;">Generated by System</div>
                </td>
                <td class="meta">
                    Generated: {{ now()->format('d M Y, H:i') }}
                </td>
            </tr>
        </table>
    </div>

    {{-- TABLE --}}
    <table class="statement">
        <thead>
            <tr>
                @foreach ($headings as $heading)
                    <th>{{ $heading }}</th>
                @endforeach
            </tr>
        </thead>

        <tbody>
            @foreach ($rows as $row)
                <tr>
                    @foreach ($keys as $key)
                        <td>{{ $row[$key] ?? '' }}</td>
                    @endforeach
                </tr>
            @endforeach
        </tbody>
    </table>

    {{-- FOOTER --}}
    <div class="footer">
        This document is system-generated and valid without a signature |
        <span class="page-number"></span>
    </div>

</body>

</html>
