<x-emails.layout :subject="'Ticket Created'" :headerTitle="config('app.name')" :headerUrl="route('user.dashboard')">

    <!-- Header -->
    <h1 style="margin:0 0 20px 0; font-size:28px; font-weight:700; color:#0369a1; text-align:center;">
        Support Ticket Created
    </h1>

    <!-- Greeting -->
    <p style="margin:0 0 20px 0; font-size:16px; line-height:1.6; color:#333;">
        Hello <strong>{{ $user->name }}</strong>,
    </p>

    <!-- Ticket Info -->
    <p style="margin:0 0 20px 0; font-size:16px; line-height:1.6; color:#555;">
        Your support ticket has been successfully created. Here are the details:
    </p>

    <table width="100%" cellpadding="0" cellspacing="0" style="margin-bottom:20px;">
        <tr>
            <td style="font-size:14px; color:#555; line-height:1.5;">Subject:</td>
            <td style="font-size:14px; color:#333; font-weight:600;">{{ $ticket->subject }}</td>
        </tr>
        <tr>
            <td style="font-size:14px; color:#555; line-height:1.5;">Priority:</td>
            <td style="font-size:14px; color:#333; font-weight:600;">{{ ucfirst($ticket->priority) }}</td>
        </tr>
        <tr>
            <td style="font-size:14px; color:#555; line-height:1.5;">Status:</td>
            <td style="font-size:14px; color:#333; font-weight:600;">{{ ucfirst($ticket->status) }}</td>
        </tr>
    </table>

    <!-- Message -->
    <p style="font-size:16px; line-height:1.6; color:#555;">
        We will get back to you shortly. You can view your ticket here:
    </p>

    <p style="text-align:center; margin:20px 0;">
        <a href="{{ route('user.ticket.show', $ticket->id) }}"
            style="padding:10px 20px; background-color:#0369a1; color:#fff; border-radius:5px; text-decoration:none;">
            View Ticket
        </a>
    </p>

    <!-- Footer -->
    <p style="margin-top:40px; font-size:14px; color:#555; text-align:center; line-height:1.6;">
        Thank you for choosing <strong>{{ config('app.name') }}</strong>.<br>
        &mdash; The {{ config('app.name') }} Team
    </p>

</x-emails.layout>
