<x-emails.layout :subject="$subject" :headerTitle="config('app.name')" :headerUrl="route('user.register')">
    <!-- Header Title -->
    <h1 style="margin:0 0 24px 0; font-size:26px; font-weight:700; color:#002b5c;">
        {{ $subject }}
        {{ $appName }}
    </h1>

    <!-- Greeting -->
    <p style="margin:0 0 16px 0; font-size:16px; line-height:1.6; color:#333;">
        Hello,
    </p>

    <!-- Message Body -->
    <p style="margin:0 0 28px 0; font-size:16px; line-height:1.6; color:#333;">
        {!! $messagebody !!}
    </p>

    <!-- Attachments (if any) -->
    {{-- @if (!empty($attachments) && is_array($attachments))
        <div style="margin: 20px 0;">
            <p style="font-weight:600; color:#333;">Attachments:</p>
            <ul style="padding-left: 20px; margin: 0;">
                @foreach ($attachments as $path)
                    <li>
                        <a href="{{ asset('storage/' . $path) }}" target="_blank" rel="noopener noreferrer"
                            style="color:#1d4ed8;">
                            {{ basename($path) }}
                        </a>
                    </li>
                @endforeach
            </ul>
        </div>
    @endif --}}

    <!-- Call-to-action Button -->
    @if (!empty($buttonurl))
        <div style="margin: 30px 0; text-align:center;">
            <a href="{{ $buttonurl }}" target="_blank" class="btn-primary" rel="noopener noreferrer"
                aria-label="View Details Button">
                View Details
            </a>
        </div>
    @endif

    <!-- Support Note -->
    <p style="font-size: 15px; margin-bottom: 20px; color: #555;">
        If you didn’t expect this email, you can safely ignore it or contact us at
        <a href="mailto:{{ $supportEmail }}">{{ $supportEmail }}</a>.
    </p>

    <!-- Closing -->
    <p style="margin-top: 40px; font-size: 15px; font-style: italic; color: #777;">
        Thank you,<br />
        <strong>{{ $appName }} Team</strong>
    </p>

    <!-- Footer Note -->
    <p style="margin-top:40px; font-size:15px; color:#777;">
        Thank you for choosing <strong>{{ config('app.name') }}</strong>.<br>
        — The {{ config('app.name') }} Team
    </p>
</x-emails.layout>
