<?php

use Livewire\Component;
use App\Models\Grant;

new class extends Component {
    public bool $hasPendingPersonal = false;
    public bool $hasPendingCompany = false;

    public function mount()
    {
        $user = auth()->user();

        $this->hasPendingPersonal = Grant::where('user_id', $user->id)->where('type', 'personal')->where('status', 'pending')->exists();

        $this->hasPendingCompany = Grant::where('user_id', $user->id)->where('type', 'company')->where('status', 'pending')->exists();
    }
};
?>

<div class="grid grid-cols-1 md:grid-cols-2 gap-5">

    <!-- Individual Card -->
    <div
        class="flex flex-col justify-between h-full p-6 rounded-xl shadow-md dark:shadow-none 
        {{ $hasPendingPersonal ? 'bg-gray-200 dark:bg-zinc-700 opacity-70 cursor-not-allowed' : 'bg-gray-50 dark:bg-zinc-800 border border-gray-200 dark:border-zinc-700 hover:scale-105 hover:shadow-lg transition-transform duration-300 cursor-pointer' }}">

        <div class="flex flex-col items-center text-center space-y-4">
            <div
                class="w-12 h-12 flex items-center justify-center rounded-full 
                {{ $hasPendingPersonal ? 'bg-gray-400' : 'bg-sky-500/20 group-hover:bg-sky-500/30' }}">
                <x-flux::icon.user variant="solid"
                    class="w-5 h-5 {{ $hasPendingPersonal ? 'text-gray-600' : 'text-sky-700' }}" />
            </div>
            <h2
                class="text-base md:text-lg font-semibold {{ $hasPendingPersonal ? 'text-gray-600 dark:text-gray-300' : 'text-gray-900 dark:text-gray-50' }}">
                Apply as Individual
            </h2>
            <p
                class="text-xs md:text-sm {{ $hasPendingPersonal ? 'text-gray-500 dark:text-gray-400' : 'text-gray-600 dark:text-gray-300' }}">
                For individuals seeking funding for programs, equipment, research, or community outreach.
            </p>
        </div>

        @if ($hasPendingPersonal)
            <div class="mt-4 text-center">
                <span
                    class="inline-block w-full px-4 py-2 rounded-lg bg-red-600 text-white font-medium text-sm md:text-base">
                    Pending Application
                </span>
                <p class="mt-1 text-xs text-red-500">
                    You already have a pending personal grant. Please wait for it to be processed before submitting a
                    new application.
                </p>
            </div>
        @else
            <a href="{{ route('user.grants.personal') }}"
                class="mt-4 inline-block w-full text-center px-4 py-2 rounded-lg bg-sky-600 text-white font-medium text-sm md:text-base hover:bg-sky-500 transition-colors duration-200">
                Continue
            </a>
        @endif
    </div>

    <!-- Company Card -->
    <div
        class="flex flex-col justify-between h-full p-6 rounded-xl shadow-md dark:shadow-none 
        {{ $hasPendingCompany ? 'bg-gray-200 dark:bg-zinc-700 opacity-70 cursor-not-allowed' : 'bg-gray-50 dark:bg-zinc-800 border border-gray-200 dark:border-zinc-700 hover:scale-105 hover:shadow-lg transition-transform duration-300 cursor-pointer' }}">

        <div class="flex flex-col items-center text-center space-y-4">
            <div
                class="w-12 h-12 flex items-center justify-center rounded-full 
                {{ $hasPendingCompany ? 'bg-gray-400' : 'bg-sky-500/20 group-hover:bg-sky-500/30' }}">
                <x-flux::icon.building-office variant="solid"
                    class="w-5 h-5 {{ $hasPendingCompany ? 'text-gray-600' : 'text-sky-700' }}" />
            </div>
            <h2
                class="text-base md:text-lg font-semibold {{ $hasPendingCompany ? 'text-gray-600 dark:text-gray-300' : 'text-gray-900 dark:text-gray-50' }}">
                Apply as Company
            </h2>
            <p
                class="text-xs md:text-sm {{ $hasPendingCompany ? 'text-gray-500 dark:text-gray-400' : 'text-gray-600 dark:text-gray-300' }}">
                For registered organizations with an EIN, established history, and a defined mission.
            </p>
        </div>

        @if ($hasPendingCompany)
            <div class="mt-4 text-center">
                <span
                    class="inline-block w-full px-4 py-2 rounded-lg bg-red-600 text-white font-medium text-sm md:text-base">
                    Pending Application
                </span>
                <p class="mt-1 text-xs text-red-500">
                    You already have a pending company grant. Please wait for it to be processed before submitting a new
                    application.
                </p>
            </div>
        @else
            <a href="{{ route('user.grants.company') }}"
                class="mt-4 inline-block w-full text-center px-4 py-2 rounded-lg bg-zinc-900 text-white font-medium text-sm md:text-base hover:bg-zinc-500 transition-colors duration-200">
                Continue
            </a>
        @endif
    </div>

</div>
