@props([
    'label' => null,
    'model' => null
])

@if ($label)
    <label class="block mb-2 text-sm font-medium text-gray-700 dark:text-gray-200">
        {{ $label }}
    </label>
@endif
<div x-data="{
    isDragging: false,
    fileName: null,
    filePreview: null,
    progress: 0, // ✅ new state for percentage
    uploading: false, // ✅ track if uploading
    handleFile(file) {
        const reader = new FileReader();
        reader.onload = (e) => {
            this.filePreview = e.target.result;
        };
        reader.readAsDataURL(file);
        this.fileName = file.name;
    },
    clearFile() {
        this.fileName = null;
        this.filePreview = null;
        this.progress = 0; // ✅ reset progress
        this.uploading = false; // ✅ reset uploading state
        $refs.fileInput.value = null;
        if (@this) {
            @this.set('{{ $model }}', null);
        }
        $dispatch('file-selected', { fileName: null, file: null });
    }
}" x-on:file-upload-reset.window="clearFile()" x-on:click="$refs.fileInput.click()"
    x-on:dragover.prevent="isDragging = true" x-on:dragleave.prevent="isDragging = false"
    x-on:drop.prevent="
    isDragging = false;
    const file = $event.dataTransfer.files[0];
    if (file) {
        handleFile(file);
        $refs.fileInput.files = $event.dataTransfer.files;
        @this.clearError('{{ $model }}')
        $dispatch('file-selected', { fileName: file.name, file: file });
    }
"
    x-on:livewire-upload-start.window="uploading = true"
    x-on:livewire-upload-progress.window="progress = $event.detail.progress"
    x-on:livewire-upload-finish.window="uploading = false; progress = 100"
    x-on:livewire-upload-error.window="uploading = false; progress = 0"
    class="relative flex flex-col items-center justify-center w-full p-6 transition border-2 border-dashed rounded-lg cursor-pointer bg-white dark:bg-gray-800
       border-gray-300 dark:border-gray-600 hover:border-blue-500 dark:hover:border-blue-400
       focus:outline-none focus:ring-2 focus:ring-blue-400
       shadow-sm
       duration-200 ease-in-out
       "
    :class="{ 'border-blue-500 bg-blue-50 dark:bg-blue-900 shadow-md': isDragging }" x-ref="dropzone">

    <template x-if="!filePreview">
        <div class="flex flex-col items-center select-none">
            <x-flux::icon.arrow-up-on-square class="w-6 h-6 text-blue-900 dark:text-white" />
            <p class="mb-1 text-lg font-semibold text-gray-700 dark:text-gray-300">Drag & drop your Image Here</p>
            <p class="text-sm text-gray-500 dark:text-gray-400">or click to browse</p>
        </div>
    </template>

    <template x-if="filePreview">
        <div class="relative w-full max-w-sm p-4 bg-white dark:bg-gray-900 border border-gray-300 dark:border-gray-700 rounded-lg shadow-lg flex items-center space-x-4 animate-fadeIn"
            @click.stop>
            <!-- Image preview -->
            <div class="shrink-0 w-20 h-20 overflow-hidden rounded-md border border-gray-200 dark:border-gray-600">
                <img :src="filePreview" alt="Preview" class="object-cover w-full h-full" draggable="false" />
            </div>

            <!-- File info -->
            <div class="flex-1 min-w-0">
                <p class="text-sm font-medium text-gray-900 dark:text-gray-100 truncate" x-text="fileName"
                    title="" x-bind:title="fileName"></p>
                <p class="text-xs text-gray-500 dark:text-gray-400 select-none">Selected file</p>

                <!-- ✅ Upload progress bar -->
                <div x-show="uploading" class="w-full mt-1 h-2 bg-gray-200 rounded-full overflow-hidden">
                    <div class="h-2 bg-blue-500 transition-all" :style="'width: ' + progress + '%;'"></div>
                </div>
                <p x-show="uploading" class="text-xs text-gray-500 mt-1" x-text="progress + '%'"></p>
            </div>

            <!-- Remove button -->
            <button type="button" @click.stop="clearFile()"
                class="inline-flex items-center justify-center w-8 h-8 text-gray-400 rounded-full hover:bg-gray-200 hover:text-gray-700 dark:hover:bg-gray-700 dark:hover:text-gray-300 transition"
                aria-label="Remove selected file" title="Remove file">
                <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5" fill="none" viewBox="0 0 24 24"
                    stroke="currentColor" stroke-width="2">
                    <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </div>
    </template>

    <input type="file" x-ref="fileInput" class="hidden" wire:model="{{ $model }}"
        accept="{{ $acceptedFileTypes }}"
        x-on:change="
            const file = $refs.fileInput.files[0];
            if (file) {
                handleFile(file);
                @this.clearError('{{ $model }}')
                $dispatch('file-selected', { fileName: file.name, file: file });
            }
        " />

    {{-- Error Message --}}
    @error($model)
        <flux:error name="{{ $model }}" />
    @enderror
</div>

<!-- Add this style to your CSS or Tailwind config if you want fade-in animation -->
<style>
    @keyframes fadeIn {
        from {
            opacity: 0;
        }

        to {
            opacity: 1;
        }
    }

    .animate-fadeIn {
        animation: fadeIn 0.3s ease-out forwards;
    }
</style>
