@props([
    'name',
    'title',
    'image',
    'bio',
    'id'
])

<div 
    x-data="{ open: false }"
    class="bg-white dark:bg-gray-800 rounded-xl border border-gray-200 dark:border-gray-700 shadow-sm hover:shadow-lg transition-all duration-300 overflow-hidden group flex flex-col"
>

    <!-- Image -->
    <div class="overflow-hidden relative">
        <img 
            src="{{ asset($image) }}" 
            alt="{{ $name }}"
            class="w-full h-64 object-cover transform transition duration-500 filter grayscale group-hover:grayscale-0"
        >
        <div class="absolute inset-0 bg-black/60 group-hover:bg-black/0 transition duration-500"></div>
    </div>

    <!-- Content -->
    <div class="p-6 flex flex-col font-monst flex-1 justify-between">
        <div>
            <h3 class="text-xl font-semibold text-gray-900 dark:text-white">{{ $name }}</h3>
            <p class="text-sky-700 dark:text-sky-400 font-medium tracking-wide text-sm mt-1">{{ $title }}</p>
        </div>

        <button 
            @click="open = true"
            type="button"
            class="mt-6 inline-flex items-center justify-center gap-2 text-sm font-semibold text-sky-700 hover:text-white hover:bg-sky-700 border border-sky-700 px-4 py-2 rounded-lg transition-all duration-200"
        >
            Read More
            <x-flux::icon.arrow-right class="w-4 h-4 group-hover:rotate-45"/>
        </button>
    </div>

    <!-- Modal ... -->
    <div 
    x-show="open" 
    x-transition.opacity
    x-cloak
    x-effect="document.body.classList.toggle('overflow-hidden', open)"
    class="fixed inset-0 z-50 flex items-center justify-center bg-black/60 px-4 py-6"
    style="display: none;"
>
    <div 
        @click.away="open = false"
        class="bg-white dark:bg-gray-900 rounded-xl w-full max-w-2xl shadow-2xl relative max-h-[90vh] flex flex-col"
    >
        <!-- Header -->
        <div class="p-6 border-b border-gray-200 dark:border-gray-700">
            <button 
                @click="open = false"
                class="absolute top-4 right-4 text-gray-500 hover:text-gray-900 dark:hover:text-white"
            >
                ✕
            </button>

            <h3 class="text-2xl font-semibold text-gray-900 dark:text-white">
                {{ $name }}
            </h3>

            <p class="text-sky-700 dark:text-sky-400 font-medium mt-1">
                {{ $title }}
            </p>
        </div>

        <!-- Scrollable Content -->
        <div class="p-6 overflow-y-auto">
            <div class="text-gray-700 dark:text-gray-300 leading-relaxed space-y-4">
                {!! $bio !!}
            </div>
        </div>
    </div>
</div>

</div>

