@props(['label', 'field' => null, 'sortable' => false, 'sortField' => null, 'sortDirection' => null])

<th class="px-6 py-4 whitespace-nowrap text-left">
    @if ($sortable && $field)
        <button wire:click="sortBy('{{ $field }}')" class="flex items-center gap-1 capitalize font-semibold">
            {{ $label }}

            @if ($sortField === $field)
                <span class="text-[#F78F20]">
                    {{ $sortDirection === 'asc' ? '↑' : '↓' }}
                </span>
            @endif
        </button>
    @else
        {{ $label }}
    @endif
</th>
