@props([
      'up_title' => 'CURRENT RATES',
'title' => config('app.name') . ' Member Care',
    'subtitle' => 'Competitive rates designed to help your money grow with confidence.',
    'rates' => [],
    'ptTop' => '',
])

<section {{ $attributes->merge(['class' => 'relative py-8 ' . $ptTop . ' bg-gray-50 dark:bg-gray-950 font-sans border-t border-gray-200 dark:border-gray-800']) }}>
    
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 fade-in-up">

        <!-- Section Header -->
        <div class="text-center mb-16">
            <p class="text-sm font-semibold tracking-wide text-primary-600 dark:text-primary-400 mb-4">
                {{ $up_title }}
            </p>

            <h2 class="text-3xl sm:text-4xl lg:text-5xl font-semibold tracking-tight text-gray-900 dark:text-white mb-4">
                {{ $title }}
            </h2>

            <p class="text-lg text-gray-600 dark:text-gray-400 max-w-2xl mx-auto">
                {{ $subtitle }}
            </p>
        </div>

        <!-- Rates Container -->
        <div class="bg-white dark:bg-gray-900 border border-gray-200 dark:border-gray-800 rounded-xl overflow-hidden">

            <!-- Accent Line -->
            <div class="h-1 bg-primary-600 w-full"></div>

            <div class="grid sm:grid-cols-2 lg:grid-cols-{{ count($rates) }}">

                @foreach($rates as $index => $rate)
                    <div class="p-10 text-center
                        @if($index !== count($rates) - 1)
                            border-b lg:border-b-0 lg:border-r border-gray-200 dark:border-gray-800
                        @endif">

                        <div class="w-14 h-14 mx-auto mb-6 flex items-center justify-center 
                                    rounded-lg bg-primary-50 dark:bg-primary-900/30 
                                    text-primary-600 dark:text-primary-400">
                            <x-flux::icon :name="$rate['icon']" class="w-5 h-5" />
                        </div>

                        <p class="text-sm font-medium text-gray-500 dark:text-gray-400 tracking-wide mb-3">
                            {{ $rate['label'] }}
                        </p>

                        <p class="text-4xl font-semibold tracking-tight text-gray-900 dark:text-white">
                            {{ $rate['value'] }}
                        </p>

                        <p class="text-sm text-gray-500 dark:text-gray-400 mt-2">
                            {{ $rate['type'] }}
                        </p>
                    </div>
                @endforeach

            </div>
        </div>

        <!-- Disclaimer -->
        <div class="text-center mt-8">
            <p class="text-sm text-gray-500 dark:text-gray-400">
                *Annual Percentage Yield. Rates subject to change. Terms and conditions apply.
            </p>
        </div>

    </div>
</section>
