@props([
    'title' => '',
    'description' => '',
    'updated' => '',
    'textColor' => 'text-gray-900 dark:text-gray-50',
    'sections' => [], // Array of sections ['heading' => '', 'content' => '', 'table' => ['headers' => [], 'rows' => []]]
])

<section class="relative bg-gray-50 dark:bg-gray-900 py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 space-y-10 fade-in-up">
        @if ($updated)
            <p class="italic text-sm">{{ $updated }}</p>
        @endif
        <!-- Main Title -->
        @if($title)
            <h1 class="text-primary-600 text-3xl md:text-4xl font-semibold tracking-wide">
                {{ $title }}
            </h1>
        @endif

        <!-- Description -->
        @if($description)
            <p class="text-gray-700 dark:text-gray-300 text-base md:text-lg leading-relaxed max-w-3xl">
                {!! $description !!}
            </p>
        @endif

        <!-- Sections -->
        <div class="space-y-8">
            @foreach($sections as $section)
                <div class="space-y-4">
                    @if(!empty($section['heading']))
                        <h2 class="text-xl md:text-2xl font-semibold {{ $textColor }}">
                            {{ $section['heading'] }}
                        </h2>
                    @endif

                    @if(!empty($section['content']))
                        <div class="text-gray-700 dark:text-gray-300 text-sm md:text-base leading-relaxed space-y-2">
                            {!! $section['content'] !!}
                        </div>
                    @endif

                    @if(!empty($section['table']))
                        <div class="overflow-x-auto mt-4">
                            <table class="min-w-full border border-gray-200 dark:border-gray-700 text-left text-gray-700 dark:text-gray-300">
                                <thead class="bg-gray-100 dark:bg-gray-800">
                                    <tr>
                                        @foreach($section['table']['headers'] ?? [] as $header)
                                            <th class="px-4 py-2 font-medium border-b border-gray-200 dark:border-gray-700">{{ $header }}</th>
                                        @endforeach
                                    </tr>
                                </thead>
                                <tbody class="bg-white dark:bg-gray-900 divide-y divide-gray-200 dark:divide-gray-700">
                                    @foreach($section['table']['rows'] ?? [] as $row)
                                        <tr>
                                            @foreach($row as $cell)
                                                <td class="px-4 py-2 border-b border-gray-200 dark:border-gray-700">{{ $cell }}</td>
                                            @endforeach
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @endif
                </div>
            @endforeach
        </div>
    </div>
</section>
